
/* Copyright 1982 by David Zittin, Biosciences Data Centre. */
#include <stdio.h>
#include "usr.h"

#define BAD -1
#define EOS '\0'

#define GROUP 0
#define ECHO 1
#define LABEL 2
#define TITLE 3
#define FILENAME 4

char *errstr = " bad option \"%s=%s\"";
char *blankstr = " ";
char *cmdlist[] = {	"group", "echo", "label", "title",
			""
		  };

int usrcmd(str)
char *str;
{
	register int nf;
	int sparse(), argtype(), strcmp();
	char *bp[2], *strsave();

	nf = sparse (++str, bp, '='); 

	switch( argtype(bp[0]) ) {
		case TITLE:	usr.title = strsave(bp[1]);
				break;

					/* do NOT cfree the null group case! */
		case GROUP:	if ( usr.group != blankstr)
					cfree(usr.group);
				if (nf == 1)	/* usr opt to cancel group */
					usr.group = blankstr;
				else if (!(strcmp(bp[1], "FILENAME")))
					usr.label = AUTO;
				else if (!(strcmp(bp[1], "LABEL")))
					usr.label = ON;
				else
					usr.group = strsave(bp[1]);
				break;


		case ECHO:	
				usr.echo =  strcmp(bp[1], "off");
				break;

		case LABEL:	if (!(strcmp(bp[1], "off")))
					usr.label = OFF;	
				else if (!(strcmp(bp[1], "on")))
					usr.label = ON;
				else if (!(strcmp(bp[1], "auto")))
					usr.label = AUTO;
				else
					err(errstr,bp[0],bp[1]);
				break;

		case BAD:	err(errstr,bp[0],bp[1]);
				return (BAD);
				break;
		} /* swt */
return(0);
} /* routine */

int argtype(s)
char *s;
{
	int strcmp(), i;

	for (i=0; *cmdlist[i] != EOS; i++)
		if ( strcmp(cmdlist[i], s) == 0) 
			return(i);
	return (BAD);
}

usrinit(){
/* set defaults */
	usr.initflag = ON;
	usr.fname = "";		/* data file name */
	usr.label = OFF;		/* deflt=no usr supplied data label */
	usr.echo = ON;		/* echo flag */
	usr.line = 0;		/* line in data file */
	usr.group = blankstr;	/* statistical group */
	usr.title = blankstr;		/* ptr to usr title */
}
