
/* Copyright 1982 by David Zittin, Biosciences Data Centre. */
#define onetail 0
#define twotail 1
#define TEST(x) (x)?(nullstr):(unlike)
#define EPSILON 0.00000001

char *nullstr="";
char *unlike="un";
char *onestr="ONE";
char *twostr="TWO";
char *srstr="Rs";
char *tstr="t";

significant(s1, s2, n, src)
char *s1, *s2;			/* name of 2 grps cmpared */
int n;				/* their size */
double src;			/* spearman rank correl coeff */	
{
	double tmp, stat, fabs(), sqrt(), tprob();
	static char *fmt="\t\tit is %slikely Rs is significant.\n";
	static char *fmt1="\n   %s-TAILED TEST (p=0.05)\n\ttabulated %s = %g\n";
	static char *fmt2="\tno table val. for n=%d\n";
	float tabvals[2];
	int lookup();

	printf("\n\n\nCONCLUSION(%s vs %s):\n\tSpearman Rank Correlation Coeff. (Rs) = %g\n\tn = %d\n\tdf = %d\n", s1, s2, src, n, n-2);

	if (n >= 10){
		if ((tmp = 1.0 - src * src) < EPSILON)
			printf("\tcan't divide:1-Rs almost zero (Siegel 9.8).\n\t\tprobably highly significant.\n");
		else{
			stat = src * sqrt ( (n - 2.0)/tmp );
			printf("\tcalculated t = %g\n", stat);
			tmp = tprob(0.1, n-2);
			printf(fmt1, onestr, tstr, tmp);
			printf(fmt, TEST(fabs(stat) >= tmp));

			tmp = tprob(0.05, n-2);
			printf(fmt1, twostr, tstr, tmp);
			printf(fmt, TEST(fabs(stat) >= tmp));
		}
	}
	else {
		if (!(lookup(n, tabvals))){
			printf("\tcan't find table value for n=%d\n", n);
			return;
		}
		if (tabvals[onetail] > 0) {
			printf(fmt1, onestr, srstr, tabvals[onetail]);
			printf(fmt, TEST(fabs(src) >= tabvals[onetail]));
		}
		else
			printf(fmt2, n);

		if (tabvals[twotail] > 0){
			printf(fmt1, twostr, srstr, tabvals[twotail]);
			printf(fmt, TEST(fabs(src) >= tabvals[twotail]));
		}
		else
			printf(fmt2, n);
	}
}
