
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include <stdio.h>
#include <signal.h>
#include "bufdef.h"
#include "iodef.h"
#include <debug.h>

#define EOS '\0'
#define READ 0
#define BADFILE -1

char *nospace="nospace";
char *badopen = "Can't open %s";
char *use = "usage:spell [-[g]][gfile][-cwdns#Nl#][dfile][files]";
char *illtmps = "tmpfls illegal";
char *dictname = "/usr/lib/dict";	/* default dictionary */

int BLOCK;

char TMPFILES[24];	/* pathway of tmp files if any are created */
int tmpfiles=0;		/* numb of tmp files opened */

int nfiles = 0;	/* count of usr files in arg list */
char *filename;		/* name of opened usr file */

main(argc,argv)
int argc;
char *argv[];
{
	FILE *fp=NULL, *pattfile=NULL, *myopen(), *fdopen();

	register char *argp;
	register int parsemode, i;
	char *malloc(), *realloc();

	int lnumber, dictflg, grepflg, fopenflg=0, wordlen;
	int k;

	int lookup(), pipein();
	int trap(), scantree(), treeprint(), sscanf();

	BLOCK = 4096;

/* defaults */

	outcount = 1;			/* output number of occurances */

	pattfile = fp = stdin;		/* pattfile and text file=stdin */

	parsemode = MINE;		/* default word parse */

	dictflg = MINE;			/* /usr/lib/dict */

	lnumber = 0;			/* no ln number in grep mode */

	grepflg = 0;			/* word grep flag */

	countflg = 0;			/* word preceded with count? */

	wordlen = 2;			/* default min wrdlen */

	if((dictfd = open(dictname, READ)) == BADFILE)
		err(badopen, dictname);

	dwordsiz = MAXDICTWORDS;
	iobsiz = IOBSIZ;
	iobsiz += dwordsiz;		/* alloc the dictionary input buffer */
	if(!(io_buf=malloc(iobsiz)))
		err(nospace);
	readbase = io_buf + dwordsiz;	/* assign ptrs as needed in lookup */
	_dictiop = endbuf = readbase + IOBSIZ;

/* signal processing */
	if (signal(SIGINT,1) != SIG_IGN)
		signal(SIGINT, trap); 		/* catch attn intrps */
	signal(SIGPIPE, trap);			/* catch broken pipes */




/* process args */
	for(i=1; i < argc; i++){

		argp = argv[i];

		switch(*argp) {
		case '-':
			do {
				switch (*(++argp)){

				case 'l':	++argp;	
						if (sscanf(argp,"%d", &dwordsiz) != 1)
							err(use);
						iobsiz += dwordsiz;
						if(!(io_buf=realloc(io_buf,iobsiz)))
							err(nospace);
						readbase=io_buf+dwordsiz;
						_dictiop=endbuf=readbase+IOBSIZ;
						break;
				case 'k':	outcount=0;
						break;

				case 'w':	parsemode = USR;
						break;

				case 'u':	dictflg = NONE;
						free(io_buf);
						parsemode = USR;
						break;

				case 'c':	++countflg;
						parsemode = USRCNT;
						break;

				case 'd':	
						dictflg = USR;
						close(dictfd);
						if((dictfd=open(argv[++i],READ)) == BADFILE)
							err(badopen,argv[i]);
						break;

#ifdef DEBUG
				case 'D':	debug++;
						break;
#endif

				case 'n':	dictflg = NONE;
						free(io_buf);
						break;

				case 's':	++argp;
						if (sscanf(argp,"%d", &wordlen) != 1)
							err(use);
						break;

				case 'N':	lnumber = 1;
						break;

/* read pattns from file */
				case 'g':
						++grepflg;
						pattfile = myopen(pattfile,argv[++i],"r");
					/* count no. files in arglist */
						for(k=i+2; k<argc; k++)
							if (*(argv[k])!='-' )
								++nfiles;
						parse(parsemode,wordlen,0,lnumber,pattfile);
						if (tmpfiles)	/* no tmpf allowed */
							myerr(illtmps);
						break;


				case EOS:  /* dash only-stdin */
						if(argp - argv[i]==1){
							++fopenflg;
							filename = "-";
							fp = myopen(fp,"-","r");
							parse(parsemode,wordlen,grepflg,lnumber,fp);
						}
						break;

				default:	myerr("%s",use);
						break;
				} /* sw */

			} /* do */
			while(*(argp));
			break;	 	/* case == '-' */


			default:	/* filename, not switch */
				fp=myopen(fp,argp,"r");
				++fopenflg;
				filename = argv[i];
				parse(parsemode,wordlen,grepflg,lnumber,fp);
				break;
		} /* sw */
	} /* for args in cmd list */


	if (!(fopenflg)) {	/* no files opened...use stdin */
		fp = myopen(fp, "-", "r");
		parse(parsemode, wordlen, grepflg,lnumber,fp);
	}


	if(grepflg)	/* word grep only, no dictionary stuff, exit */
		exit(0);

	if ( !(tmpfiles) ) {
		switch (dictflg){	/* all words in tree */
			case MINE:	scantree(lookup);
					break;
	
			case USR:	scantree(lookup);	/* user's dict */
					break;
	
			case NONE:	scantree(treeprint);	/* no dict */
					break;
		} /* sw */
	}

	else { 			/* there are temp files */

		sprintf(buf,"sort -m +1 -2 %s", TMPFILES);
		fp=fdopen(pipein("/bin/sh", "sh", "-c",buf,0), "r");

		switch(dictflg){
			case MINE:	scantmp(fp, lookup);
					break;

			case USR:	scantmp(fp, lookup);
					break;

			case NONE:	scantmp(fp, treeprint);
					break;
		} /* sw */	


		rm_temp(); 	/* rm tmp files */
	} /* else */

} /* main */
