#include <stdio.h>
#include "usrcmds.h"

#define BAD -1
#define EOS '\0'

#define GROUP 0
#define ECHO 1
#define LABEL 2
#define TITLE 3
#define OUTFMT 4

char *errstr = " bad option \"%s=%s\"";
char *blankstr = " ";
char *cmdlist[] = {	"group", "echo", "label", "title",
			"1", ""
		  };
/* char *filemsg = "can't open"; */

int usrcmd(str)
char *str;
{
	register int nf;
	int sparse(), argtype(), strcmp();
	char *bp[2], *strsave();

	nf = sparse (++str, bp, '='); 

	switch( argtype(bp[0]) ) {
		case TITLE:	usrcmds.title = strsave(bp[1]);
				break;

					/* do NOT cfree the null group case! */
		case GROUP:	if ( usrcmds.group != blankstr)
					cfree(usrcmds.group);
				if (nf == 1)	/* usr opt to cancel group */
					usrcmds.group = blankstr;
				else
					usrcmds.group = strsave(bp[1]);
				break;

/* 
		case TREEF:	if ((usrcmds.treef=fopen(bp[1], "r"))==NULL){
					fprintf(stderr,"%s %s\n",filemsg,str);
					return (BAD);
				}
				break;

		case DATAF:	if ((usrcmds.dataf=fopen(bp[1], "r"))==NULL){
					fprintf(stderr,"%s %s\n",filemsg,str);
					return(BAD);
				}
				break;
*/

		case ECHO:	
				usrcmds.echo =  strcmp(bp[1], "off");
				break;

/*
		case FIELD:	if(sscanf(bp[1],"%d",&usrcmds.field) != 1){
					fprintf(stderr,"%s:bad field \"%s\"\n",usrcmds.prog,str);
					return(BAD);
				}
				usrcmds.field--;
				break;
*/

		case LABEL:	if (!(strcmp(bp[1], "off")))
					usrcmds.label = OFF;	
				else if (!(strcmp(bp[1], "auto")))
					usrcmds.label = AUTO;
				else if (!(strcmp(bp[1], "on")))
					usrcmds.label = ON;
				else
					errmsg(errstr,bp[0],bp[1]);
				break;

		case OUTFMT:	usrcmds.outfmt = COLUMNAR;
				break;

		case BAD:	errmsg(errstr,bp[0],bp[1]);
				return (BAD);
				break;
		} /* swt */
return(0);
} /* routine */

int argtype(s)
char *s;
{
	int strcmp(), i;

	for (i=0; *cmdlist[i] != EOS; i++)
		if ( strcmp(cmdlist[i], s) == 0) 
			return(i);
	return (BAD);
}

usrinit(){
/* set defaults */
	usrcmds.initflag = ON;
	usrcmds.fname = "";		/* data file name */
	usrcmds.label = OFF;		/* deflt=no usr supplied data label */
	usrcmds.echo = ON;		/* echo flag */
	usrcmds.line = 0;		/* line in data file */
	usrcmds.group = blankstr;	/* statistical group */
	usrcmds.title = NULL;		/* ptr to usr title */
	usrcmds.outfmt = HORIZONTAL;		/* output in horiz form */
}
