#include <stdio.h>
#include <pf.h>

#include "usr.h"
#define EOS '\0'

/* vbarwidth is half of the length of the vbars as (xmin-xmax)/vbarwidth */
/* a fuge factor */
#define VBARWIDTH 140.0

/* def the types of line joins */
#define JOINFLG 'j'
#define XSORTFLG 'x'
#define YSORTFLG 'y'
#define VERTICAL 'v'

#define BADCONV err(badconv,usr->progname,usr->line)

char *badeod = "%s:unexpected eod";
char *badconv = "%s:line %d bad number";

char gen_buf[100];

struct minmaxv {		/* xmin, xmax, ymin, ymax */
	float	minx,	maxx,	miny,	maxy;
} mm;


double horiz;		/* global in which horiz diplacement is stored */
			/* used when vertical bars are plotted */


/* verical bar struct */
struct verticalbar {
	float up, down;
};

/* side list structure */
struct datanode {
	struct datanode *next;
	struct verticalbar *vb;
	float	x;
	float	y;
};


/* NOTE: if new point types are added, 3 changes are necessary:
	1. a new define (as below)
	2. a new element in the graph_anchor array
	3. add to ga_find()
*/

#define NP 0
#define X 1
#define PLUS 2
#define RT 3
#define DT 4
#define LT 5
#define UT 6

/* spine of the side list. each member refers to particular graph pointtype */
struct graph_anchor {
	char *ptype;			/* ptr to str with name of the point */
	char *usrstr;			/* ptr to user's str assoc with pt */
	char join;			/* true:draw lines between pts */
	char vbar;
	int cnt;			/* count of link list elements */
	struct datanode *start, *end;
} g_anchor[] = {
		"np", "", EOS, EOS, 0, NULL, NULL,
		"x",  "", EOS, EOS, 0, NULL, NULL,
		"+",  "", EOS, EOS, 0, NULL, NULL,
		"rt", "", EOS, EOS, 0, NULL, NULL,
		"dt", "", EOS, EOS, 0, NULL, NULL,
		"lt", "", EOS, EOS, 0, NULL, NULL,
		"ut", "", EOS, EOS, 0, NULL, NULL,
		"",   "", EOS, EOS, 0, NULL, NULL
	};


makelist (fp)
register FILE *fp;
{

	register struct graph_anchor *ga;
	register struct datanode *dp;
	struct graph_anchor *ga_find();
	char *type, *xs, *ys;
	char *myalloc();
	static int first=1;
	int getdata(), sscanf();
	float xval, yval, up_vb, down_vb;
		

	while (getdata (&type,fp) != EOF){
		if (usr->label == ON) {		/* get x and y strs */
			if ( getdata(&xs,fp)==EOF || getdata(&ys,fp)==EOF)
				err(badeod,usr->progname);
		}

		else{
			xs = type;
			if ( usr->label == OFF)
				type = usr->group;
			else if (usr->label == AUTO)
				type = usr->filename;
			if (getdata(&ys,fp) == EOF)
				err(badeod,usr->progname);
		}




		if (sscanf(xs,"%f", &xval) != 1 || sscanf(ys, "%f", &yval) != 1)
			BADCONV;


		ga = ga_find (type);		/* find approp point type */

						/* alloc a side node */
		if ((dp = (struct datanode *) myalloc(sizeof(*dp))) == NULL)
			NOSPACE;

	/* if side list empty, remember start of list otherwise link */
		(ga->start) ? (ga->end->next = dp) : (ga->start = dp);

	/* inc counter for point type */
		ga->cnt++;


	/* save xmin, xmax, ymin, ymax */
		if (first){
			mm.minx = mm.maxx = xval;
			mm.miny = mm.maxy = yval;
			--first;
		}
		else {
			if (xval < mm.minx)	mm.minx = xval;
			if (xval > mm.maxx)	mm.maxx = xval;
			if (yval < mm.miny)	mm.miny = yval;
			if (yval > mm.maxy)	mm.maxy = yval;
		}

		dp->next = NULL;
		dp->x = xval;
		dp->y = yval;
		ga->end = dp;

		if (ga->vbar) {	/* reuse xs and ys to get up and down */
			if (getdata(&xs,fp) == EOF || getdata(&ys,fp) == EOF)
				err(badeod,usr->progname);

			if (sscanf(xs,"%f", &up_vb)!= 1 || 
						sscanf(ys,"%f", &down_vb)!= 1)
				BADCONV;

			if ((dp->vb=(struct verticalbar *) myalloc(sizeof(*dp->vb))) == NULL)
				NOSPACE;
			dp->vb->up = up_vb;
			dp->vb->down = down_vb;
			if (yval + up_vb > mm.maxy)	mm.maxy = yval + up_vb;
		} /* if vertbar */

		else
			ga->vbar = NULL;


	}	/* while */
}

send_grid(){
	double xticks, yticks;
	double xmin, xmax, ymin, ymax;
	double my_length = 6.5;
	double shift = 0.1;		/* magic fudge factor for title */

/* xaxis set up */
	xmin = mm.minx;
	xmax = mm.maxx;
	grid_setup(&xmin, &xmax, &xticks);

	if (!(usr->set[XMIN]))
		usr->xmin =  xmin;
	if (!(usr->set[XMAX]))
		usr->xmax = xmax;


/* yaxix set up */
	ymin = mm.miny;
	ymax = mm.maxy;
	grid_setup(&ymin, &ymax, &yticks);

	if (!(usr->set[YMIN]))
		usr->ymin = ymin;
	if(!(usr->set[YMAX]))
		usr->ymax = ymax;


/* set up ticks and axis lengths */
	if (!(usr->set[XT]))
		usr->xt = xticks;
	if (!(usr->set[YT]))
		usr->yt = yticks;
	if (!(usr->set[XLEN]))
		usr->xlen = my_length;
	if (!(usr->set[YLEN]))
		usr->ylen = my_length;

			/* calc the length (usr units) of the horiz line */
	horiz = (usr->xmax - usr->xmin) / VBARWIDTH;

	cplot(G2, usr->pf, usr->xmin, usr->xmax, usr->ymin, usr->ymax, usr->xt, usr->yt, usr->xlen, usr->ylen, usr->xlab, usr->ylab);

	if ( *(usr->title) )
		cplot(WR, usr->pf, usr->xmin + shift * (usr->xmax - usr->xmin) / usr->xlen, usr->ymax + shift * (usr->ymax - usr->ymin) / usr->ylen, 0.15, 0.15, 0.0, usr->title);

}

dumplist()		/* do a data echo if requested */
{
	register struct graph_anchor *ga;
	register struct datanode *dp;
	int sprintf();

	sprintf(gen_buf,"%s:DATA ECHO==>\n", usr->title);
	cplot(PR, usr->pf, gen_buf);

	for(ga = g_anchor; *(ga->ptype); ++ga){		/* runthru pointtypes */
		if (ga->start){				/* report if list */
			sprintf(gen_buf, "point %s:%s", ga->ptype,ga->usrstr);
			cplot(PR, usr->pf, gen_buf);
		}
		for (dp=ga->start; dp; dp = dp->next){
			sprintf(gen_buf, "\t%g  %g", dp->x, dp->y);
			cplot(PR, usr->pf, gen_buf);
		}
	}
	cplot(PR, usr->pf, "\n\n");
}


send_xy(){			/* send the xy coords to the pf. */
				/* print a list of strings assoc with */
				/* each point if usr specified (@ptitle). */
				/* determine whether plot is joined line */
				/* or scatter. */

	register struct graph_anchor *ga;
	int sprintf();

	for(ga = g_anchor; *(ga->ptype); ++ga){
		if ( ga->cnt ){		/* pr usrstr on stdout */
			sprintf(gen_buf, "point %s:%d xy pairs:%s",ga->ptype,ga->cnt,ga->usrstr);
			cplot(PR, usr->pf, gen_buf);
		}
		if ( !(ga->cnt) )	/* don't plot zero len lists */
			continue;



			/* set point type before calling plot routine */
		if ( *(ga->ptype) != 'n')
			cplot(SP, usr->pf, ga->ptype);


			/* call approp routine */
		( ga->join ) ? (join_line(ga)) : (scatter(ga)); 
	}
}


scatter(ga)
register struct graph_anchor *ga;
{
	register struct datanode *dp;
			/* chk for np option, can't plot np scatter! */

	if ( *(ga->ptype) == 'n' && *(++ga->ptype) == 'p' )
		return;

					/* do the scatter plot */
	cplot(PU, usr->pf);

	for (dp=ga->start; dp; dp=dp->next){
		cplot(GO, usr->pf, dp->x, dp->y);
		cplot(DP, usr->pf);
		if (ga->vbar)
			send_vbars(dp->x, dp->y, dp->vb->up, dp->vb->down,true);
	}
}

join_line(ga)
register struct graph_anchor *ga;
{
	register struct datanode **vp, *dp;
	static struct datanode **data_vec;

	char *myalloc();
	int find_max(), xsort(), ysort(), (*sortcmp)();
	static int first=1;


	switch (ga->join){
		case XSORTFLG: sortcmp = xsort; break;
		case YSORTFLG: sortcmp = ysort; break;
		case JOINFLG:  sortcmp = 0;  break;
	} /* sw */


/* put the penup */
	cplot(PU, usr->pf);	

/* if sort:put dataptrs in vect and sort on x or y */
	if (sortcmp) {
		if ( first ) {
			--first;
				/* alloc sort vec. add 1 for terminator */
			if(!(data_vec=(struct datanode **) myalloc(find_max()*sizeof(*vp)+sizeof(*vp))))
				NOSPACE;
		}
		vp = data_vec;

			/* load vector of ptrs to link list */
		for (dp=ga->start; dp; dp = dp->next)
			*vp++ = dp;
		*vp = NULL;		/* end of vector flg */
		vp = data_vec;
		qsort(vp, ga->cnt, sizeof(struct datanode *), sortcmp);

	/* goto left most penpos with penup */
		cplot(GO, usr->pf, (*vp)->x, (*vp)->y);
		cplot(PD, usr->pf);				/* pen dwn */
		if ( *(ga->ptype) != 'n')
			cplot(DP, usr->pf);
		if (ga->vbar)
			send_vbars((*vp)->x,(*vp)->y, (*vp)->vb->up, (*vp)->vb->down, false);



	/* draw line with points */
		for(vp = ++vp; *vp ; vp++) {		/* draw line */
			cplot(GO, usr->pf, (*vp)->x, (*vp)->y);
			if ( ga->vbar )
				send_vbars((*vp)->x,(*vp)->y, (*vp)->vb->up, (*vp)->vb->down, false);
			if ( *(ga->ptype) != 'n' )	/* don't draw if np */
				cplot(DP, usr->pf);
		}
	} /* if */


/* no sort:draw line in order of data, get data directly from data list */
	else {
				/* goto left most penpos with penup */
		cplot(GO, usr->pf, ga->start->x, ga->start->y);
		cplot(PD, usr->pf);	/* put pendown */

		if ( *(ga->ptype) != 'n' )
			cplot(DP, usr->pf);

		if (ga->vbar) {
			dp = ga->start;
			send_vbars(dp->x, dp->y,dp->vb->up, dp->vb->down,false);
		}

		for (dp=ga->start->next; dp; dp = dp->next){
			cplot(GO, usr->pf, dp->x, dp->y);
			if (ga->vbar)
				send_vbars(dp->x, dp->y, dp->vb->up, dp->vb->down, false);
			if ( *(ga->ptype) != 'n' )	/* don't draw if np */
				cplot(DP, usr->pf);
		}

	} /* else */
} /* join_line */


int xsort(arg1, arg2)
register struct datanode **arg1, **arg2;
{
	if ( (*arg1)->x > (*arg2)->x ) 
		return (1); 

	if ( (*arg1)->x < (*arg2)->x )
		return(-1);

	return(0);
}


int ysort(arg1, arg2)
register struct datanode **arg1, **arg2;
{
	if ( (*arg1)->y > (*arg2)->y )
		return (1);

	if ( (*arg1)->y < (*arg2)->y )
		return(-1);

	return(0);
}



set_misc(type, point)
char *type, *point;
{
	register struct graph_anchor *ga;

		if ( *point )		/* set one */
			set_point(type, point);

		else {					/* set all */
			for(ga = g_anchor; *(ga->ptype); ++ga)
				set_point(type,ga->ptype);
		}
}


set_point(type,point)
char *type, *point;
{
	register struct graph_anchor *ga;	
	struct graph_anchor *ga_find();

	ga = ga_find(point);

	switch (*type) {
		case JOINFLG:
		case XSORTFLG:
		case YSORTFLG:	ga->join = *type;
				break;

		case VERTICAL:
				ga->vbar++;
				break;
	} /* sw */
}
		

set_str(point, s)	/* given a pointtype, attach a usr str. use calloc, */
char *point, *s;	/* not myalloc to save str. this is for future use of */
{			/* tmpfiles:myfree() releases all space obtained */
			/* by myalloc-usr headers are always retained */

	char *strsave();
	register struct graph_anchor *ga;
	struct graph_anchor *ga_find();

	ga = ga_find(point);

	if ( *(ga->usrstr) != '\0')		/* defined before? */
		cfree( ga->usrstr );
	if ( (ga->usrstr = strsave(s)) == NULL)		/* save it */
		NOSPACE;
}

struct graph_anchor *ga_find(s)
char *s;
{
	switch(*s) {
		case 'n': return ( &g_anchor[NP] );
		case 'x': return ( &g_anchor[X] );
		case '+': return ( &g_anchor[PLUS] );
		case 'r': return ( &g_anchor[RT] );
		case 'd': return ( &g_anchor[DT] );
		case 'l': return ( &g_anchor[LT] );
		case 'u': return ( &g_anchor[UT] );
		default: err("%s:%d bad ptype \"%c\"",usr->progname,usr->line,*s);
	}
}


int find_max(){
	register struct graph_anchor *ga;
	register int max;


	for(ga=g_anchor; *(ga->ptype); ++ga){
		if ( ga == g_anchor )
			max = ga->cnt;
		else if ( ga->cnt > max )
			max = ga->cnt;
	}
	return(max);
}
