/* does the stuff that the awk programs in /usr/bin/prefs does */
 * usage a.out file.. for auth references 
 * or    a.out -n file.. for line number references
*/
#include <stdio.h>

#define BSIZ 512
char buf[BSIZ];

main(argc,argv)
int argc;
char *argv[];
{
	register int i;
	register char *argp;
	int nflag=0;
	FILE *fp=NULL, *myopen();

	for(i=1; i < argc; i++) {
		argp=argv[i];
		if(*argp == '-') {
			switch(*++argp){
			case 'n':
				nflag++;
				break;
			default:
				err("usage:%s [-n] file..");
				break;
			} /* sw */
		}
		else { /* filename */
			fp=myopen(fp,argp,"r");
			xtract(fp,nflag);
		}
	} /* for */

	if(!fp)
		xtract(stdin,nflag);
}

xtract(fp, nflag)
FILE *fp;
int nflag;
{
	static int lastline=0;
	register int line=lastline;
	register char *c;
	int cnt;

next:
	while(getln(buf,BSIZ,fp) != EOF) {
		++line;
		if(nflag) 
			printf("%d ", line);
		else {
			for(c=buf; *c != ',' && *c; ) {
				putc(*c++, stdout);
			}
			if(*c != ','){
				fprintf(stderr,"line %d has funny auth\n",line);
				goto next;
			}
			putc(' ',stdout);
		}

		for(cnt=0, c=buf; *c; c++ )
			if (*c == '|')
				if(++cnt == 2) {
					while(*++c != '|' && *c)
						putc(*c,stdout);
					putc('\n',stdout);
					goto next;
				}
		fprintf(stderr,"line %d has funny title\n", line);
	}
	lastline = line;
}
