


#include <stdio.h>
#include "table.h"
#include "usrcmds.h"
#include <ctype.h>

#ifdef HASHCHK
#define COLLISION(x) x += 1.0;
#define ENTER(x) x += 1.0;
#define TABLENTRIES(x) x++;
#define HASHSUMMARY(x,y,z) hashchk(x,y,z)
double collision=0.0, enter=0.0;
int entries=0;
hashchk(x,y,z) double x,y;int z;{fprintf(stderr,"HASH:\n\t#collisions=%g\n\t#hashf calls=%g\n\tcolls/call=%g\n\ttblitems=%d\t\n",x,y,x/y,z);}

#else
#define COLLISION(x)
#define ENTER(x)
#define TABLENTRIES(x)
#define HASHSUMMARY(x,y,z)
#endif

#define	TEST(x,a,b) ((x) ? a : b)

#define LABELSIZE 120
char labelbuf[LABELSIZE];	/* buffer for usr label */

		/* a silly number which makes the hash table work better */
#define MAGIC 5

/* tabsiz is size of has table which keeps track of group strings and
	ptr to link list of each group's data. tabsiz should always
	be a prime number */
#define TABSIZ 127
TABLE table[TABSIZ];
TABLE *endtable=table+TABSIZ;
double tmp, x;

long ntotal;		/* total number of obsv */

ndstat(){
	register int i;
	int cmp();

	qsort(table, TABSIZ, sizeof(TABLE), cmp);

		/* eat up the leading empty hash table elements */
	for(i=0; i < TABSIZ && !(table[i].hkey); i++)
		;

	fmt_setup();

	printf("\n>>GROUP STATS (var. from n-1 df):%s<<\n",TEST(usrcmds.title==NULL," ",usrcmds.title));

	for(; i < TABSIZ; i++)  {
		TABLENTRIES(entries)		/* cc conditional */
		ntotal += table[i].na;
		pr_grpstats(&table[i]);
		printf("\n\n");
	}

	HASHSUMMARY(collision,enter,entries);	/* cc conditional */

	printf("\nTOTAL %ld\t\t\t(ns=not sig, p>0.05; *=sig, p<=0.05)\n",ntotal);
}


filltable(fp)
register FILE *fp;
{
	register char *bp;
	register int c;
	long pairno=0;
	int hashdata(), sscanf();
	int fscanf();

getanother:
	while ((c=getc(fp)) != EOF && isspace(c) )
		;
	if (c == EOF) return;
	ungetc(c, fp);
	for(bp=labelbuf; (c=getc(fp)) != EOF && !(isspace(c)); bp++)
		*bp = c;
	if (c == EOF)
		return;
	*bp = '\0';
	if (fscanf(fp, "%F", &x) == EOF)
		err("bad data pair:%ld \"%s\"\n",pairno,labelbuf);
	pairno++;
	hashdata(labelbuf);
	goto getanother;
}


#define MAXALLOWED 4 / 5
int hashdata(str)
char *str;
{
	register int i=13;
	register char *c=str;
	register TABLE *tbl;
	int hval=0, displace=1;
	char *strsave(), *malloc();
	int strcmp();
	static char *nospace="hash:nospace";
	static int ntable=0;

	ENTER(enter)		/* cc conditional */

	while(*c) {
		hval += *c++ * i;
		i *= MAGIC;
	}

	if (hval < 0)
		hval = -hval;

	tbl = table + (hval % TABSIZ);

	if (tbl < table || tbl >= endtable)
		err("htab botch");


	for(;;){
		if ( !(tbl->hkey) ) {			/* at empty hole */
			if ( ++ntable > TABSIZ * MAXALLOWED)
				err("htab full");
			if (!(tbl->hkey = strsave (str)))
				err(nospace);
			tbl->na = 1;
			tbl->min = tbl->max = x;
			break;
		}

		if (!(strcmp(tbl->hkey,str))) {		/* found */
			tbl->na++;	
			if (x < tbl->min)
				tbl->min = x;
			if (x > tbl->max)
				tbl->max = x;
			break;
		}

		else {				/* collision, quad srch */
			COLLISION(collision)		/* cc conditional */
			tbl += displace;
			displace += 2;
			if (tbl >= endtable) 
				tbl -= TABSIZ;
		}
	}

		/* data accumulations */
	tbl->sum += x;
	tmp = x * x;
	tbl->sumsq += tmp;
	tbl->s3 += tmp * x;
	tbl->s4 += tmp * tmp;
}

int cmp(arg1, arg2)
TABLE *arg1, *arg2;
{
	register int cmpval;
	int strcmp();

	if (!(cmpval = strcmp(arg1->hkey, arg2->hkey) ))
		return(0);	/* equality */

	return( (cmpval > 0) ? (1) : (-1) );
}
