#include <stdio.h>

/* length of circular list */
#define MAXDEPTH (12)

/* bytes per data line */
#define MAXSTRLEN (256)
char list[MAXDEPTH][MAXSTRLEN];

int head=0, tail;	/* circular list indices */
int len;

char *cmpstr, *progname;
int cmplen;	/* len of str for strncmp() */

main(argc,argv)
int argc;
char *argv[];
{
	int sscanf(), strncmp(), strlen();
	char *fillist(), *getdata();
	register char *last;

	progname = *argv;	/* save prog name */
	if (argc != 3 || sscanf(*++argv, "%d", &len) != 1){
		fprintf(stderr, "usage: %s depth string\n", progname);
		exit(1);
	}
/* set ptr to the str to look for in db */
	cmpstr = *++argv;
	cmplen = strlen(cmpstr);
	if ( len < 0 || len > MAXDEPTH){
		fprintf(stderr,"depth bad\n");
		exit(1);
	}
	
	if ((last=fillist ()) == NULL)
		exit(0);

	do{
		if (strncmp(last, cmpstr, cmplen) == 0)
			putdata();
	}
	while ((last=getdata()) != NULL);
}

char *fillist(){ 		/* fill up the circular list */

	char *fgets();
	int i;
	for (i=head; i < len; i++){
		if (fgets(list[i],MAXSTRLEN, stdin) == NULL)
			return(NULL);
	}
	head = --i;
	tail = 0;
	return(list[head]);	
}

/* get last member of circular list and put a new one in begging */
char *getdata()
{
	char *fgets();

	head++;
	head %= len;
	tail++;
	tail %= len;
	if (fgets(list[head], MAXSTRLEN, stdin) == NULL)
		return(NULL);
	return(list[head]);
}
putdata() {
	register int i;
	
	i = tail;
	do {
		fputs(list[i++], stdout);
	}
	while ( (i %= len) != tail);
}
