/* filter that makes it nice to write from ucb mail to a notes file.
 * usage: notes.mail
 * parses incoming mail message looking for "To:" and "Subject:" before
 * the first QUIT lines of input.
 * the "To" object becomes the notesfile and the "Subject" object
 * is used to make a notes file title.
 * typical mail message:
 *	From doe Wed Sep 28 20:13:43 1983
 *	To: gripes
 *	Subject: blah blah
 *
 *	i do not like anything about this data centre:stuff it!
 *
*/

#include <stdio.h>
#define QUIT	4

#define BSIZ	512
char buf[BSIZ];
char Tobuf[24];
char Subjbuf[128];

char *index();
char *fgets();
FILE *fopen();

int Subjflg, Toflg, line;


main(argc,argv)
int argc;
char *argv[];
{
	register char *p;
	register FILE *pstream;

	while(fgets(buf, BSIZ, stdin)) {
		if (++line > QUIT)	/* have not found a "Subject:" */
			break;
		p = index(buf, ':');	/* look for a blank */
		if (p) {
			if (strncmp(buf, "To:", 3) == 0) {
				++Toflg;
				strcpy(Tobuf, p + 2);
			}
			else if(strncmp(buf, "Subject:", 8) == 0) {
				++Subjflg;
				strcpy(Subjbuf, p + 2);
				break;
			}
		}
	}
	if (Subjflg && Toflg) {
		*(index(Subjbuf,'\n')) = '\0';
		*(index(Tobuf,'\n')) = '\0';
		sprintf(buf, "nfpipe %s -t '%s'", Tobuf, Subjbuf);
		pstream = popen(buf, "w");
		if(pstream == (FILE *) 0)
			err("%s:bad popen",argv[0]);
		while(fgets(buf, BSIZ, stdin))
			fputs(buf, pstream);
		exit(0);
	}
	exit(1);
}
