#
#include <stdio.h>
#include <signal.h>

#define BSIZ 		1024
#define NFLDS		128
#define NIL		(FILE *) 0
#define MAXPROMPTS	12
#define void
#define SUCCEEDED	0
#define FAILED		1

char Buf[BSIZ];			/* general Buffer for input and misc */
char *Fld[NFLDS];		/* pointer to record fields */
char Fldsep = ' ';		/* default field separator */
char *Tmpname = "/tmp/AppXXXXXX";	/* tmporary file name */
char *mktemp();
char *Datafname;		/* name of data file */
char *fgets();
char *usage = "usage:%s [-Fx] [-p#[#,...]] [-o file] file [file...]";

int debug;
int atten(), attenflg;		/* do not allow SIGINT on write backs */
int writeback;			/* true if writing back to orinal data file */
int Nprompt=1;			/* number of fields to prompt with */
int F[MAXPROMPTS] = {0};	/* indices of the prompt fields. deflt fld=1 */
int rm_tmp();			/* rm temp file if present */
int exitno=1;			/* exit number on interupt, zero otherwise */

				/* note:in C'ese fld1 = Fld[0] */
FILE *myopen(), *fopen();
FILE	*Output=stdout,		/* where record and append info is written */
	*Prompt,		/* where to write the Prompt */
	*Reply=stdin;		/* where to read the append string */


main(argc, argv)
int argc;
char *argv[];
{
	register char *argp;
	register int i;
	int nf, k;			/* tmp ints */
	FILE *fp = NIL;

	Prompt = fopen("/dev/tty", "w");

	if (signal(SIGINT,1) != SIG_IGN)	/* signal processing */
		signal(SIGINT, rm_tmp); 	/* catch attn intrps */

	if(Prompt == NIL || Reply == NIL)
		err("%s:Can't open tty for r/w", argv[0]);

	for(i=1; i < argc; i++) {
		argp = argv[i];
		if (*argp == '-') {
			switch(*++argp) {
			case 'd':
				++debug; break;

			case 'F':
				Fldsep = *++argp; break;

			case 'p':
				strcpy(Buf, ++argp);
				nf = gparse(Buf, Fld, NFLDS, ',');
				for(Nprompt=0; Nprompt < nf; Nprompt++) {
					k = atoi(Fld[Nprompt]);
					if(k <= 0)
						err("%s:bad field no.:'%s'",
							argv[0], Fld[Nprompt]);
					if(k >= MAXPROMPT)
						err("%s:too many prompts",
								argv[0]);
					F[Nprompt] = k - 1;
				}
				break;

			case 'o':
				Datafname = argv[++i];
				if(access(Datafname,0) == 0) { /* file exist? */
					++writeback;
					Output = fopen(mktemp(Tmpname), "w");
					if(Output == NIL)
						err("%s:Can't open tmpfile",
							argv[0]);
				}
				else {			/* file ! exists */
					Output = fopen(Datafname, "w");
					if(Output == NIL)
						err("%s:Can't open %s",
							argv[0], Datafname);
				}
				break;
			default:
				err(usage, argv[0]);
				break;
			}
		}
		else {				/* processing file name */
			fp = myopen(fp, argp, "r");
			append(fp);
		}
	}

	if (fp == NIL)
		err(usage,argv[0]);

	cleanup(fp);
}

void
append(fp)
FILE *fp;
{
	register int nf, i;
	int k;

	while(getln(Buf, BSIZ, fp) != EOF) {
		fputs(Buf, Output);		/* write untouched data */

						/* parse data for prompt flds */
		nf = gparse(Buf, Fld, NFLDS, Fldsep);
		for(i=0; i < Nprompt; i++) {		/* write prompt */
			if((k = F[i]) < nf)	/* valid field? */
				fprintf(Prompt, "%s%s",
							(i)?(", "):(""),Fld[k]);
		}
		fputs(": ", Prompt);		/* ascetics */
		fflush(Prompt);			/* flush prompt onto tty */

		if(getln(Buf, BSIZ, Reply) == EOF) {  /* get append stuff */
			exitno = 1;
			rm_tmp(fp);
		}

		if(Buf[0] != '\0')	/* if !null, irite sep and append */
			fprintf(Output, "%c%s", Fldsep, Buf);
		else if(Fldsep != ' ')		/* always write nonblank sep */
			putc(Fldsep, Output);

		putc('\n', Output);		/* finish line */
	}
}

void
cleanup(parent)
FILE *parent;
{
	char *writemsg = "Can't write to file '%s' - try again:\n";

	if (writeback) {
		fclose(parent);		/* flush and close */
		fclose(Output);

tryagain:
		fprintf(Prompt,"Write '%s' [wq][q!][w filename]? ",Datafname);
		fflush(Prompt);
		Buf[0] = '\0';		/* be safe and null string */
		getln(Buf, BSIZ, Reply);

		if(Buf[0] == 'w' && Buf[1] == 'q') {
			if(filecopy(Tmpname, Datafname) == FAILED) {
				fprintf(Prompt, writemsg, Datafname);
				goto tryagain;
			}
		}

		else if(Buf[0] == 'q' && Buf[1] == '!')
			/* just checking command: unlink tmpfile and exit */
			;

		else if(Buf[0] == 'w' && isspace(Buf[1]) ) {
			register char *name;
			for(name = &Buf[2]; isspace(*name);)
				++name;		/* eatup white space */
			
			if(access(name,2) == 0) {
				fprintf(Prompt,"'%s' exists - ok to overwrite [y/n]? ", name);
				fflush(Prompt);
				getln(Buf, BSIZ, Reply);
				if (Buf[0] != 'y')
					goto tryagain;
			}
						/* assume valid file name */
			if (filecopy(Tmpname, name) == FAILED) {
				fprintf(Prompt, writemsg, name);
				goto tryagain;
			}
		}

		else {		/* illegal user response */
			fprintf(Prompt,"\nExpecting 'wq', 'q!' or 'w filename':\n");
			goto tryagain;
		}
				
	}
	exitno = 0; 	/* successful exit status */
	rm_tmp();	/* rm temp if present and exit */
}

int
filecopy(fromfile, tofile)
char *fromfile, *tofile;
{
	register int fdfrom, fdto, n;

	fdto = creat(tofile, 0644);
	if (fdto < 0)
		return(FAILED);

	fdfrom = open(fromfile, 0);
	if(fdfrom < 0 )
		err("Write back failed");

		/* usr interupts not allowed during copy back */
	if (signal(SIGINT,1) != SIG_IGN)
		signal(SIGINT, atten);

		/* do a fast copy */	
	while((n = read(fdfrom, Buf, BSIZ)) > 0) 
		if(write(fdto, Buf, n) != n)
			err("file '%s':Serious write error",
					tofile);
	return(SUCCEEDED);
}

void
rm_tmp() {		/* rm temp file and exit */

	if(debug == 0)
		if(access(Tmpname,0) == 0 && unlink(Tmpname) < 0)
			err("Can't unlink %s", Tmpname);
	exit(exitno);
}

void
atten(){
	if(attenflg++ == 0)
		fputs("File write back:interrupt ignored\n", stderr);

	if (signal(SIGINT,1) != SIG_IGN)
		signal(SIGINT, atten);
}
