/* macro to get space for nodes usage GSPACE(ptr, cast, nunits) */
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#define GSPACE(p,t,n) if((p=(t *)(calloc(n,sizeof(*p))))==NULL){fprintf(stderr,"nospace\n",line);exit(1);}


/* the binary tree used for ranking the data */
typedef struct treenode {
	float key;
	float ties;
	struct treenode *lt;
	struct treenode *rt;
} RTNODE;


/* struct of linked list off each data tree node */
typedef struct datalist{
	float data;
	struct datalist *next;
} DNODE;


/* ordered binary tree which stores keys to linked data */
typedef struct datanode {
	char *dkey;			/* key of data node */
	int na;
	float max, min;			/* minmax datum */
	float sum, sumsq;		/* sum & sumsq of data */
	float ranksum;			/* sum of ranks for a_th grp */
	struct datalist *start, *end;	/* ptr to start and end of data */
	struct datanode *ltd, *rtd;	/* next */
} DTNODE;
