#include <stdio.h>
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include "treedef.h"

/* given n, sum and sumsq stored in the data node, calc mean, var, se etc */
statcalc (root, mean, var, sd, se, low, high)
DTNODE *root;
float *mean, *var, *sd, *se, *low, *high;
{
	float t_table;
	double sqrt();
	double tprob();

	*mean = root->sum / root->na;
	*var = (root->sum * root->sum) / root->na;	/* div obs sq by n */
	*var = (root->sumsq-(*var)) / (root->na - 1);
	*sd = sqrt ( (double) *var);
	*se = *sd / sqrt ( (double) root->na);

	t_table = tprob(0.05, root->na);	/* t-table for 96% ci */
	*low = *mean - t_table * (*se);
	*high = *mean + t_table * (*se);
}
