#include <stdio.h>
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */
#include "treedef.h"

mkdata(root, xcase, x)
DTNODE **root;
char *xcase;
float x;
{
	char *calloc(), *strsave();
	register DNODE *dnode;
	extern int line;
	
	if (*root == NULL){			/* notfound */
		GSPACE (*root,DTNODE,1);
		(*root)->dkey = strsave(xcase);

		GSPACE (dnode,DNODE,1);	/* mk linked data list */
		(*root)->start = dnode;
		(*root)->na = 1;		/* n in a_th grp */
		(*root)->start->data = x;	/* sto data at head lnk list */
		(*root)->start->next = NULL;
		(*root)->min = x;		/* min val */
		(*root)->max = x;		/* max val */
		(*root)->sum = x;		/* sum of data */
		(*root)->sumsq = x * x;		/* sum sq data */
		(*root)->ranksum = 0.0;		/* sum of ranks for a_th grp */
		(*root)->end = (*root)->start;	/* end of lnk list ptr */
		(*root)->rtd = (*root)->ltd = NULL;	/* left & rigth ptrs */
	} /* if */
		
	else if ( strcmp ( (*root)->dkey, xcase) > 0)
		mkdata ( &((*root)->ltd), xcase, x);
	else if ( strcmp ( (*root)->dkey, xcase) < 0)
		mkdata ( &((*root)->rtd), xcase, x);

	else{				/* found */
		GSPACE (dnode,DNODE,1);		/* mk new data node */
		dnode->data = x;		/* sto data */		
		dnode->next = NULL;
		(*root)->na++;			/* inr grp count */
		if ( x > (*root)->max )		/* set max */
			 (*root)->max = x;	
		if ( x < (*root)->min )		/* set min */
			 (*root)->min = x;	
		(*root)->sum += x;		/* accum sum */
		(*root)->sumsq += (x * x);	/* accum sumsq */
		(*root)->end->next = dnode;	/* link */
		(*root)->end = dnode;		/* set end to new dnode */
	}
}
