#include <stdio.h>
/*	Copyright 1981 by David Zittin, Biosciences Data Centre.	 */

/* input buffer len & the number of fields per line */
#define BUFSIZ 256
#define NF 32

#define ON 1
#define OFF 0
#define SAME 0
#define ESCAPECHAR ('@')

/* user split char */
#define EQUAL ('=')

char *nospace = "getdata:nospace";

/* test
main(){
	char *str;
	while(getdata (&str) != EOF)
		printf("main:str=%s\n", str);
}
*/

int getdata(str)
char **str;
{
	extern int line;
	static char buf[BUFSIZ], *bp[NF];
	static int nf=0, i=0;
	int glnstr();
	char *fgets();

getanother:
	if (i == nf){
		nf = 0;
		while (nf == 0){	/* read til > 0 fields in buf */
			if (fgets(buf, BUFSIZ, stdin) == NULL)
				return(EOF);
			line++;
			nf = glnstr (buf, BUFSIZ, bp, NF);
			if (nf < 0){
				nf *= -1;	/* make pos */
				fprintf(stderr,"%d:missing quote==>",line);
				for (i=0; i<=nf; i++)
					fprintf(stderr,"%s ", bp[i]);	
				fprintf(stderr,"<==\n");
				exit(1);
			}
			i = 0;
		}
	}
	*str = bp[i];
	i++;

	if (**str != ESCAPECHAR)		/* then data read */
		return ( -(EOF) );
	else{
		usrcmd(*str);		/* process user cmd */
		goto getanother;	/* get next field */	
	}
}
	
usrcmd(str)
char *str;
{
	char *fld[4], *strsave();
	int parse(), strcmp();
	register int nf, i;
	register char *leftstr;

/* eternal flags & line */
	extern int line;		/* data line */
	extern char *casestr;		/* usr provided esp for keypunching */
	extern int echo;		/* data echo on/off */
	extern char *title;
/*****************/


/* parse usr cmd */
	if ((nf = parse(str, fld, EQUAL)) > 2) 
		goto badoption;

	leftstr = fld[0];	
	leftstr++;
/* usr opt to echo data */
	if (strcmp(leftstr, "echo") == SAME) { 	/* turn echo flag off-on */
		switch (strcmp(fld[1],"off")){
			case SAME : echo = OFF;	/* recognize "off" only, all */
					break;	/* others="on" */
			default   : echo = ON;
					break;
		} /* swt */
		return;
	}

	else if (strcmp(leftstr, "title") == SAME){ 	/* save title str */
		if(( title = strsave ( fld[1] )) == NULL){
			fprintf(stderr,"%s\n",nospace);	
			exit(1);
		}
		return;
	}
	
/* usr opt to auto repeat case */
	else if(strcmp(leftstr,"group")==SAME || strcmp(leftstr,"case")==SAME){
		switch (nf) {
			case 1 : casestr = NULL;	/* erase case */
					break;
			case 2 : if (( casestr = strsave(fld[1])) == NULL){
					fprintf(stderr,"%s\n",nospace);
					exit(1);
				}
					break;
		} /* swt */
		return;
	}

badoption:
	fprintf(stderr,"%d:WARNING:inapplicable option=> \"",line);
	for(i=0; i<nf; i++)
		fprintf(stderr,"%s ", fld[i]);
	fprintf(stderr,"\"\n");
}
