#include "/usr/include/stdio.h"

#define	MAXLINES	60	/* number of lines/page */
#define	MAXBUFF	512
#define	NL '\n'
char line[MAXBUFF];
char cc '1';
int nextline 1;		/* next line to print */
int maxline;		/* maximum number of lines/page */
char outline[MAXBUFF];
char undline[MAXBUFF];
int maxcol, col, maxucol;
int sflg;
int nflg;		/* NROFF generated the input */
int tflg;		/* two sided mode */
#define	MAXTITLE	128
char title[MAXTITLE];
int fflg;		/* on first page of document; don't suppress nl's */
int page;		/* number of output pages */
int half = 0;

main(argc,argv) char **argv;
{
/*
 * program to take the output from NROFF and convert to ASA carriage
 * control.
 */
char *argp;
register FILE *file;

file = NULL;
--argc;
++argv;
while (argc > 0)
	{
	--argc;
	argp = *argv++;
	if (*argp == '-')
		{
		++argp;
		while (*argp)
			switch(*argp++)
				{
			case 'f':
				++fflg;
				break;
			case 't':
				++tflg;		/* two sided */
				break;
			case 'l':
				maxline = cvtint(&argp);
				break;
			case 'n':		/* NROFF input */
				++nflg;
				if (maxline == 0)
					maxline = MAXLINES;
				break;
			case 's':		/* simple cc only */
				++sflg;
				break;
				}
		}
	else
		{
		file = fopen(argp,"r");
		if (file == NULL)
			err("can't open %s",argp);
		toasa(file);
		fclose(file);
		}
	}
if (file == NULL)
	toasa(stdin);
exit(0);
}

toasa(file) FILE *file;
{
register char *inp;
register int i;

page = 0;		/* reset relative page number */
while (fgets(line,sizeof line,file))
	{
	inp = line;
	col = 0;
	maxcol = 0;
	maxucol = 0;
	for (; *inp; ++inp)
		{
		switch(*inp)
			{
		case '\033':
			++inp;
			if (*inp == '9')
				if ((half = !half) == 0)
					outcc(outline,maxcol);
			break;
		case '\t':
			i = ((col+8) & ~07);
			if (col >= maxcol)
				{	/* not backspaced */
				while (col < i)
					outline[col++] = ' ';
				maxcol = col;
				}
			col = i;
			break;
		case '\b':
			if (col > 0)
				--col;
			break;
		case 014:		/* form feed */
			cc = '1';
			nextline = 1;
			break;
		case '\r':
			outcc(outline,maxcol);
			if (maxucol)
				output('+',undline,maxucol);
			cc = '+';
			col = 0;
			maxcol = 0;
			maxucol = 0;
			break;
		case '\n':
			break;
		default:	/* output normal character */
			if (col >= maxcol)
				{		/* not backspaced */
				outline[col] = *inp;
				col++;
				maxcol = col;
				}
			else
				{
				while (maxucol < col)
					undline[maxucol++] = ' '; /* fill line */
				if (outline[col] == '_') /* if backwards */
					{
					undline[col] = outline[col];
					outline[col++] = *inp;
					}
				else
					undline[col++] = *inp;
				maxucol = col;
				}
			}
		}
	outcc(outline,maxcol);
	if (maxucol)
		output('+',undline,maxucol);
	}
flush();
}

outcc(buff,length) char *buff;
{
/*
 * called to output the given line with the preset carriage control.
 */

if (length == 0 && (nextline < maxline || !maxline))		/* null line */
	{
	switch(cc)
		{
	case '1':
		if (nflg)
			{
			if (!(fflg && page == 0))
				return;	/* nroff mode - ignore null lines */
			}
		break;
	case ' ':
		if (!sflg)
			{
			cc = '0';
			++nextline;
			return;
			}
		break;
	case '0':
		cc = '-';
		++nextline;
		return;
		}
	}

if (cc == '1')
	{
	nextline = 2;	/* now on line 2 */
	half = 0;
	}
else
	++nextline;
output(cc,buff,length);
if (nextline > maxline && maxline)
	{
	nextline = 1;
	cc = '1';
	}
else
	cc = ' ';
}

output(c,buff,length) char c; char *buff;
{
register int l;
register char *b;

if (tflg && c == '1')
	{
	if (strncmp(title,buff,length))
		{	/* title is different, so go to even page */
		putchar(':');
		putchar(NL);
		if ((l = length) >= sizeof title)
			l = sizeof title - 1;
		strncpy(title,buff,l);
		}
	}
putchar(c);
for (b = buff, l = length; --l >= 0; )
	putchar(*b++);
putchar(NL);
if (c == '1')
	++page;
}
