#include <stdio.h>
#include <signal.h>
#include <sys/types.h>

/*
 * Structure returned by ftime system call
 */
struct timeb {
	time_t	time;
	unsigned short millitm;
	short	timezone;
	short	dstflag;
};
#define	HZ	60.0
#define	MINUTE	60.0
#define	HOUR	3600.0

struct { char lo, hi; };

struct tbuffer
{
int proc_user;
int proc_system;
long child_user;
long child_system;
} tbuff;
double start, now;

int status, pid;

char    *mesg[] {
	0,
	"Hangup",
	"interrupt",
	"Quit",
	"Illegal instruction",
	"Trace/BPT trap",
	"IOT trap",
	"EMT trap",
	"Floating exception",
	"Killed",
	"Bus error",
	"Memory fault",
	"Bad system call",
	"broken pipe",
	"Alarm Clock",
	"terminated",
	"Sig 16",
	"Sig 17",
	"Sig 18",
	"Sig 19",
};

double curtime()
{
double f;
struct timeb timeb;

ftime(&timeb);
f = timeb.time + timeb.millitm/1000.0;
return(f);
}

main(argc,argv) char **argv;
{
register int i;

if (argc < 2)
	err("usage: %s command",argv[0]);
start = curtime();
if ((pid = fork()) == 0)
	{
	argv[argc] = 0;
	pexec(argv[1],argv+1);
	exit(0177);
	}

if (pid == -1)
	err("couldn't fork");
signal(SIGINT,SIG_IGN);
signal(SIGQIT,SIG_IGN);
signal(SIGPIPE,SIG_IGN);
while ((i = wait(&status)) != pid && i != -1)
	;
if (status == (0177 << 8))
	{
	fprintf(stderr,"%s not found\n",argv[1]);
	exit(1);		/* could not execute program */
	}
if (status.lo)
	{
	fprintf(stderr,"\n%s: ",argv[1]);
	if (status.lo == 0)
		fprintf(stderr,"status %d",status.hi);
	else
		{
		fprintf(stderr,"%s",mesg[status.lo&017]);
		if (status.lo&0200)
			fprintf(stderr," -- Core Dumped");
		}
	fprintf(stderr,"\n");
	}
now = curtime();
times(&tbuff);
fprintf(stderr,"\nReal	");
prtime((double) (now-start));
fprintf(stderr,"User	");
prtime(tbuff.child_user/HZ);
fprintf(stderr,"System	");
prtime(tbuff.child_system/HZ);
exit(status != 0);
}

prtime(f) double f;
{
register int i;
register int flag;
	
i = f / HOUR;
if (flag = i)
	fprintf(stderr,"%2d:",i);
else
	fprintf(stderr,"   ");
f -= i * HOUR;

i = f / MINUTE;
if (flag || i)
	fprintf(stderr,flag ? "%02d:" : "%2d:",i);
else
	fprintf(stderr,"   ");
f -= i * MINUTE;
fprintf(stderr,flag || i ? "%04.1f\n" : "%4.1f\n",f);
}
