#include "/usr/include/stdio.h"

#include "/usr/sys/param.h"
#include "/usr/sys/user.h"

extern errno;
int trace 0;
char *lastaddr;
char program[64];
int sig1,sig2,sig3;
int fflg;
int sflg;
int tflg;
int xflg;
int ctrace;		/* call tracing */
#define	IOCTL	54	/* call number of ioctl */
#define	EXEC	11	/* call number of exec */
#define	EXECE	59	/* call number of exece */
#define	nop	0240	/* no operation */
#define TRAPSYS	4	/* trap system calls */
#define	NOTRAP	0	/* don't trap them */
int oldps, oldpc, old2, old4;
int *cptr;
int before;
int pid;
int status;
int signo;
int results;
struct { char lo, hi;};
#define	ISPRINT(x) ((x) >= ' ' && (x) < 0177)
#define	C_BIT	01

#define	R_bit	0200
#define	r	0100001 +		/* # of register parameters */
#define	s1	(1<<14)+	/* arg 1 is string */
#define	s2	(1<<13)+	/* arg 2 is string */
#define	s3	(1<<12)+	/* arg 3 is string */

#define	R0	1
#define	R1	2

char v7map[64]
{
 0, /*  0 = indir */
 1, /*  1 = exit */
 2, /*  2 = fork */
 3, /*  3 = read */
 4, /*  4 = write */
 5, /*  5 = open */
 6, /*  6 = close */
 7, /*  7 = wait */
 8, /*  8 = creat */
 9, /*  9 = link */
10, /* 10 = unlink */
11, /* 11 = exec */
12, /* 12 = chdir */
13, /* 13 = time */
14, /* 14 = mknod */
15, /* 15 = chmod */
16, /* 16 = chown */
17, /* 17 = break */
18, /* 18 = stat */
62, /* 19 = seek ==> lseek */
20, /* 20 = getpid */
21, /* 21 = mount */
22, /* 22 = umount */
23, /* 23 = setuid */
24, /* 24 = getuid */
25, /* 25 = stime */
26, /* 26 = ptrace */
27, /* 27 = alarm */
28, /* 28 = fstat */
29, /* 29 = pause */
61, /* 30 = utime */
31, /* 31 = stty */
32, /* 32 = gtty */
33, /* 33 = access */
34, /* 34 = nice */
45, /* 35 = ftime */
36, /* 36 = sync */
37, /* 37 = kill */
38, /* 38 = switch */
39, /* 39 = x */
40, /* 40 = x */
41, /* 41 = dup */
42, /* 42 = pipe */
43, /* 43 = times */
44, /* 44 = prof */
45, /* 45 = tiu */
46, /* 46 = setgid */
47, /* 47 = getgid */
48, /* 48 = sig */
49, /* 49 = x */
50, /* 50 = x */
64, /* 51 = acct */
64, /* 52 = phys */
53, /* 53 = lock */
54, /* 54 = ioctl */
55, /* 55 = x */
56, /* 56 = x */
57, /* 57 = x */
58, /* 58 = x */
59, /* 59 = exece */
60, /* 60 = umask */
64, /* 61 = chroot */
62, /* 62 = lseek */
63, /* 63 = systrap */
};
struct systab {
	char	s_args,s_regs;	/* # of args, # of reg args */
	char	*s_name;
	int	s_results;
	int	s_cnt;
	int	s_tics;
};

struct {
	int	s_arg;
	char	*s_name;
	int	s_results;
	int	s_cnt;
	int	s_tics;
} systab[] {
/*
 * reg other  name	result	cnt	tics
 */
{ 	1, "indir",	0,	0,	0},
{ r	0, "exit",	0,	0,	0},
{ 	0, "fork",	R0,	0,	0},
{ r	2, "read",	R0,	0,	0},
{ r	2, "write",	0,	0,	0},
{ s1	2, "open",	R0,	0,	0},
{ r	0, "close",	0,	0,	0},
{ 	0, "wait",	R0,	0,	0},
{ s1	2, "creat",	R0,	0,	0},
{ s1 s2	2, "link",	0,	0,	0},
{ s1	1, "unlink",	0,	0,	0},
{ s1 s2	2, "exec",	0,	0,	0},
{ s1	1, "chdir",	0,	0,	0},
{ 	0, "time",	R0+R1,	0,	0},
{ s1	3, "mknod",	0,	0,	0},
{ s1	2, "chmod",	0,	0,	0},
{ s1	2, "chown",	0,	0,	0},
{ 	1, "break",	0,	0,	0},
{ s1	2, "stat",	0,	0,	0},
{ r	2, "seek",	0,	0,	0},
{ 	0, "getpid",	R0,	0,	0},
{ s1	3, "mount",	0,	0,	0},
{ s1	1, "umount",	0,	0,	0},
{ r	0, "setuid",	0,	0,	0},
{ 	0, "getuid",	R0,	0,	0},
{ 	0, "stime",	0,	0,	0},
{ 	3, "ptrace",	0,	0,	0},
{ r	0, "alarm",	R0,	0,	0},
{ r	1, "fstat",	0,	0,	0},
{ 	0, "pause",	0,	0,	0},
{ s1	3, "smdate",	0,	0,	0},
{ r	1, "stty",	0,	0,	0},
{ r	1, "gtty",	0,	0,	0},
{ s1	1, "access",	0,	0,	0},
{ r	0, "nice",	0,	0,	0},
{ r	0, "sleep",	0,	0,	0},
{ 	0, "sync",	0,	0,	0},
{ r	1, "kill",	0,	0,	0},
{ 	0, "switch",	R0,	0,	0},
{ 	0, "39",	0,	0,	0},
{ 	0, "40",	0,	0,	0},
{ r	0, "dup",	R0,	0,	0},
{ 	0, "pipe",	R0+R1,	0,	0},
{ 	1, "times",	0,	0,	0},
{ 	4, "profil",	0,	0,	0},
{ 	0, "45",	0,	0,	0},
{ r	0, "setgid",	0,	0,	0},
{ 	0, "getgid",	R0,	0,	0},
{ 	2, "signal",	0,	0,	0},
{ 	0, "49",	0,	0,	0},
{ 	0, "50",	0,	0,	0},
{ 	0, "51",	0,	0,	0},
{ 	0, "52",	0,	0,	0},
{ 	0, "53",	0,	0,	0},
{ s2 s3	3, "ioctl",	0,	0,	0},
{ 	0, "55",	0,	0,	0},
{ 	0, "56",	0,	0,	0},
{ 	0, "57",	0,	0,	0},
{ 	0, "58",	0,	0,	0},
{ s1 s2 s3 3, "exece",	0,	0,	0},
{ 	1, "umask",	0,	0,	0},
{ 	0, "61",	0,	0,	0},
{ r	3, "lseek",	0,	0,	0},
{ 	1, "systrap",	0,	0,	0}
};
int flagaddr	2;		/* starting value for TRAP scan */
#define	TRAP	0104400		/* a trap instruction */
#define	TRAPMASK	~0377	/* what to mask off to get TRAP */
#define	sigbpt	5
#define	sigsys	12

#define	RUSER	2
#define	RIUSER	1
#define	RUREGS	3
#define	WUSER	4
#define	WUREGS	6
#define	SETTRC	0
#define	CONTIN	7
#define	PEXIT	8

char *pgm;
int statb[16];
struct reg
{
char *r_name;
char *r_off;
char *r_value;
};

struct reg pc
{ "pc", -2, 0 };

struct reg r0
{ "r0", -3, 0 };

struct reg r1
{ "r1", -4, 0 };

struct reg ps
{ "ps", -1, 0 };

struct reg sp
{ "sp", -6, 0 };

char *signals[]
{
"",
"hangup",
"interrupt",
"quit",
"illegal instruction",
"trace/bpt",
"iot",
"emt",
"floating exception",
"killed",
"bus error",
"memory fault",
"bad system call",
"pipe broken",
"alarm clock",
"terminate"
};
#define	TRAPON() uput(flagaddr,&u.u_trap)	/* simulate systrap(flagaddr) */
#define	TRAPOFF() uput(0,&u.u_trap)	/* simulate systrap(0) */

int done();
int header[8];
int v7;
main(argc,argv)
char **argv;
{
extern int sys_nerr;
extern char *sys_errlist[];
extern _exectrap;
register char *argp;
register int i;

/*
 * routine to monitor another program's system calls. 
 *
 * this is done by running the program under ptrace and insuring
 * that a trap occurs for all system calls. 
 */

pgm = *argv++;
--argc;

while(argc > 0 && **argv=='-')
	{
	argp = *argv++;
	--argc;
	switch(*++argp)
		{
	case 'f':		/* full trace */
		++fflg;

	case 't':		/* trace calls */
		++ctrace;
		++tflg;
		++sflg;
		break;

	case 'd':
		++trace;
		break;

	case 's':	/* summary of system calls */
		++sflg;
		++ctrace;
		break;
	case 'x':
		++xflg;
		break;

	default:
		err("bad switch");
		}
	}
if(argc < 1)
	err("arg cnt");
copy(program,argv[0]);
if((i=open(program,0)) < 0)
	{
	copy(program,"/bin/");
	append(program,argv[0]);
	if((i=open(program,0)) < 0)
		{
		copy(program,"/usr/bin/");
		append(program,argv[0]);
		if((i=open(program,0)) < 0)
			err("%s: %s not found",pgm,argv[0]);
		}
	}
if (read(i,header,16) != 16)
	err("%s: no header",program);
if (header[0] != 0407 && header[0] != 0410 && header[0] != 0411)
	err("%s: bad header",program);
close(i);
v7 = (header[7] >> 8) == 7;
if( (pid=fork()) == 0)
	{
	_exectrap++;
	ptrace(SETTRC, 0, 0, 0);
	argv[argc] = 0;
	execv(program,argv);
	err("no %s",argv[0]);
	}

fileno(stdout) = 2;
if (!xflg)
	setout();
setup();
for (;;)
	{
	TRAPON();
	ps.r_value =& ~ 020;
	go();
	if(signo != sigsys)
		badret();
	TRAPOFF();
	pc.r_value =- 2;	/* back up pc to point to trap */
	if(ctrace)
		trc();
	ps.r_value =| 020;
	go();
	if (fflg)
		{
		if (ps.r_value&C_BIT)
			{
			printf("C bit set error ");
			pregs(R0);
			i = r0.r_value;
			if (i > 0 && i < sys_nerr)
				printf(" %s",sys_errlist[i]);
			printf("\n");
			}
		else
			{
			if (results)
				{
				pregs(results);
				printf("\n");
				}
			}
		}
	if(signo != sigbpt)
		badret();
	if(cptr)
		*cptr =+ uget(&u.u_stime) - before;
	}
}

uput(value,addr) char *addr;
{
addr = addr - &u;
if (ptrace(WUREGS, pid, addr, value) == -1)
	err("can't uput %o %o",value,addr);
}

uget(addr) char *addr;
{
addr = addr - &u;
return(ptrace(RUREGS, pid, addr, 0));
}


bpwait()
{
register int w;
if(pid == -1)
	err("try again");

while ((w = wait(&status)) != pid && w != -1)
	;

if(w == -1)
	err("wait error");

if( (status & 0377) != 0177)
	{
	if(signo = status & 0177)
		printf("%s\n",signals[signo]);
	done();
	}
signo = status >> 8;
getreg(&pc);
getreg(&ps);
if(trace)
	printf("%s at %o (%o)\n",signals[signo],
		pc.r_value,ps.r_value);
return(signo);
}

getreg(rp)
struct reg *rp;
{
register struct reg *p;

p = rp;
p->r_value = ptrace(RUREGS, pid, 2 * (512+p->r_off), 0);
}

putreg(rp)
struct reg *rp;
{
register struct reg *p;

p = rp;
ptrace(WUREGS, pid, 2 * (512+p->r_off), p->r_value);
}


get(addr)
{
register int i;
i=ptrace(RUSER, pid, addr, 0);
if(trace>1)
	printf("get(%o)=>%o\n",addr,i);
return(i);
}

iget(addr)
{
/*
 * fetch word from I space 
 */
register int i;
i=ptrace(RIUSER, pid, addr, 0);
if(trace>1)
	printf("iget(%o)=>%o\n",addr,i);
return(i);
}

put(addr,info)
{
if(trace)
	printf("put(%o,%o)\n",addr,info);
if(ptrace(WUSER, pid, addr, info) == -1 && errno )
	err("can't put(%o,%o)",addr,info);
}


go()
{
if(trace)
	printf("go to %o (%o)\n",pc.r_value,ps.r_value);
putreg(&ps);
putreg(&pc);
flush();
ptrace(CONTIN, pid, 0, 0);
bpwait();
if(signo != sigbpt && signo != sigsys)
	badret();
}

setup()
{
register int i;
int j;

/*
 * routine to set up the traced program so that it executes a
 * systrap(1) call. 
 */

sig2 = signal(2,1);
sig3 = signal(3,1);
if ((sig2&1) == 0)
	signal(2,&done);
if(bpwait()!=sigbpt)
	err("%s\n",signals[signo]);
getreg(&sp);
/*
 * scan for a TRAP instruction.
 * if we don't find one in the first 256 non-zero words then
 * take anything.
 */
for (i=256; i; flagaddr =+ 2)
	{
	j = get(flagaddr);
	if ((j & TRAPMASK) == TRAP || (ISPRINT(j.lo) && ISPRINT(j.hi)))
		break;
	if (j)
		--i;
	}
if (i == 0)
	printf("Warning: using location %o as flagaddr\n",flagaddr);
TRAPON();
}

badret()
{
	err("%s at %o\n",signals[signo], pc.r_value);
}

trc()
{
/*
 * print out a call trace. 
 */

register int *j;
register int i;
register int k;
int mask;
int n;

j = pc.r_value;
i = iget(j);
if ((i&TRAPMASK) != TRAP)
	err("Help: TRAP instruction not found at %o",j);
n = i =& 077;
if(i == 0)
	{
	if(tflg)
		putchar('*');
	j = iget(j+1);		/* get .indir addr */
	i = get(j);		/* get indirect trap */
	if ((i&TRAPMASK) != TRAP)
		err("Help: no TRAP instruction at %o",j);
	n = i =& 077;
	}
if (v7)
	i = v7map[i];
i = &systab[i];
i->s_cnt++;
cptr = &i->s_tics;
results = i->s_results;		/* result codes */
before = uget(&u.u_stime);
if(!tflg)
	return;
printf("%s(",i->s_name);
k = 0;
if(i->s_regs&R_bit)
	{
	getreg(&r0);
	printf("%o",r0.r_value);
	++k;
	}
mask = 0200;
for (; k<i->s_args; ++k)
	{
	if(k)
		putchar(',');
	if(fflg && (i->s_regs & (mask =>> 1)))
		{
		switch(n)
			{
		case IOCTL:
			if (k == 1)
				putioctl(get(++j));
			else
				putoct(get(++j),3);
			break;
		case EXEC:
		case EXECE:
			if (k == 1 || k == 2)
				{
				putvec(get(++j));
				break;
				}
		default:
			putstr(get(++j));
			break;
			}
	
		}
	else
		printf("%o",get(++j));
	}
printf(")");
if (!results)
	printf("\n");
}

done()
{
register struct systab *s;

signal(2,sig2);
signal(3,sig3);
if(!sflg)
	return;
printf("\nCall	count	 tics	   time	  time/call\n");
for (s=systab; s<systab+63; ++s)
	{
	if(s->s_cnt)
		{
		if(s->s_tics)
			printf("%s	%5d	%5l %10.3f %8.3f\n",
				s->s_name,s->s_cnt,s->s_tics,
				s->s_tics/60.0,s->s_tics/60.0/s->s_cnt);
		else
			printf("%s	%5d\n",s->s_name,s->s_cnt);
		}
	}
flush();
exit(0);
}

err(s,d1,d2,d3,d4)
char *s;
{
if(pid)
	ptrace(PEXIT,pid,0,0);
printf(s,d1,d2,d3,d4);
putchar('\n');
flush();
exit(1);
}

putoct(addr,cnt) int *addr;
{
register int i;
printf("%o==>",addr);
while (cnt-- > 0)
	{
	i = get(addr++);
	printf("%o",i);
	if (cnt)
		printf(",");
	}
}

putvec(addr) int *addr;
{
register int i;
while (i = get(addr++))
	{
	putstr(i);
	printf(",");
	}
printf("0");
}

putstr(addr)
{
/*
 * output the string at address "addr". 
 */
register int c;
lastaddr = 0;
putchar('"');
while (c = getch(addr++))
	putchar(c);
putchar('"');
}

getch(addr)
{
static w;
struct {char lo, hi;};
if(lastaddr != (addr& ~1))
	w = get(lastaddr = (addr & ~1));
return(addr & 1 ? w.hi : w.lo);
}

pregs(n)
{
if (n&R0)
	{
	getreg(&r0);
	printf(" R0=%d (0%o)",r0.r_value,r0.r_value);
	}
if (n&R1)
	{
	getreg(&r1);
	printf(" R1=%d (0%o)",r1.r_value,r1.r_value);
	}
}

putioctl(n)
{
printf("%c %d",n.hi,n.lo);
}
