#include <stdio.h>

#define	MAXLINE	256
char line1[MAXLINE];
char line2[MAXLINE];
char *file1, *file2;
int skip;
int line;
int wflg;		/* warn if overlay line is longer */

main(argc,argv) char **argv;
{
FILE *f1, *f2;
register char *s1, *s2;
char *argp;
register int i;


for (i=1; i<argc; ++i)
	{
	if (*(argp = argv[i]) != '-')
		break;
	++argp;
	switch(*argp++)
		{
	case 'w':
		++wflg;
		break;
	case 's':
		skip = cvtint(&argp);
		break;
	default:
		err("invalid switch %s",argp-1);
		}
	}
if (argc-i != 2)
	err("usage: %s [-s#] file1 file2",argv[0]);
file1 = argv[i];
file2 = argv[i+1];
if ((f1 = fopen(file1,"r")) == NULL)
	err("can't open %s",file1);
if ((f2 = fopen(file2,"r")) == NULL)
	err("can't open %s",file2);
for (; skip > 0; --skip)
	{
	if (mygets(line1,MAXLINE,f1) == NULL)
		err("%s: empty",file1);
	myputs(line1);
	}
for (line=1; mygets(line1,MAXLINE,f1) != NULL; ++line)
	{
	if (mygets(line2,MAXLINE,f2) == NULL)
		{
		do
			myputs(line1);
		while (mygets(line1,MAXLINE,f1));
		err("%s: file %s longer than %s",argv[0],file1,file2);
		}
	for (s1=line1, s2=line2; *s1 && *s2; ++s1, ++s2)
		if (isspace(*s1) && !isspace(*s2))
			*s1 = *s2;
	if (*s2 != 0)
		{
		while (*s2)
			*s1 ++ = *s2++;
		if (wflg)
			fprintf(stderr,"%s: overlay line %d too long\n",file2,line);
		}
	myputs(line1);
	}
/* copy out the rest of the lines on file2 */
if (mygets(line2,MAXLINE,f2) != NULL)
	{
	do
		myputs(line2);
	while (mygets(line2,MAXLINE,f2));
	err("%s: file %s longer than %s",argv[0],file2,file1);
	}
}

mygets(line,max,file) char *line; FILE *file;
{
register int l;

if (fgets(line,max,file) == NULL)
	return(NULL);
l = strlen(line);
if (l > 0 && line[--l] == '\n')
	line[l] = 0;
return(line);
}

myputs(line) char *line;
{
fputs(line,stdout);
putchar('\n');
}
