#

#define	READ	4
#define	WRITE	2
#define	EXEC	4

struct {
char s_minor;
char s_major;
};

struct stat
{
int s_dev;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} fbuff, tbuff;

#define	MAXNAME	64
char dotdot[MAXNAME];
char targ[MAXNAME];

main(argc,argv) char **argv;
{
register int last, i;

if (argc < 3)
	err("usage: mvdir old-dir ... new-dir");
last = argc-1;
for (i=1; i<last; ++i)
	mvdir(argv[i],argv[last]);
exit(0);
}

mvdir(from,to) char *from, *to;
{
if (equal(from,".") || equal(from,"..") || any(from,"/"))
	err("mvdir: %s not simple directory",from);
if (stat(from,&fbuff) < 0 || (fbuff.s_flags & 060000) != 040000)
	err("mvdir: %s not directory",from);
if (stat(to,&tbuff) < 0 || (tbuff.s_flags & 060000) != 040000)
	err("mvdir: %s not directory",to);
if (access(from,WRITE+EXEC) < 0)
	err("mvdir: %s no access",from);
if (access(to,WRITE+EXEC) < 0)
	err("mvdir: %s no access",to);
if (fbuff.s_dev != tbuff.s_dev)
	err("mvdir: %s not on same device as %s",from,to);
if (inside(to,fbuff.s_inumber,to))
	exit(1);
cat(targ,to,"/",from,0);
clink(from,targ);	/* ln a b/a */
cat(dotdot,from,"/..",0);
cunlink(dotdot);	/* rm a/.. */
cunlink(from);		/* rm a */
cat(dotdot,targ,"/..",0);
clink(to,dotdot);		/* ln b b/a/.. */
}

clink(a,b) char *a, *b;
{
if (link(a,b) < 0)
	err("cannot link: %s %s",a,b);
}

cunlink(a) char *a;
{
if (unlink(a) < 0)
	err("cannot unlink: %s",a);
}

inside(s,inode,file) char *file;
{
/*
 * search "file" up to root to see if we find find inode "inode"
 * if we do then "file" is inside.
 * fork off a subprocess so that we can do the search via a "chdir".
 */
int status;
register int i;

if (fork() == 0)
	{
	if (chdir(file) < 0)
		err("mvdir: cannot search %s",file);
	for (i=0;i < 1000; ++i)		/* in case of directory loop */
		{
		if (stat(".",&tbuff) < 0)
			err("mvdir: no .");
		if (tbuff.s_inumber == 1)
			exit(0);		/* search complete */
		if (inode == tbuff.s_inumber)
			err("mvdir: %s is inside %s",s,file);
		if (chdir("..") < 0)
			err("mvdir: no ..");
		}
	err("Directory loop in %s",file);
	}
wait(&status);
return(status);
}

cat(dest,arg) char *dest, *arg;
{
register char **argp;
register char *s, *p;

argp = &arg;
for (p=dest; s = *argp++; )
	while (*p = *s++)
		++p;
*p = 0;
}
