#include <stdio.h>
#include <time.h>

#define	FSLEN	104
#define	CHKSUM	0xe50efe2a
#define	CHK_HDR	12	/* sizeof chksum block header */


int chkhdr = CHK_HDR;
struct fs
{
long f_header;		/* *FS magic number */
short f_file;		/* file number */
short f_version;		/* verson number */
char f_name[32];	/* file name */
char f_type;		/* file type */
char f_device;		/* file device */
short f_maxlen;		/* maximum length line */
short f_size;		/* size (pages) */
char f_date[14];	/* date mmm. dd, 19xx */
char f_time[8];		/* time hh:mm:ss */
char f_dsn[17];		/* ? */
char f_block[17];	/* ? */
char f_junk;
char f_doc;		/* ? */
} fs;

char buff[4096];
char filename[64];
char outname[64];
char vname[64];		/* name including version information */
int tape, rec, cnt, file, eof;
int maxlen;
double size;
double feet;
double tfeet;
int tflg, vflg, xflg, dflg;
int mflg = 1;		/* change modification date on file */
int chkflg;		/* if this file has checksum information */
int qflg;
int sflg;
int uflg;
int wflg;
int lflg;		/* line number's on output */
int nl;
FILE *out;
char *tapename = "/dev/rmt0";

main(argc,argv) char **argv;
{
register int l;
register char *argp;
register char *buffp;
char *fp;
int flag;
char *f;
int exit();
long fsdate, filedate, modtime(), cvtdate();

#ifdef PROFILE
if ((signal(2,1)&1) == 0)
	signal(2,&exit);
#endif
--argc;
++argv;
if (argc >= 1 && * (argp = *argv) == '-')
	{
	--argc;
	++argv;
	++argp;
	while (*argp)
		{
		switch(*argp++)
			{
		default:
			printf("invalid switch %c\n",argp[-1]);
			break;
		case 'f':
			tapename = *argv++;
			--argc;
			break;
		case 'm':
			mflg = !mflg;	/* change modification date */
			break;
		case 'q':
			++qflg;		/* chksum done */
			break;
		case 'd':
			++dflg;		/* dsaves done */
			break;
		case '0':
			break;
		case 'u':
			++uflg;		/* make unique file name */
			break;
		case 'w':
			++wflg;		/* ask for the new name */
			break;
		case 's':
			++sflg;		/* strip id from file name */
			break;
		case 'n':
			++nl;
			break;
		case 'x':
			++xflg;
			break;
		case 't':
			++tflg;
			break;
		case 'l':
			++lflg;
			break;
		case 'v':
			++vflg;
			break;
			}
		}
	}
else
	++tflg;
tape = open(tapename,0);
if (tape < 0)
	err("can't open %s",tapename);
eof = 0;
if (!nl)
	{
	if (read(tape,buff,sizeof buff) != 80)
		++nl;
	close(tape);
	tape = open("/dev/rmt0",0);
	}
lread("VOL1");
if (tflg && !nl) printf("volume label = %.6s\n",buff+4);
if (tflg) printf(
" file	name				ver  size  date\n\n");
buffp = buff;
for (file=1; eof < 2; ++file)
	{
	rec=0; size = 0;
	maxlen = 0;
	if (!lread("HDR1"))
		break;
	geteof();
	if ((l=read(tape,buff,sizeof buff)) != FSLEN)
		{
		if (file==1 && l==0)
			goto next;
		if (l==0)
			break;
		if (l < FSLEN)
			err("Invalid FS header record found - too short");
		}
	move(sizeof fs,&buff,&fs);
	ebcasc(32,buffp->f_name,buffp->f_name);
	cvtname(32,buffp->f_name,filename);
	if (vflg > 1)
		printf("name=%.32s doc=%o hdr=%X \n",filename,buffp->f_doc,buffp->f_header);
	if (l > FSLEN && fs.f_doc != -1 && !dflg && fs.f_header != CHKSUM)
		err("Invalid FS header record found - too long");
	eof = 0;			/* not got eof yet */
	sprintf(vname,"%s(%d)",filename,swab(buffp->f_version));
	out = 0;
	chkflg = fs.f_header == CHKSUM;
	flag = select(argc,argv);
	ebcasc(14,fs.f_date,fs.f_date);
	ebcasc(8,fs.f_time,fs.f_time);
	if (flag && xflg)
		{
		fp = uflg ? vname : filename;
		if (sflg && (f = any(fp,":")))
			++f;
		else
			f = fp;
		if (outname[0])
			f = outname;
		fsdate = cvtdate(fs.f_date,fs.f_time);
		filedate = modtime(f);
		if (xflg < 2 && fsdate <= filedate)
			{
			if (vflg && fsdate < filedate)
				printf("current %s newer\n",f);
			}
		else if ((out = fopen(f,"w")) == NULL)
			err("can't creat %s",f);
		}
	while ((l=read(tape,buff,sizeof buff)) != 0)
		{
		if (l < 0)
			err("tape read error");
		if (out)
			output(out,buff,l);
		eof=0;
		if (l > maxlen)
			maxlen = l;
		++rec;
		size =+ l;
		}
	if (out)
		{
		fclose(out);
		if (mflg)
			mdate(f,&fsdate);	/* change to date on tape */
		if (vflg)
			{
			printf("x %s",vname);
			if (!equal(filename,f))
				printf("to %s",f);
			printf("\n");
			}
		}
next:
	++eof;
	lread("EOF1");
	geteof();
	feet = (cnt/0.5 + size/800.0)/12.0;
	tfeet =+ feet;
	if (flag && tflg)
		{
		printf("%5d%c%-32.32s %2d %4d  %.14s %.8s\n",
			swab(fs.f_file),
			(fs.f_doc ? '*' : ' '),
			filename,
			swab(fs.f_version),
			swab(fs.f_size),
			fs.f_date,
			fs.f_time);
		}
	flush();
	}
if (tflg) printf("\ntotals: %d files %.0f feet\n",
	file-1,tfeet);
flush();
}

lread(str) char *str;
{
register int l;
register char *p;
register char *s;

if (nl)
	return(1);
if ((l=read(tape,buff,sizeof buff)) < 0)
	err("tape read error");
if (l == 0)
	return(0);
if (l!=80)
	err("label missing");
ebcasc(l,buff,buff);		/* translate to ascii */
s = str;
for (p=buff; *s; )
	if (*p++ != *s++)
		err("expecting %.4s, got %.4s",str,buff);
return(1);
}

geteof()
{
if (nl)
	return;
while ((read(tape,buff,sizeof buff)) > 0)
	;
}

cvtname(length,ins,outs) char *ins, *outs;
{
register int l;
register int c;
register char *s;

s = outs;
for (l=length; l > 0; --l)
	{
	c = *ins++;
	if (c == ' ')
		continue;
	if (c >= 'A' && c <= 'Z')
		c =- 'A'-'a';
	*s++ = c;
	}
*s = 0;
}

select(argc,argv) char **argv;
{
register int i;

outname[0] = 0;
if (argc <= 0)
	goto gotit;
for (i=0; i<argc; ++i)
	if (match(filename,argv[i]) || match(vname,argv[i]))
		{
	gotit:
		if (wflg)
			{
			printf("%s? ",vname);
			flush();
			if (gets(outname) == NULL)
				exit(0);
			if (outname[0] == 0)
				return(0);
			if (equal(outname,"y"))
				outname[0] = 0;
			}
		return(1);
		}
return(0);
}

ebcasc(len,in,outs) register char *in, *outs;
{
extern char etoa[];
register int l;

for (l=len; l>0; --l)
	*outs++ = etoa[*in++ & 0377];
}

swab(n) int n;
{
struct { char lo, hi; };
int j;
j.lo = n.hi; j.hi = n.lo;
return(j);
}

long mtslnr(lnrp) register char *lnrp;
{
long lnr;
register char *p = &lnr;

p[0] = lnrp[1];
p[1] = lnrp[0];
p[2] = lnrp[3];
p[3] = lnrp[2];
return(lnr);
}

struct data_header
{
int mts_len;		/* length & flags */
long mts_lnr;		/* mts line number */
};

output(outdes,buffer,len) char *buffer; FILE *outdes;
{
register char *p;
register int l;
int k;

p=buffer;
if (qflg || chkflg)
	{
	if (vflg > 2)
		printf("ignore %d byte header record length %d\n",chkhdr,len);
	p =+ chkhdr;		/* past the junk */
	}
for (;p<buffer+len; p=+ l + sizeof (struct data_header))
	{
	l = (p[1]&0377) + ((p[0]&017)<<8);
	if (vflg > 2)
		printf("%d flags=%o %x %x %.3f\n",l,(p[0]>>4)&017,p[1],p[0],mtslnr(p+2)/1000.0);
	k = p + sizeof (struct data_header) + l - (buffer+len);
	if (k > 0)
		printf("record %d bytes too long file %s length %d\n",k,filename,l);
	ebcasc(l,p+sizeof (struct data_header),p+sizeof (struct data_header));
	if (lflg)
		fprintf(outdes,"%12.3f	",mtslnr(p+2)/1000.0);
	fwrite(p+sizeof (struct data_header),l,1,outdes);
	if(ferror(outdes))
		err("write error on %s",filename);
	if((p[0]&0200) == 0)
		putc('\n',outdes);
	}
}

char *mth[12] 
{ "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT",
"NOV", "DEC" };

long cvtdate(date,time) char *date, *time;
{
static struct tm tm;
register int i;
long ftime;
long ltime();
char mon[4];

if ((i=sscanf(date+5,"%2d",&tm.tm_mday)) != 1|| (i=sscanf(date+9,"19%2d",&tm.tm_year)) != 1)
	printf("sscanf failed: %d %.14s\n",i,date);
	
for (i=0; i<12; ++i)
	if (strncmp(mth[i],date,3) == 0)
		{
		tm.tm_mon = i;
		break;
		}
if ((i=sscanf(time,"%2d:%2d:%2d",&tm.tm_hour,&tm.tm_min,&tm.tm_sec)) != 3)
	printf("sscanf failed: %d %.8s\n",i,time);
ftime = ltime(&tm);
/*  printf("cvtdate %.14s %.8s --> %s\n",date,time,ctime(&ftime)); */
return(ftime);
}
