#define	DEFSKIP		 2	/* default number of blank lines after title */
#define	DEFLINE		124	/* default line length */
#define MAXLINE		255	/* maximum number of chars/line */
#define TABSIZE		8	/* number of columns per tab */
int PAGESIZE;		/* actual number of lines per page */
int	DEFPAGE;		/* Default page size (lplines()) */
int LENSTR	DEFLINE;	/* actual length of output line */
char instr[ MAXLINE + 1 ];  /*  input string  */
int lnum,nchar,writeline,nline,namelen;
int iobuf[518/2] ; /* buffer for getc */
int page; /* printed page number for a file */
char *dte; /* pointer to date a file was printed */
char pdate[30], moddate[30]; /* appropriate time vectors */
char	id[64];		/*  User id */
char *in;  /*  pointer to input string  */
int	lskip	37;	/* left hand spaces in title */
int skip	 2;	/* number of blank lines after title */
char	linenumber	1;	/* switch which determines print of linenumbers */
char 	title1	 1;	/* switch for printing page number */
char	title2	 1;	/*   "     "     "     listing date */
char	title3	 1;	/*   "     "     "     filename */
char 	title4	 1;	/*   "     "     "     modification date */
char	title5	1;	/*   "     "     "     id */
char	tab	 1;	/*   "     "     "     full tabs */
char	form	1;	/*   "     "     "  formfeed after each page */
struct {
	char dummy[32];
	int  modtime[2];
	}  buff;
main (argc,argv) int argc; char **argv; {
/*
LISTING  PROGRAM  to give  LINE  NUMBERS
*/
register int i;
int  timevec[2]; /* buffer for call to time */
/*
scan through the parameter field (if there is one) and pick out the file names.
If a file doesn't exist, flag it and get the next one.  If it does, get its date
of lat modification and length of its name.
*/
char *ctime() ; /* routine to set date a file was printed */
extern int fout;
	fout = dup(1);
	DEFPAGE = lplines();
	PAGESIZE  = DEFPAGE;
	nchar = getpw(getuid() & 0377, id);
	if ( nchar ) title5 = 0;
	  else
		{
		in = any(id, ":");
		*in = '\0';
		}
if ( argc > 1 ) i=2; else i=1;
for ( ; i <= argc; i++) {
	if ( argc > 1 )  {
		if ( (++argv)[0][0] == '-' ) if ( getpar(argv) ) continue;
		if ( fopen(*argv,iobuf) < 0 ) {
			writef(2,"File not found: %s\n",*argv);
			continue;
			}
		else {
			namelen = length(*argv);
			stat(*argv,&buff);
			dte = ctime(buff.modtime);
			in = moddate;
			while ( *dte != '\n' ) *in++ = *dte++;
			*in = '\0';
		}
	}
	lnum=10000;
/*
initialize output control variables for each file printed.
*/
	page = 0;
	nchar=0;
	nline=writeline=1;
/*
get the time and date this file is being printed.  note that this 
can vary if more than 1 file is printed.
*/
	time(timevec);
	dte = ctime(timevec);
	in = pdate;
	while ( *dte != '\n' ) *in++ = *dte++;
	*in = '\0';
	in = instr;
	while ( (*in=getc(iobuf)) != -1 )
	if ( *in != '\n' ) {
/*
HAVEN'T  REACHED  an END  OF  LINE  yet, so increment the pointer
and increase the number of characters by 1.  if the number
gets too large (see #define) print out the line and mark the
next line with an appropriate character.
*/
		if ( nchar++ >= LENSTR - 1 ) {
/*
LINE  OVERFLOW. take action
*/
			*(++in)='\0';
			output(argc,argv);
			writeline=0;  }
/*
check for the tab character.  this character advances the printing
to the next column which is an even multiple of 'tabsize' ( see #define  ).
so nchar must be adjusted accordingly.
*/
		else if ( *(in++) == '\t' )
			if ( tab ) nchar=((nchar-1)/ TABSIZE +1)* TABSIZE; 
			else *(in - 1) = ' '; }
	else {
/*
END  OF  LINE reached.  output line with line number.
*/
		if ( writeline || nchar ) {
			*in = '\0';
			output(argc,argv);
			}
		writeline = 1;
		}
/*
at the end of each file, output a form feed.
*/
	putchar('\014');
	flush();
	close(iobuf[0]);
	}
}	
output(argc,argv) int argc; char **argv; {
/*
print out the lines.  put the name of the file in the parameter field
( if ther is one ) at the top of each page.
*/
register int i;
	if ( ++lnum > PAGESIZE ) {
		if ( title1 ) printf(" PAGE %3d",++page);
		if ( title2 ) printf("  %s",pdate);
		if ( argc > 1 ) {
			if ( title3 ) {
				for ( i=0; i < (LENSTR - namelen)/2 - lskip; i++)
					putchar(' ');
				printf("  %s",*argv);
			}
			if ( title4 ) printf("     %s",moddate);
			if ( title5 ) printf("   id=%s",id);
			for ( i = 0; i < skip + 1; i++) putchar('\n');
			lnum = 2 + skip;
		}
		else {
			for ( i = 0; i < skip + 1; i ++) putchar('\n');
			lnum = 2 + skip;
		}
		}
/*
if writeline=0, this line is an overflow from the previous one, so
don't print out a line number.
   
note that tabs are used in the printf to align columns for
output correctly ( if tabs are used in input stream ) .
*/
	if ( !writeline ) {
		if ( linenumber ) printf("        ");
		printf("%s",instr);
	}
	else {
		if ( linenumber ) printf("%5d   ",nline++);
		printf("%s",instr);
	}
	in=instr;
	nchar=0;
	putchar('\n');
	if ( (lnum == PAGESIZE) && ( form ) ) putchar('\014');
}
getpar(opt) char **opt; {
char c;
register int i, num;
	i = 2;
	num = 0;
	while ( (c = opt[0][i++] ) != '\0' ) 
		num = 10 * num + c - '0';
	switch(opt[0][1])  {
/*
change the pagesize
*/
		case 'p':
			PAGESIZE = ( num > 0 ? num : DEFPAGE ) ;
			break;
/*
change the line length
*/
		case 'l':
			LENSTR = ( num <= MAXLINE ? num : MAXLINE );
			if ( LENSTR <= 0 ) LENSTR = DEFLINE;
			break;
/*
change the header titling.
*/
		case 't':
			title1 = (num & 1 ? 1 : 0 );
			title2 = ( (num >> 1) & 1 ? 1 : 0 );
			title3 = ( (num >> 2) & 1 ? 1 : 0 );
			title4 = ( (num >> 3) & 1 ? 1 : 0 );
			title5 = ( (num >> 4) & 1 ? 1 : 0 );
			if ( !(title1 | title2 | title3 | title4 | title5) ) skip = -1;
			lskip = 0;
			if ( title1 ) lskip = 10;
			if ( title2 ) lskip =+ 27;
			break;
/*
number of blank lines after title 
*/
		case 's':
			skip = (num > 0 ? num : DEFSKIP);
			break;
/*
control printing of linenumbers
*/
		case 'L':
			linenumber = !linenumber;
			break;
/*
control outputting of tabs
*/
		case 'T':
			tab = !tab;
			break;
		case 'f':
			form = !form;
			break;
/*
not a valid flag, so assume it is a file
*/
		default:
			return (0);
		}
	return(1);
}
