#

#define	RAW	040	/* tty raw mode */
#define	PARITY	0300	/* parity bits */
#define	CMD	02	/* control-b */
#define	DELAYS	0177400

char *printfile "/tmp/lib.buffer";
int lpr[518/2];	/* line printer buffer */
int eflg 0;	/* echo input */
int tty;	/* dial up line fdes */
int v[3], oldv[3];
int outpid;
int done();
int outdone();

char *ttyname;
char tmp[20];			/* /tmp/ttys */
main(argc,argv) char **argv;
{
register int i;
/*
 * program to run the tty line as a slave.
 */

if (argc > 1)
	ttyname = argv[1];
else
	ttyname = "/dev/ttys";
if (inuse(ttyname[8]))
	err(ttyname," is set up as a UNIX terminal",0);
copy(tmp,ttyname);
move(4,"/tmp",tmp);
tty = open(ttyname,2);	/* open the line */
if (tty < 0)
	err("can't open ",ttyname,0);
setuid(getuid()&0377);
if ((i = creat(tmp,0)) < 0)
	err("Line already in use: ",ttyname,0);
close(i);
signal(1,1);
signal(2,1);
#ifndef	test
if (outpid = fork())
	input();		/* parent */
else
	output();
#endif
#ifdef	test
	output();
#endif
}

input()
{
/*
 * read from the user's terminal and write to the line.
 * terminal is first set to raw mode.
 * on null character from the terminal the program will
 * exit.
 */
int c;
gtty(0,oldv);
v[0] = oldv[0];
v[1] = 0;
v[2] = (oldv[2] & PARITY) | RAW;
stty(0,v);
signal(1,&done);		/* in case of hang up */
while ((c = getch(0)) > 0)
	{
	if (c == CMD)
		{
		puts("\r\nYes ?");
		stty(0,oldv);
		docmd();
		stty(0,v);
		}
	else if (write(tty,&c,1) < 0)
		{
		puts("write error to line\n");
		done();
		}
	}
puts("eof\n");
done();
}

done()
{
int status;
char line[32];

write(tty,"\03\03",2);		/* send exit command */
kill(outpid,1);
stty(0,oldv);
while (wait(&status) != -1)
	;
unlink(tmp);			/* get rid of tmp file */
puts("\n");
puts("\nPrint conversation buffer? ");
if (read(0,line,sizeof line) > 0 && (line[0] == 'y' || line[0] == 'Y'))
	{
	closeall();
	execl("/bin/opr","opr","-r",printfile,0);
	}
else
	unlink(printfile);
exit(0);
}

output()
{
/*
 * read from the remote line and write to the terminal.
 */
register int l;
char c;

signal(1,&outdone);
if (fcreat(printfile,lpr) < 0)
	err("cannot open buffer file",0);
gtty(tty,oldv);
v[0] = oldv[0];
v[1] = 0;
v[2] = (oldv[2] & PARITY) | RAW;
stty(tty,v);
write(tty,"\03",1);		/* start off clean */
for (;;)
	{
	l = read(tty,&c,1);
	write(1,&c,l);		/* write to terminal */
	putc(c,lpr);
	}
stty(tty,oldv);
}

outdone()
{

fflush(lpr);
exit(0);
}

getch(fd)
{
char c;

if (read(fd,&c,1) <= 0)
	return(0);
c =& 0177;
if(eflg)
	write(1,&c,1);
return(c);
}

inuse(ttynum)
{
char ttyinfo[4];
register int i;

if ((i = open("/etc/ttys",0)) < 0)
	err("no /etc/ttys",0);
while (read(i,ttyinfo,4) == 4)
	if (ttyinfo[1] == ttynum)
		{
		close(i);
		return(ttyinfo[0] == '1');
		}
err(&ttynum," not in /etc/ttys",0);
}

err(msg) char *msg;
{
register char *p;
register char **s;

for (s = &msg; p = *s++; )
	puts(p);
puts("\n");
exit(1);
}

puts(msg) char *msg;
{
write(1,msg,length(msg));
}

docmd()
{
int c;

c = getch(0);
if (c == '!')
	{
	if (fork() == 0)
		execl("/bin/sh","sh","-t",0);
	else
		wait(&c);
	}
else
	done();			/* exit on anything else */
}

