#include <stdio.h>

#define	MAXLINE	512
#define	MAXFIELD	100
#define	NL	'\n'
#define	BLANK	' '
#define	TAB	'\t'

#define	YES	1
#define	NO	0

char delim;

struct info 
{
FILE *f;
int n;
char *file;			/* input file name */
FILE *outfile;			/* output for ignored records */
int cnt;			/* number of lines found */
int key;
char *field[MAXFIELD];
char *line[MAXLINE];
} lines[3];

#define	info1	lines[0]
#define	info2	lines[1]

#define	file1	info1.file
#define	file2	info2.file

#define	field1	info1.field
#define	field2	info2.field

#define	f1	info1.f
#define	f2	info2.f

#define	n1	info1.n
#define	n2	info2.n

#define	output	lines[2].outfile
int dflg;
int kflg;
int iflg;
int lflg;
int nflg;

main(argc,argv) char **argv;
{
register int i;
register char *argp;
register struct info *infop = &info1;
char *p;

for (i=1; i<argc; ++i)
	{
	if (* (argp = argv[i]) == '-' && argp[1])
		{
		++argp;
		while (*argp)
			{
			switch(*argp++)
				{
			case 'k':		/* always keep first key */
				++kflg;
				break;
			case 'n':
				++nflg;		/* numeric ordering */
				break;
			case 'l':
				++lflg;		/* by line number */
				break;
			case 'i':		/* ignore ignored keys */
				++iflg;
				break;
			case 'd':		/* delete second key */
				++dflg;
				break;
			case 't':		/* tab character */
				delim = *argp++;
				break;
			case 'o':
				p = argv[++i];
				if (infop->outfile)
					err("more than one output file");
				if ((infop->outfile = fopen(p,"w")) == NULL)
					err("can't open %s for output",p);
				}
			}
		}
	else if (*argp == '+')
		{ infop->key = atoi(++argp); }
	else if (infop < lines+2)
		{
		infop->file = argv[i];
		if (infop->file[0] == '-')
			infop->f = stdin;
		else if ((infop->f = fopen(infop->file,"r")) == NULL)
			err("can't open %s",infop->file);
		++infop;
		}
	else
		err("too many files");
	}
if (file1 == 0 || file2 == 0)
	err("usage: [-tx] %s file1 file2",argv[0]);
if (output == NULL)
	output = stdout;
getline(&info1);
getline(&info2);
i = 0;
while (n1 >= 0 && n2 >= 0)
	{
	if (!lflg)
		{
		if (nflg)
			i = ncmp(field1[info1.key],field2[info2.key]);
		else
			i = strcmp(field1[info1.key],field2[info2.key]);
		}
	if (i == 0)
		{		/* keys match */
		putline(output,&info1,0,0);
		putline(output,&info2,NL,dflg);
		getline(&info1);
		getline(&info2);
		}
	else if (i > 0)
		{
		ignore(&info2,NO);
		}
	else
		{
		ignore(&info1,kflg);
		}
	}
while (n1 >= 0)
	{
	ignore(&info1,kflg);
	}
while (n2 >= 0)
	{
	ignore(&info2,NO);
	}
}

getline(info) register struct info *info;
{
register char *p;
register char **fld;

if (fgets(info->line,MAXLINE,info->f) == NULL)
	return(info->n = -1);
++info->cnt;
if (p = any(info->line,"\n"))
	*p = 0;
else
	err("%s: bad line %d",info->file,info->cnt);
for (p=info->line, fld = info->field; *p; ++p)
	{
	if (!delim)
		while (*p == BLANK || *p == TAB)
			++p;
	*fld++ = p;
	if (fld > info->field+MAXFIELD)
		err("too many fields");
	if (delim)
		{
		while (*p && *p != delim)
			++p;
		if (*p == delim)
			*p = 0;
		else if (*p == 0)
			break;
		}
	else
		{
		while (*p && *p != BLANK && *p != TAB)
			++p;
		if (*p == BLANK || *p == TAB)
			*p = 0;
		else if (*p == 0)
			break;
		}
	}
info->n = fld - info->field;
if (info->n <= info->key)
	err("%s: key (field +%d) missing",info->file,info->key);
while (fld < info->field+MAXFIELD)
	*fld++ = p;
return(info->n);
}

putline(f,info,ch,first) FILE *f; register struct info *info; char ch;
{
register int i;

for (i=first; i<info->n; ++i)
	fprintf(f,"%s%c",info->field[i],delim == 0 ? BLANK : delim);
if (ch)
	putc(ch,f);
}

ignore(info,flg) register struct info *info;
{
if (info->outfile)
	putline(info->outfile,info,NL,0);
else if (flg)
	putline(output,info,NL,0);
else if (!iflg)
	fprintf(stderr,"%s: %s ignored\n",info->file,info->field[0]);
getline(info);
}

ncmp(s1,s2) char *s1, *s2;
{
return(atoi(s1)-atoi(s2));
}
