#include <stdio.h>
#include <ctype.h>

/*
 * to make hack:
 * cc hack.c -lS -lPW -lw -lS
 */

#define	MAXLINE	512
#define	LASTLINE	32767
#define	MAXERR	50
#define	MAXNAME	32
#define	MAXARGS	128
#define	READ	0
#define	WRITE	1
#define	DIGITS	"0123456789"
#define	NO	0
#define	YES	1

#define	IS = 	/* if you're using a V6 compiler delete the = */

int maxerr IS MAXERR;
char line[MAXLINE];
char temp[MAXLINE];
char saveline[MAXLINE];
char firstline[10];		/* first line of first file to edit */
FILE *file, *outfile;
FILE *errin;			/* the error diagnostic file */
char filename[MAXNAME], outname[MAXNAME], name[MAXNAME];
int inline, outline;
char *edargs[MAXARGS];
int edargc;
int status;
int ccount;		/* number of times we have compiled */
int debug IS 0;
int pipes[2];
int errcnt;
char *com_start IS "/* ###";
char *com_end IS "*/";
char edfile[64];
char *any();
int lflg;		/* if using lint */
int warncnt;		/* number of warnings issued */
char *pgname = "";
char def_char = 'c';

main(argc,argv) char **argv;
{
/*
 * program to take the error message output of the C (or other) compiler and
 * insert it back into the source file to make it easy to edit.
 */
register char *argp;

pgname = argv[0];
if (argc <= 1)
	err("usage: %s compile-command",pgname);
--argc;
++argv;
edargs[0] = "vi";
lflg = equal(argv[1],"lint");
while (argc > 0 && *(argp = *argv) == '-')
	{
	++argv;
	--argc;
	++argp;
	switch(*argp)
		{
	case 'l':
		++lflg;
		break;
	case 'm':
		maxerr = atoi(argp);
		break;
	case 'e':
		edargs[0] = *argv++;
		--argc;
		break;
		}
	}
for (;;)
	{
	edargc = 1;
	firstline[0] = 0;
	if (ccount++)
		if (!ask("compile? "))
			break;
	if (pipe(pipes) < 0)
		err("can't get pipe");
	compile(argc,argv);
	errin = fdopen(pipes[READ],"r");
	close(pipes[WRITE]);
	fixfiles();
	while (wait(&status) != -1)
		;
	fclose(errin);
	errin = NULL;
	if (edargc > 1)
		{
		if (!ask("%s? ",edargs[0]))
			break;
		edargs[edargc] = 0;
		sprintf(edfile,"/bin/%s",edargs[0]);
		run(edfile,edargs);
		while (edargc > 1)
			cfree(edargs[--edargc]);
		}
	else
		break;
	}
}

compile(argc,argv) char **argv;
{
/*
 * compile the program with the command specified as the 
 * argument list. arrange for the error messages to be written
 * into the pipe we just created.
 */
if (debug || fork() == 0)
	{
	argv[argc] = 0;
	close(1);		/* re-arrange the file descriptors */
	dup(pipes[WRITE]);
	closeall();
	pexec(argv[0],argv);
	err("no %s",argv[0]);
	}
}

/* VARARGS 1 */
ask(msg,d1,d2,d3,d4) char *msg;
{
printf(msg,d1,d2,d3,d4);
if (fgets(line,sizeof line,stdin))
	if (line[0] == 'y' || line[0] == '\n')
		return(1);
return(0);
}

fixfiles()
{
register int l;
int n;

clear(name,sizeof name);
clear(filename,sizeof filename);
while (fgets(line,MAXLINE,errin))
	{
	l = strlen(line);
	line[--l] = 0;			/* kill the NL character */
	copy(saveline,line);		/* save entire message for later */
	if (!getline(line,filename,&n))
		{
		printf("%s\n",saveline);
		continue;
		}
	if (!equal(filename,name))
		{		/* change of files */
		finish();
		start();
		}
	if (++errcnt < maxerr)
		{
		sprintf(temp,"%s %s @@@ %s\n",com_start,saveline,com_end);
		copy(saveline,temp);
		insert(n,saveline);
		if (firstline[0] == 0)
			sprintf(firstline,"+%d",outline);
		}
	else if (errcnt == maxerr)
		printf("%s: More than %d errors; extra ignored\n",name,maxerr);
	}
finish();
}

getline(line,filename,n) char *line, *filename; int *n;
{
register char *p;
register char *s;

*n = 0;			/* return zero if no line # found */
if (lflg)
	return(getlint(line,filename,n));
s = line;
while (*s == ' ')
	++s;
p = any(line,":");
if (!p)
	return(NO);		/* no line number in msg */
*p++ = 0;
if (isdigit(*s))		/* no file name present */
	{
	if (name[0] == 0 && filename[0] == 0)
		err("no file name found: %s",saveline);
	p = s;
	}
else if (!any(line,"( \t:'\""))
		copy(filename,line);
if (!isdigit(*p))
	return(NO);		/* no line number in msg */
*n = atoi(p);
return(*n);
}

getlint(line,filename,n) char *line, *filename; int *n;
{
/*
 * pick up the line number from a lint output
 * ignore the lint library comments.
 */
register char *p;
register char *s;
register char *q;

*n = 0;			/* return zero if no line # found */
for ( s = line; s && (s = any(s,"\"")); s=q)
	{			/* from lint */
	if (q = any(++s,"\""))
		{
		*q++ = 0;
		if (eq(s,"/usr/lib/llib-"))
			continue;
		copy(filename,s);
		if (q = any(q,DIGITS))
			p = q;
		if (!isdigit(*p))
			continue;		/* no line number in msg */
		*n = atoi(p);
		return(*n);
		}
	}
return(NO);
}

start()
{
/*
 * open up the current source file and a temp file to put the
 * new source including error diagnostics in.
 */
register char *p;
char c;
char *endstr();

copy(name,filename);
if ((file = fopen(name,"r")) == NULL)
	err("cannot open %s",name);
copy(outname,name);
p = endstr(outname)-1;
*--p = 'X';			/* build a temp name in same directory */
if ((outfile = fopen(outname,"w")) == NULL)
	err("cannot open %s",outname);
errcnt = 0;
inline = 1;
outline = 1;
switch(c = suffchar(name))
	{
case 'a':
case 'c':
	com_start = "/* ###";
	com_end = "*/";
	break;
case 'f':
	com_start = "c ###";
	com_end = "";
	break;
case 'i':
case 'p':
	com_start = "{ ###";
	com_end = "}";
	break;
case 'r':	/* ratfor */
	com_start = "# ###";
	com_end = "";
	break;
default:
	if (!warncnt++)
		printf("%s warning: '%s' suffix .%c unknown; .%c assumed\n",pgname,name,c,def_char);

	return;
	}
def_char = c;
}

char *calloc();
char *stralloc(str) char *str;
{
register char *p;

p = calloc(strlen(str)+1,1);
copy(p,str);
return(p);
}

finish()
{
if (outfile == NULL)
	return;
insert(LASTLINE,"");		/* flush to the last line */
fclose(file);
fclose(outfile);
file = outfile = NULL;
if (unlink(name) < 0 || link(outname,name) < 0  || unlink(outname) < 0)
	err("hack: can't mv %s %s",outname,name);
if (edargc == 1)
	edargs[edargc++] = stralloc(firstline);
edargs[edargc++] = stralloc(name);
printf("%s: %d error%s\n",name,errcnt,errcnt == 1 ? "" : "s");
}

insert(lnum,text) char *text;
{
/*
 * insert "text" into file before line "lnum".
 * also remove any previous comments that we introduced.
 */
register int l;
l = strlen(com_start);
while (lnum > inline)
	{
	if (fgets(temp,sizeof temp,file))
		{
		++inline;
		if (strncmp(com_start,temp,l))	/* if not one of our's */
			{
			++outline;
			fputs(temp,outfile);
			}
		}
	else
		inline = LASTLINE;
	}
			
fputs(text,outfile);
++outline;
}

run(f,args) char *f, **args;
{

if (fork() == 0)
	{
	closeall();
	execv(f,args);
	err("no %s",f);
	}
signal(2,1);
while (wait(&status) != -1)
	;
signal(2,0);
}

char *suffix(ptr,delim) char *ptr, delim;
{
/*
 * return the suffix delimeted by "delim".
 */
register char *p, *q;

for (p=ptr, q = 0; *p; ++p)
	if (*p == delim)
		q = p+1;
if (q == 0)
	q = p;
return(q);
}

suffchar(ptr) char *ptr;
{
register char *p;

p = suffix(ptr,'.');
return(*p);
}
