#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <tape.h>

char *namep;
char dosname[20];
int maxcnt = 9999;
FILE *tape;
#define	BUFFSIZE	512
char	buff[BUFFSIZE];
int counter;

struct label 
{
	int file1,file2,ext;
	char user, group;
	char prot, junk;
	int date;
	int count;
} header;

#define	CFLAG	0100000

int argflag;
int tflg;
int bflg;	/* binary output */
int vflg;	/* verbose */
int cflg;	/* contiguous file */
int xflg;	/* extract from tape */
int sflg;	/* save on tape */
int uflg;	/* upper case conversion */	

int argcnt;
int icnt;
char **argp;
char *tapename;
int headsize = BUFFSIZE;
char	*pgname;

char *cvtdate();

main(argc,argv)

int argc;
char *argv[];

{
	char c;
	register char *p;

	tapename= "/dev/rmt0";
	pgname = *argv++; /* get program name */
	--argc;
	p = *argv;
	if(*p++ == '-')
		{
		while (*p)
			switch(c = *p++)
			{
			case 'u':		/* upper case folding */
				++uflg;
				break;
			case 'v':		/* verbose */
				++vflg;
				break;
			case 's':		/* save files */
				++sflg;
				break;
			case 'x':		/* extract files */
				++xflg;
				break;
			case 'f':		/* file instead of tape */
				headsize = sizeof header;
			case 'T':		/* still a magtape */
				--argc; argv++;
				tapename = *argv;
				break;
			case 'c':		/* write contiguous file format */
				++cflg;
				break;
			case 't':		/* table of contents */
				++tflg;
				break;
			case 'n':		/* only do n files */
				maxcnt = 0;
				while (*p>='0' && *p<='9')
					maxcnt = maxcnt * 10 + *p++ - '0';
				break;
			case 'b':		/* binary format */
				++bflg;
				break;
			case 'i':		/* ignore n records */
				icnt = 0;
				while (*p>='0' && *p<='9')
					icnt = icnt * 10 + *p++ - '0';
				break;
			default:
				if(c>='0' && c<='7')
					tapename[8] = c;
				else
					err("bad option");
				}
		++argv;
		--argc;
		}
	argp = argv;
	argcnt = argc;
	if (tflg)
		readtape();
	else if (xflg)
		readtape();
	else if (sflg)
		savetape();
	else
		err("Usage: %s -[xts] [-v] [-b] [-n#] [-f tape] file ...",pgname);
}

readtape()
{
	FILE *ptest();
	FILE *file;
	int	files;
	int	rc;
	int i;
	int usr,grp;

	if ((tape=fopen(tapename,"r")) == NULL)
		err("can't open %s",tapename);

	rc=0;
	files=0;
	i = 0;
	while ( (rc=read(fileno(tape),buff,headsize))>0)
	{
		if(rc!=14)
			err("not DOS structured tape");
		move(sizeof header, buff, &header);
		if(++i <= icnt)
			{
			skip();
			continue;
			}
		/* got the header - if in toc mode just print it */
		cvthead(&header);
		if(files >= maxcnt)
			break;
		if(tflg)
			{
			usr = header.user;
			grp = header.group;
			skip();
			if(argcnt > 0 && ptest() != NULL)
				continue;

			++files;
			printf("%3d: %-10s [%3o,%3o]",i,dosname,grp&0377,usr&0377);
			if (vflg)
				printf(" %03o %4d", header.prot&0377, header.count);
			printf(" %4d%c %s\n", counter,
				((header.date & CFLAG) ? 'C' : ' '),
				cvtdate(header.date & 077777));
			}
		else
		{
			file = ptest();
			if (file != NULL)
			{
				++files;
				while ((rc=read(fileno(tape),buff,512))>0)
					outdos(file,buff,rc);
				if(file != stdout)
					close(file);
				if (vflg)
					printf("%s extracted to %s\n",dosname,namep);
			}
			else
				skip();
		}
	}
	printf("%s: files %d\n",pgname,files);
	exit(0);
}



/*
 * routine to convert dos /fa files to UNIX format
 */
outdos(file,buffp,count)
register char *buffp;
int count;
FILE *file;
{ 
	register char ch;

	if(bflg)
		{	/* binary write */
		if (write(fileno(file),buffp,count)<0)
			err("write error");
		return;
		}

	while (--count>=0)
	{
		ch=dout(*buffp++);
		if (ch!=0)
			putc(ch,file);
	}

	if(ferror(file))
		err("write error");
}

dout(ch)
char ch;
{
	register char c;

	c=ch&0177; /* mask down to 7 bits */
	if (c>='A' && c<='Z' && uflg) return (c+('a'-'A'));
	switch(c)
	{
	case '\r':
	case 0177:
	case 013:
		c=0;
	};
	return (c);
}

cvthead(header)
struct label *header;
{
	/* program to print out a pdp 11 header */
	register char *dosp;
	register char c;
	register char *dosx;
	int i;

	rad50(header->file1,&dosname[0]);
	rad50(header->file2,&dosname[3]);
	dosname[6]='.';
	rad50(header->ext,&dosname[7]);
	dosx = (dosp = dosname);

	for (i=0; i<10; ++i)
		if( (c = *dosx++) !=' ')
			*dosp++ = c;

	*dosp = 0;
}

phead(header)
struct label *header;
{
	printf("%s[%o,%o]? ",dosname,header->user&0377,header->group&0377);
}

FILE *ptest()
{
	char c;
	char name[64];
	char *p;
	FILE *file;
	int i;

	if(argcnt > 0)
	{	/* pattern provided */
		for (i=0; i<argcnt; ++i)
			if(match(dosname,argp[i]))
			{
				namep = dosname;
				goto create;
			}
		return((FILE *) NULL);
	}

	phead((struct label *) buff);
begin:
	if(argflag)
	{
		namep = dosname;
		goto create;
	}

start:
	/* read in a prompt from the user */
	if ((c=getchar())=='\n') return((FILE *) NULL);
	if (c<=0) exit(0);
	if (c=='-') goto op;
	if (c=='*') {
		namep= dosname; 
		goto openit;
	};
	p = name;
	*p++ = c;
	while ((c=getchar())!='\n')  
		*p++ = c;

	*p++ = '\0';
	if (name[0]=='$') return(stdout);
	if (argflag = name[0] == '%') goto begin;
op:
	namep = name;
openit:
	/* flush input buffer */ 
	while (c!='\n') c=getchar();
create:
	if(tflg)
		return((FILE *) NULL);
	if( (file=fopen(namep,"w")) == NULL)
	{
		printf("can't create %s. \n file name? ",namep);
		goto start;
	};
	return (file);
}

skip()
{
	/* skip to the end of the current tape file */
	counter = 0;
	while(read(fileno(tape),buff,512)>0)
		++counter;
}

char *mons[] =
{ 
	"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug",
	"Sep", "Oct", "Nov", "Dec", "BAD" };
#define	FEB	1	/* index for february */

int days[12] = { 
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

char *cvtdate(date) 
{
	static char outdate[10];
	register int year, day, mon;

	date &= 077777;
	if (date == 0)
		return("");
	year = date/1000 + 70;
	days[FEB] = (year & 03) ? 28 : 29;
	day = date % 1000;
	for (mon=0; mon<12; ++mon)
		if (day <= days[mon])
			break;
		else
			day -= days[mon];

	sprintf(outdate,"%2d-%s-%2d",day,mons[mon],year);
	return(outdate);
}

savetape()
{

	register int i;

	if ((tape=fopen(tapename,"w")) == NULL)
		err("can't open %s",tapename);
	for (i=0; i<argcnt; ++i)
		{
		savefile(argp[i]);
		if (vflg)
			printf("%s saved\n",argp[i]);
		if (headsize != sizeof header)
			{
			if (tcon(fileno(tape),WTM,3) < 0)
				err("can't WTM");
			if (tcon(fileno(tape),BSF,2) < 0)
				err("can't BSF");
			}
		}
	fclose(tape);
}

savefile(namep) char *namep;
{
register int l;
register FILE *file = fopen(namep,"r");
long modtime();

if (file == NULL)
	err("can't open %s",namep);
header.user = 1; header.group = 1;
header.prot = 0233;
header.date = dosdate(modtime(namep));
if (cflg)
	{
	header.date |= CFLAG;
	fseek(file,0L,2);	/* to end of file */
	header.count = (ftell(file)+511L) / 512;
	fseek(file,0L,0);	/* to start of file again */
	}
else
	{
	header.date &= ~CFLAG;
	header.count = 0;
	}
cvtname(namep,&header.file1);
write(fileno(tape),&header,sizeof header);

while ((l = read(fileno(file),buff,BUFFSIZE)) > 0)
	{
	if (bflg)
		{
		if (l < BUFFSIZE)
			clear(buff+l,(BUFFSIZE)-l);
		if ( write(fileno(tape),buff,BUFFSIZE) < 0)
			err("write error");
		}
	else
		putdos(tape,buff,l);
	}
if (!bflg)
	{
	l = froom(tape);
	while (--l >= 0)
		putc(0,tape);
	fflush(tape);
	}
fclose(file);
}

putdos(file,buff,l) FILE *file; register char *buff; register int l;
{
register int c;

do
	{
	c = *buff++;
	if (c == '\n')
		putc('\r',file);
	else if (islower(c))
		c = toupper(c);
	if (c != '\r')
		putc(c,file);
	}
while (--l);
if (ferror(file))
	err("write error");
}

char *radaddr;		/* first bad character in radpk address */
cvtname(filename,radname) char *filename; int *radname;
{
radname[0] = 0;
radname[1] = 0;
radname[2] = 0;

radaddr = filename;
*radname++ = radpk(radaddr);
if (*radaddr == '.')
	{
	++radaddr;
	++radname;
	}
else
	*radname++ = radpk(radaddr);
while (*radaddr && *radaddr != '.')
	++radaddr;
if (*radaddr == '.')
	*radname++ = radpk(++radaddr);
}

/* general utility routines */ 

radpk(ptr) 
char *ptr;
{
register int w;

radaddr = ptr;
w = radch();
w=* 40;
w=+ radch();
w=* 40;
w=+ radch();
return(w);
}

radch()
{
register int ch;
ch = *radaddr++;
if(ch==' ')
	return(0);
if(ch=='$')
	return(033);
/* if(ch=='.') 
	return(034); /* . is important in file names */
if(ch>='a' && ch<= 'z')
	return(ch-'a'+1);
if(ch>='A' && ch<='Z')
	return(ch-'A'+1);
if(ch>='0' && ch<='9')
	return(ch-'0'+036);
--radaddr;
return(0);
}

dosdate(time) long time;
{
register struct tm *tm = localtime(&time);

return((tm->tm_year-70)*1000 + tm->tm_yday + 1);
}

tcon(tape,fn,cnt)
{
int arg[3];

arg[2] = 0;
arg[TAPE_FN] = fn;
arg[TAPE_CNT] = cnt;
return(stty(tape,arg));
}
