#
/*			Copyright 1976 by Bill Webb.	 		*/
#define	maxblock	576
#define	master	-1
#define	maxmap	36			/* number of words per map */
#define	mapsize	maxmap*2

#define	mastermap	0104
#define	filemaps	070
#define	alldir	d = &dir[0]; d< &dir[maxdir]; ++d
#define	maxarg	256
#define contig	0100000
#define maxdir 56 
#define	halfdir	28
#define	dirsize	(sizeof dir[0])
#define ufd1 0102
#define ufd2 0103
#define mfd1 0100
#define mft2 0100

int zero;
int in;
int curblk;
int map_file[maxmap];
int map_master[maxmap];

struct dir
{
int d_name[2];
int d_ext;
int d_date;
int d_end;
int d_start;
int d_length;
int d_last;
char d_prot;
char d_use;
} dir[maxdir];

int dflg;
int iflg;
int sflg;
int tflg;
int errflg;
char used[maxarg];
int zflg;
int oflg;
int vflg;

char tapename[] "/dev/tap0";
int rflg;

int tape;
int lastdir;
int buff[256];
char filename[16];
char *pgname;
char **argv;
int argc;

main(argcx,argvx)
char *argvx[];
{
register int i;
register struct dir *d;
int j;
register char *argp;
int restore();
int delete();
char c;
int sum;
int temp;

argc = argcx;
argv = argvx;


pgname = *argv++;
--argc;
argp = *argv;
if(argc>0 && *argp++ == '-')
	{
	while (*argp)
	switch(c = *argp++)
	{
	case 't':
		++tflg;
		break;

	case	'd':
		++dflg;
		break;

	case 'r':
		++rflg;
		break;

	case 'z':
		++zflg;
		break;

	case	'v':
		++vflg;
		break;

	case	'o':		/* output to standard output */
		++oflg;
		break;

	case	's':
		++sflg;
		break;

	case	'i':
		++iflg;
		break;

	default:

		if(c>='0' && c<='7')
			{
			tapename[8] = c;
			break;
			}
		err("invalid switch %c",c);
	}
	++argv;
	--argc;
	}

if(dflg + sflg + rflg > 1)
	err("conflicting options specified");


tape = open(tapename,2);
if(tape<0)
	{
	printf("%s: %s -",pgname,tapename);
	perror();
	}

seek(tape,ufd1,3);
seek(tape,2,1);		/* past link block */
if(read(tape,&dir[0],dirsize*halfdir)<0)
	err("tape read error");
seek(tape,ufd2,3);
seek(tape,2,1);		/* past link block */
if(read(tape,&dir[halfdir],dirsize*halfdir)<0)
	err("tape read error");

sum = 0;

for (alldir)
	if(d->d_name[0]!=0)
		{
		++lastdir;
		sum =+ dir[i].d_length;
		}
if(tflg)
	{
	printf("total # of files = %d\n",lastdir);

	for (i=0; i<maxdir; ++i)
		{
		if(dir[i].d_name[0]==0)
			continue;
		prdir(i);
		}
	printf("total blocks used %d\n",sum);
	}

if(rflg)
	rdcmd(&restore);
if(dflg)
	rdcmd(&delete);
if(sflg)
	savecmd();
if(errflg)
	exit(1);
}



err(s,d1,d2,d3,d4)
char *s;
{
extern errno;

printf("%s: error - ",pgname);
printf(s,d1,d2,d3,d4);
if(errno)
	{
	printf(" ... ");
	perror("");
	}
putchar('\n');
exit(1);
}

restore(n,file)
char *file;
{
register int block;
int l;
int output;
register int length;
register int i;
struct dir *d;

d = &dir[n];			/* point to proper entry */
if(oflg)
	output = dup(1);
else
	if((output=creat(file,0664))<0)
		err("can't creat");

length = d->d_length;
block=d->d_start;
if (d->d_date & contig)
	{
	seek(tape,block,3);
	for (i=0; i<length; )
		{
		l=read(tape,buff,512);
		if(l<0)
		readerr:
			err("read error");
		if(++i == length)
			l = d->d_end;
		writebf(output,buff,l);
		}
	}
else
	{
	for (i=0; i<length; )
		{
		if(block<0)
			{
/*
			printf("reading %d in reverse\n",-block);
 */
			seek(tape,-block,3);
			l=read(tape,buff,512);
			if(l<0)
				goto readerr;
			reverse();
			}
		else
			{
			seek(tape,block,3);
			l=read(tape,buff,512);
			if(l<0)
				goto readerr;
			}
		if(++i == length)
			l = d->d_end;
		writebf(output,&buff[1],l-2);
		block = buff[0];
		}
	if(block!=0)
		err("bad link");
	}
close(output);
if(vflg)
	printf("%s restored\n",file);
}

reverse()
{
register int *s, *f;
register int temp;

s = &buff[0];
f = &buff[256];

while (s<f)
	{
	temp = *s;
	*s++ = (*--f);
	*f = (temp);
	}

}

writebf(out,bf,l)
int *bf;
int out;
int l;
{

/*
 * routine to write a bfer out onto a file. if the -z option
 * is on then only write non-zero blocks.
 */

register int *p;
register int n;

if(zflg)
	{
	p = bf;
	n = l >> 1;
	do
		if( *p++ )
			goto put;
	while (--n);
	seek(out,l,1);		/* to end off file + l */
	return;
	}

put:
write(out,bf,l);
}

findmap(num)
{
/* find the bit map for file "n".
 * if n < 0 then its the master bit map. 
 */
register int bn,off;
register int n;
n = num;

if (n < 0)
	{
	bn = mastermap;
	off = 4*2;
	}
else
	{
	bn = filemaps + (n/7);
	off = (n % 7) * 36*2;
	}
seek(tape,bn,3);
seek(tape,off,1);
}


rdcmd(cmd)
int (*cmd)();
{

register int i;
register int j;

for (i=0; i<maxdir; ++i)
	{
	if(dir[i].d_name[0]==0)
		continue;
	cvtname(dir[i].d_name,filename);
	for (j=0; j<argc; ++j)
		{
		if(match(filename,argv[j]))
			{
			++used[j];
			(*cmd)(i,filename);
			}
		}
	}

for (i=0; i<argc; ++i)
	if(used[i]==0)
		{
		printf("dosdt: %s not found\n",argv[i]);
		++errflg;
		}
}

delete(n,file)
char *file;
{
register int i;

/*
 * delete file "n" from the tape. 
 */

readmap(master,map_master);
readmap(n,map_file);
for (i=0; i < maxmap; ++i)
	map_master[i] =& ~ map_file[i];
writemap(master,map_master);
dir[n].d_name[0] = 0;
filefind(n);
if(write(tape,&dir[n],dirsize) < 0)
	err("tape write error");
if(vflg)
	printf("dosdt: %s deleted.\n",file);
}

filefind(n)
{

/*
 * seek to start of directory entry for file "n".
 */

register int bn;
register int off;

if(n < halfdir)
	{
	bn = ufd1;
	off = 2 + n*dirsize;
	}
else
	{
	bn = ufd2;
	off = 2 + (n-halfdir) * dirsize;
	}
#ifdef	debug
printf("filefind: %d ==> %d b + %d \n",n,bn,off);
#endif
seek(tape,bn,3);
seek(tape,off,1);
}

readmap(n,map)
int map[maxmap];
{

curblk = 0;
findmap(n);
if(read(tape,map,mapsize)<0)
	err("error reading bit map");
}

writemap(n,map)
int map[maxmap];
{

findmap(n);
if(write(tape,map,mapsize)<0)
	err("error writing bit map");
}


savecmd()
{
register int i,j;

for (i=0; i<argc; ++i)
	{
	for (j=0; j<maxdir; ++j)
		{
		if(dir[j].d_name[0] == 0)
			continue;
		cvtname(dir[j].d_name,filename);
		if(equal(argv[i],filename))
			delete(j,argv[i]);
		}
	for (j=0; j<maxdir; ++j)
		{
		if(dir[j].d_name[0] == 0)
			goto gotit;
		}
	err("tape directory full file %s",argv[i]);

	gotit:
		save(argv[i],j);
	}

}

save(name,n)
char *name;
{
register int block, last;
register int l;

readmap(master,map_master);
clear(map_file,sizeof map_file);
in = iflg ? dup(0) : open(name,0);
if(in < 0)
	err("no %s",name);
block = getblk();
clear(&dir[n],sizeof dir[n]);
doscvt(name,dir[n].d_name);
dir[n].d_prot = 0233;
dir[n].d_start = block;
dir[n].d_date = dosdate() & 077777;
last = 0;
while ((l=readbf(&buff[1],510)) > 0)
	{
	buff[0] = getblk();
	if(block == 0)
		err("no space for %s",name);
	dir[n].d_length++;
	seek(tape,block,3);
	if(write(tape,buff,512) < 0)
		err("tape write error");
	last = block;
	block = buff[0];
	dir[n].d_end = l+2;
	if(l < 510)
		break;
	}
if(last)
	{
	seek(tape,last,3);
	write(tape,&zero,2);		/* set last link to 0 */
	}
dir[n].d_last = last;
if(block)
	{
	clrbit(block,map_master);
	clrbit(block,map_file);
	}
writemap(master,map_master);
writemap(n,map_file);
filefind(n);
if(write(tape,&dir[n],dirsize) < 0)
	err("tape write error");
close(in);
if(vflg)
	printf("dosdt: %s saved\n",name);
}


getblk()
{
register int i;

for (i=curblk; i<maxblock; ++i)
	{
	if(getbit(i,map_master) == 0)
		{
		setbit(i,map_master);
		setbit(i,map_file);
		curblk = i;
#ifdef	debug
		printf("getblk: block %d\n",i);
#endif
		return(i);
		}
	}
curblk = i;
return(0);
}

readbf(buffer,len)
char *buffer;
{

register int l,n;
register char *p;

p = buffer;
l = len;

while ( (n = read(in,p,l)) > 0)
	{
	if( (l =- n) == 0)
		return(len);
	p =+ n;
	}
if(n < 0)
	err("input read error");
clear(p,l);
return(len-l);
}


prdir(i)
{
char c;
cvtname(dir[i].d_name,filename);
c = (dir[i].d_date &contig) ? 'c' : ' ';
if(vflg)
	printf("%-10.10s %3d %5o %5o %5o %c\n",
		filename,dir[i].d_length,dir[i].d_start,
		dir[i].d_last,dir[i].d_end,c);
else
	printf("%-10.10s %3d %5.5o %c\n",
		filename,dir[i].d_length,dir[i].d_start,c);
}

dosdate()
{
register int *tm;
int tvec[2];

time(tvec);
tm = localtime(tvec);
return(tm[7] + (tm[5]-70) * 1000);
}

/*			Copyright 1976 by Bill Webb.	 		*/
getbit(n,map)
int *map;
{
register int i;

i = map[n >> 4];
return( (i >> (n%16)) & 1);
}

putbit(n,map,bit)
int *map;
{
register int *m;
register int i;

m = map + (n >> 4);
i = 1 << (n % 16) ;
*m = bit ? *m & ~i : *m | i;
}

setbit(n,map)
int *map;
{
register int *m;
register int i;

m = map + (n >> 4);
i = 1 << (n % 16) ;
*m =| i;
}


clrbit(n,map)
int *map;
{
register int *m;
register int i;

m = map + ( n >> 4);
i = 1 << (n % 16) ;
*m =& ~ i;
}
#
/*			Copyright 1976 by Bill Webb.	 		*/


/* general utility routines */ 

cvtname(name,str)
char *str;
int *name;
{
register char *p;
register char *q;
register int *n;

n = name;
p = str;

if(*n == 0)
	err("bad name");

rad50(*n++,p);
p=+ 3;
rad50(*n++,p);
p=+ 3;
if (*n!=0)
	*p++ = '.';
rad50(*n,p);
p=+ 3;
*p++ = 0;
q = p = str;
do 
	if (*p!=' ')
		*q++ = *p;
while (*p++);
}

endstr(s)
char *s;
{
while (*s) ++s;
return(s);
}

radpk(ptr) 
char *ptr;
{
register int w;
register char *p;

w = 0;
p = ptr;
w = radch(*p++);
w=* 40;
w=+ radch(*p++);
w=* 40;
w=+ radch(*p++);
return(w);
}

radch(c) 
{
register int ch;
ch=c;
if(ch == ' ')
	return(0);
if(ch=='$')
	return(033);
if(ch=='.') 
	return(034);
if(ch>='a' && ch<= 'z')
	return(ch-'a'+1);
if(ch>='A' && ch<='Z')
	return(ch-'A'+1);
if(ch>='0' && ch<='9')
	return(ch-'0'+036);
return(0);
}

doscvt(file,out)
char *file;
int *out;
{
/*
 * convert the unix name in "file" to a dos rad50 
 * name in "out". 
 */
register char *p, *q;
register int *o;
char name[10];
char ext[6];

clear(name,10);
clear(ext,6);

q = name;
o = out;
p = file;

while (*p)
	{
	if(*p == '.')
		{
		q = ext;
		++p;
		}
	else
		*q++ = *p++;
	}
*o++ = radpk(name);
*o++ = radpk(name+3);
*o++ = radpk(ext);
#ifdef	debug
printf("doscvt: %s ==> %o %o %o\n",name,out[0],out[1],out[2]);
#endif
}


putchar(c)
char c;
{
write(2,&c,1);
}
