#include <stdio.h>

#define	BELL	07
#define	FF	014
#define	NFF	0214		/* FF that gets output thru tty driver */
#define	NL	'\n'
#define	CR	'\r'
#define	BUFFSIZE	512
#define	HUP	0000001
#define	TABS	0000002
#define	UPPER	0000004
#define	ECHO	0000010
#define	CRMOD	0000020
#define	RAW	0000040
#define	EVEN	0000200
#define	ODD	0000100
#define	BSDELAY	0100000
#define	FFDELAY	0040000
#define	CRDELAY	0030000
#define	TABDELAY 006000
#define	NLDELAY	0001400
#define	DELAYS	(BSDELAY|FFDELAY|CRDELAY|TABDELAY|NLDELAY)
#define	setmode(n)	ttymode(n,0)
#define	clrmode(n)	ttymode(0,n)
char buff[BUFFSIZE];		/* input buffer */
extern fin[];
int tty;
long incnt;
#define	MAXPAGES	256
long pages[MAXPAGES];		/* start of page addresses */
int oldv[3], newv[3];
int attn();
int pflg;
int lflg;			/* list mode for lanpars etc. */
int rflg;			/* remove file after use */
int dflg 1;			/* for dbl spaced output */
int startpage;
int endpage 32767;
int page 1;
char lastch NFF;
char *argp;
char ttyname[10] "/dev/tty";

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} statb ;

main(argc,argv) char **argv;
{
/*
 * ditto: print out a file on the multi-writer.
 * modes of operation:
 * -p	pause at end of page for user to insert more paper
 * -r	remove each file after printing
 * -d	output is dbl spaced
 * -sn	start at page "n"
 * -en	stop at page "n"
 * input is from files specified or standard input if
 * no files given.
 */
register int i;
register FILE *file;
int n;

n = ttyn(1);			/* number of the tty */
if (n == 'x')
	err("ditto: cannot find tty");
append(ttyname,&n);
tty = open(ttyname,0);
if (tty < 0)
	err("ditto: can't open %s - probably online",ttyname);
if (stat(ttyname,&statb) < 0)
	err("ditto: cannot stat %s",ttyname);
chmod(ttyname,0600);		/* only I can read or write it */
fprintf(stderr,"Hit TOF, line up the paper, then hit return on %s\n",ttyname);
gtty(tty,oldv);
move(sizeof oldv,oldv,newv);
clrmode(ECHO|DELAYS);
signal(2,&attn);
if (read(tty,buff,sizeof buff) <= 0)
	done();
clrmode(CRMOD);
setout();
for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		{
		++argp;
		while (*argp)
			{
			switch(*argp++)
				{
			case 'd':		/* dbl spaced */
				++dflg;
				clrmode(CRMOD);
				break;
			case 's':		/* start at page ? */
				startpage = cvtint();
				break;
			case 'e':
				endpage = cvtint();
				break;
			case 'l':		/* list mode (for lanpars) */
				++lflg;
			case 'p':
				++pflg;
				if (dflg >= 1)
					break;
			case 'n':		/* not dbl spaced */
				setmode(CRMOD);
				dflg = 0;
				break;
			default:
				err("invalid switch %s",argp-1);
				}
			}
		}
	else
		{
		if ((file = fopen(argp,"r")) == NULL)
			err("can't open %s",argp);
		dofile(file);
		close(file);
		if (rflg)
			unlink(argp);
		}
	}
if (file == NULL)
	dofile();
done();
}

done()
{
/*
 * restore state of tty.
 */
stty(tty,oldv);
chmod(ttyname,statb.s_flags);		/* reset the mode */
exit(0);
}

attn()
{ done(); }

dofile(file) FILE *file;
{
register int c;

while ((c = getc(file)) != EOF)
	{
	++incnt;
	switch(c)
		{
	case FF:
		putff();
		break;
	case NL:
		if (dflg)
			{
			if (lastch != NL)
				putch(CR);
			}
		putch(c);
		break;
	default:
		putch(c);
		}
	}
putff();
flush();
}

putff()
{
if ((lastch&0177) == FF)
	return;
if (!lflg)
	putch(NFF);
if (page < MAXPAGES)
	pages[page] = incnt;
++page;
if (pflg)
	{
	putchar(BELL);
	flush();
	setmode(CRMOD);
	if (read(tty,&buff,sizeof buff) <= 0)
		done(0);
	clrmode(CRMOD);
	}
if (lflg)
	putch(NFF);
}

cvtint()
{
register int n;
register int c;
n = 0;
while ( '0' <= (c = *argp) && c <= '9')
	{
	n = n * 10 + c - '0';
	++argp;
	}
return(n);
}

putch(c)
{
lastch = c;
if (startpage <= page && page <= endpage)
	putchar(c);
}

ttymode(set,clr)
{
newv[2] = (newv[2] & ~clr) | set;
stty(tty,newv);
}
