#include <stdio.h>
#define	BS	12

int *buff;
int count;
int offset;

int blocksize = BS * 512;
int bs = BS;

main(argc,argv) char **argv;
{
	register int l;
	char *infile, *outfile;
	int in, out;

	setout();
	if (argc < 3)
		err("usage: %s /dev/raw-input /dev/raw-output [bs] [count] [offset]",argv[0]);
	infile = argv[1];
	if ((in = open(infile,0)) < 0)
		err("can't open %s",infile);
	outfile = argv[2];
	if ((out = open(outfile,1)) < 0)
		err("can't open %s",outfile);
	if (argc > 3)
		{
		blocksize = (bs = atoi(argv[3])) * 512;
		if (blocksize <= 0)
			err("invalid block size %d",bs);
		}
	buff = sbrk(blocksize);
	if ((int) buff == -1)
		err("can't allocate buffer %d bytes",blocksize);
	if (argc > 4)
		count = atoi(argv[4]);
	if (argc > 5)
		{
		offset = atoi(argv[5]);
		seek(out,offset,3);	/* offset by that many bytes */
		}
	sync();
	printf("Warning: you MUST be in single user mode!!!\n");
	printf("copy from %s to %s bs=%db",infile,outfile,bs);
	if (count)
		printf(" count=%u",count);
	if (offset)
		printf(" offset=%u",offset);
	printf("\n");
	prompt("Install disks to copy");
	while ((l = read(in,buff,blocksize)) > 0)
		{
		if (write(out,buff,l) < 0)
			done("write error");
		if (count && --count == 0)
			break;
		}
	if (l < 0)
		done("read error");
	done("copy complete");
}

prompt(msg) char *msg;
{
	register int l;

	printf("%s - hit return when disks changed\n",msg);
	flush();
	if ((l = read(0,buff,sizeof buff)) <= 0)
		exit(1);
}

done(msg) char *msg;
{
	prompt(msg);
	exit(0);
}
