#include <stdio.h>
#include <ctype.h>
#include <stat.h>
#include <sgtty.h>

/*
 * history, or !
 * program to manipulate the conversational buffer file
 * produced by the UBC modified TTY driver 
 * it does similar things to the CSH history, but works for
 * any input records.
 * logging must have been turned on, (by LOGIN preferrably)
 * producing a current log in the
 * file /usr/log/tty?.log
 */

#define	TRACEF(x) if (tflg) printf x
#define	TTRACEF(x) if (tflg>1) printf x
#define	MAXLINES	1000
#define	NL	'\n'
int lines[MAXLINES];
long posn;
int delay = 2;
int vflg;
int tflg;
int nflg;
int lcase;
long now;
struct stat statb;

FILE *f;
int maxline;
char logfile[64];
char buff[BUFSIZ];
char temp[BUFSIZ];
int vec[3];

main(argc,argv) char **argv;
{
register char *argp;
register int j;
int x;
struct { char lo, hi; };
int i;
int n;

setout();
n = ttyn(0);
if (n == 'x')
	n = ttyn(2);
if (n == 'x')
	err("can't find tty number");
if (gtty(0,vec) < 0 && gtty(2,vec) < 0)
	err("stdin/stderr not terminal");
lcase = vec[2] & LCASE;
if (argc > 1 && strncmp("-T",(argp = argv[1]),2) == 0)
	{
	x = getgid();
	if (x.lo == x.hi)
		n = argp[2];
	--argc;
	++argv;
	}
time(&now);
sprintf(logfile,"/usr/log/tty%c.log",n);
if ((f = fopen(logfile,"r")) == NULL)
	err("can't open %s",logfile);
fstat(fileno(f),&statb);
if (now > statb.s_mtime)
	printf("Warning: log file %s is old\n",logfile);
initfile(f);
TRACEF(("%s: %d lines\n",logfile,maxline));
if (argc <= 1)
	{
	prhist(20);
	exit(0);
	}
for (j=1; j<argc; ++j)
	{
	argp = argv[j];
	if (equal(argp,"hist"))
		{
		if (++j < argc)
			sscanf(argv[j],"%d",&i);
		else
			i = 20;
		prhist(i);
		}
	else if (equal(argp,"!"))
		doline(maxline-2);
	else if (equal(argp,"-n"))
		++nflg;
	else if (equal(argp,"-v") || equal(argp,"-ed"))
		++vflg;
	else if (strncmp(argp,"-d",2) == 0)
		delay = atoi(argp+2);
	else if (equal(argp,"-t"))
		++tflg;
	else if (*argp == '-')
		{
		if (sscanf(argp+1,"%d",&i) != 1)
			err("bad number %s",argp+1);
		i = maxline - i - 1;
		doline(i);
		}
	else if (isdigit(*argp))
		{
		if (sscanf(argp,"%d",&i) != 1)
			err("bad number %s",argp);
		i--;
		doline(i);
		}
	else
		scan(argp,-1,-1);
	}
}

initfile(f) FILE *f;
{
register int i;

posn = 0;
for (i=0; i<MAXLINES; ++i)
	{
	lines[i] = posn;
	if (readline(f,buff) < 0)
		{
		maxline = i;
		return;
		}
	}
err("more than %d lines",MAXLINES);
}

readline(f,buff) FILE *f; char *buff;
{
register int c;
register char *p = buff;

while ((c = getc(f)) != EOF)
	{
	++posn;
	if (c == NL)
		{
		*p = 0;
		return(p-buff);
		}
	*p++ = c;
	}
return(-1);		/* no more lines */
}

send(fildes,fmt,d1,d2,d3,d4) char *fmt;
{
char temp[BUFSIZ];
register char *p;
static int arg[3];

do_delay();
sprintf(temp,fmt,d1,d2,d3,d4);
TRACEF(("sending ... %s\n",temp));
	
flush();
if (equal(temp,"\n"))
	return;		/* don't bother with trivial commands */
for (p=temp; *p; ++p)
	{
	if (lcase && isupper(*p))
		{
		arg[0] = '\\';
		TTRACEF(("'%c'",arg[0]));
		if (ioctl(fildes,TIOCLPUT,arg) < 0)
			err("can't put");
		}
	arg[0] = *p;
	TTRACEF(("'%c'",arg[0]));
	if (ioctl(fildes,TIOCLPUT,arg) < 0)
		err("can't put");
	}
}

prhist(nlines)
{
register int i;

TRACEF(("%s: %d lines\n",logfile,maxline));
i=maxline-nlines;
if (i < 0)
	i = 0;
fseek(f,(long) lines[i],0);
for  (;readline(f,buff) >= 0; )
	printf("%5d %s\n",++i,buff);
}

doline(i)
{
	TRACEF(("dline(%d)\n",i));
	if (i < 0 || i > maxline)
		err("no line %d",i+1);		/* no such line */
	fseek(f,(long) lines[i],0);
	readline(f,buff);
	if (vflg)
		vi(buff);
	if (equal(buff,"^D"))
		send(0,"%s","\04");
	else
		send(0,"%s%s",buff,nflg ? "" : "\n");
}

scan(pat,delim,dir) register char *pat;
{
/*
 * do both scans by reading forwards for efficiency
 */
register int line, i, lpat;

lpat = strlen(pat);
if (pat[lpat] == delim)
	--lpat;
TRACEF(("scan for %.*s dir=%d\n",lpat,pat,dir));
rew();
temp[0] = 0;
for (i=0; i < maxline; ++i)
	{
	if (readline(f,buff) < 0)
		break;
	TRACEF(("scan line %d '%s'\n",i,buff));
	if (strlen(buff) >= lpat && strncmp(buff,pat,lpat) == 0)
		{
		copy(temp,buff);
		if (dir >= 0)
			break;		/* forward scan */
		}
	}
if (temp[0] == 0)
	err("pattern %s not found",pat);
if (vflg)
	vi(temp);
send(0,"%s%s",temp,nflg ? "" : "\n");
}

rew()
{
fseek(f,0L,0);
posn = 0;
}

vi(str) register char *str;
{
register char file[32];
register int l;
register FILE *f;

sprintf(file,"/tmp/!%d",getpid());
if ((f = fopen(file,"w")) == NULL)
	err("can't open %s",file);
fprintf(f,"%s\n",str);
fclose(f);
runvi(file);
if ((f = fopen(file,"r")) == NULL)
	err("can't open %s",file);
fgets(str,BUFSIZ,f);
l = strlen(str);
if (l > 0)
	str[--l] = 0;	/* replace the nl by null */
nflg = 0;		/* user had a chance to inspect it */
unlink(file);
}

runvi(cmd) char *cmd;
{
register int i, pid;
int status;
int s2;

s2 = signal(2,1);
if ((pid = fork()) == 0)
	{
	closeall();
	execl("/bin/ex","vi","-",cmd,0);
	write(2,"no /bin/ex\n",11);
	exit(1);
	}
while ((i=wait(&status)) != pid && i != -1)
	;
signal(2,s2);
return(status);
}

do_delay()
{
/*
 * delay for a short period so that the shell has a change to 
 * prompt for the input string.
 * this makes the screen look nicer.
 */
TRACEF(("delay = %d\n",delay));
if (delay)
	{
	if (fork() != 0)
		{
		TRACEF(("parent - exit\n"));
		exit(0);	/* get parent shell going */
		}
	else
		{
		TRACEF(("child - delay\n"));
		sleep(delay);	/* while we wait */
		}
	}
}
