.globl rerr
.globl subr_
.comm seq_,2
/	subroutine/function entry/call
/
/	entry sequence for fortran programs is:
/	push arg addresses
/	push arg cnt
/	mov	sp,r5		no longer actaully needed
/	jsr	pc,subroutine
/	pop args off stack
/
/ subroutine:
/	jsr	r4,subr_
/	<name>		(8 characters long)
/	arg cnt
/	arg list ptr
/	...
/
subr_:
	jsr	r5,entry	/do the Fortran entry sequence
	mov	(r4)+,r2	/point to parameter addresses
/ all set to copy the parameter list
/ r2 points to the destination, r0 to the parameter list
/ r3 contains the number of parameters addresses to move.
	tst	r3		/any parameters
	beq	3f		/all done
2:
	mov	(r0)+,(r2)+	/store parameter pointers
	sob	r3,2b
3:
	jmp	*(r4)+		/continue execution
.globl sret_,sreti_,ret_
/
/	return to calling program
/ stack:
/	caller's pc
/	r4
/	r5
/	r3
/	r2
/	assume that any results have already been loaded into
/	appropriate registers.
/
sret_:
	clr	-(sp)		/return code
sreti_:
	mov	(sp)+,r0	/return code
ret_:
	cmp	(sp)+,(sp)+	/pop seq and name
	mov	(sp)+,seq_	/restore pointer
	mov	(sp)+,r2	/restore r2
	mov	(sp)+,r3	/and r3
	mov	(sp)+,r5	/and r5
	mov	(sp)+,r4	/restore r4
	setd			/normal c mode
	rts	pc		/return to caller
.comm seq_,2
.globl entry_
.globl rerr
/
/ on entry stack looks like:
/	arg n
/	...
/	arg 1
/	arg cnt
/	return address	(in call_ if Fortran)
/	saved r4	(by jsr r4,entry_)
/	saved r5	(by push of r5 at entry_)
/ on exit to the threaded code the stack also has
/	saved r3
/	saved r2
/	saved seq_
/	name pointer (r4's value on entry)
/	current isn (set to zero to start)
/
/ "seq_" now points to the current isn on the stack.
/ which is also the current stack base for this routine.
/ the fortran calls are linked backwards thru "seq_" to the main program.
/
entry:				/ r5 contains return address for "entry"
/
/
	mov	sp,r0		/build pointer to arg list in r0
	add	$6,r0		/r5, r4, pc skipped r0 points to parameters
/
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	seq_,-(sp)	/save previous routine
	mov	r4,-(sp)	/point to name
	add	$8,r4		/past name
	clr	-(sp)		/current seq
	mov	sp,seq_		/point to it
	mov	(r4)+,r3	/get expected count
	cmp	r3,(r0)+	/test if arg cnt ok
	beq	2f		/the same
	jsr	r5,rerr;202.	/bad arg cnt
2:
	jmp	(r5)		/return to caller
/
/ entry to subroutine via an "entry" statment:
/
/	entry point processing
/
/ subroutine entry point:
/	jsr	r4,entry_
/	<name>		(8 characters long)
/	arg cnt
/	arg 1 ptr
/	arg 2 ptr
/	...
/	arg n ptr
/
entry_:
	jsr	r5,entry
/ all of the entry processing except parameter passing has now been done
/ r0 points to the first parameter address
	tst	r3		/any parameters?
	beq	3f		/all done
2:
	mov	(r0)+,*(r4)+	/store parameter pointers
	sob	r3,2b
3:
	jmp	*(r4)+		/continue execution
