#

#include <stdio.h>

int debug;

#ifdef DEBUG
#define FTRACEF(x) if(debug) fprintf x
#define FTTRACEF(x) if(debug>1) fprintf x
#else
#define FTRACEF(x)
#define FTTRACEF(x)
#endif

/*
 * printer plot routines for printronix 300 line printer/plotter.
 * input is in UBC UNIX plot format, as provided by the plotting
 * routines. Output is in plot mode for the Printronix 300 line
 * printer.
 *
 * if EPSON is defined then output for an EPSON MX100 is generated.
 *
 */
/*			Copyright 1977 by Bill Webb.	 		*/

/*
 * Note:
 * if your printer driver has code to optimize printer-plotting thruput
 * by allowing repeated sequences of characters to be replaced by a character
 * and a count (e.g. x x x x ==> x -3 )
 * then you may 
 * #define OPT 1
 * otherwise delete the define.
 */


#define	LOWER	-1
#define	INSIDE	0
#define	HIGHER	1

#define	MAXINT	32767

#define	puts(string) fputs(string,stdout)

#ifdef	REVERSED
#define dobit(x,y) if(!(x>=xbmax||y<ybmin||y>=ybmax)) setbit(x,y);
#define setbit(x,y) { bitptrs[y-ybmin][x/BYTESIZE]=|ones[x%BYTESIZE]; }

#else

#define dobit(x,y) if(!(x>=xbmax||y<ybmin||y>=ybmax)) setbit(x,y);
#define setbit(x,y) { bitptrs[ybmax-y-1][x/BYTESIZE]=|ones[x%BYTESIZE]; }
#endif

#define	FLAG	040000
#define	draw	2
#define	move	3
#define	STARTPAGE	"\14"	/* to start page */
#define	ENDRUN		""	/* to end run */
#define	EJECT	"\14"	/* to eject paper */
#define	YMAX	144

#ifdef EPSON
/*
 * overall parameters for EPSON printer
 */

#define	BINLPR	"/usr/bin/eplpr"
#define	LPR	"eplpr"
#define	YSCALE 
#define dobit(x,y) if(!(x>=xbmax||y<ybmin||y>=ybmax)) setbit(x,y);
#define setbit(x,y) { bitptrs[(ybmax-y-1)/BYTESIZE][x]=|ones[(ybmax-y-1)%BYTESIZE]; }
#define	BYTESIZE	8

#ifdef HEPSON
#define	IXSCALE	* 6 / 5
#define	IYSCALE	* 18 / 25
#define	XSCALE	* 12 / 5
#define	XMAX	1632
#define	STARTLINE "\033L"	/* ESC L x y */
#else
#define	IXSCALE	* 3 / 5
#define	IYSCALE	* 18 / 25
#define	XSCALE	* 6 / 5
#define	XMAX	816
#define	STARTLINE "\033K"	/* ESC K x y */
#endif

#define	ENDLINE	"\r\n"		/* end of line indicator */
#define	SENDBYTE(x)	putchar(x)
#define	SENDCNT(x)	sendcnt(x)
#define	YLINES	8	/* number of y lines per LF */
#define	YDIM	YMAX/8	/* dimension of Y array */
char ones[] { 0200, 0100, 040, 020, 010, 04, 02, 01 };
#define	STARTPAGE	"\n\r\033A\010\r\n"	/* to set LF amount */
#define	ENDRUN		""	/* to end run */
#define	EJECT	"\14\033\62"	/* to eject paper  & set LF amount */

#else		/* for Printronix P300 */

#define	BINLPR	"/bin/lpr"
#define	LPR	"lpr"
#define	IXSCALE	* 6/10
#define	IYSCALE	* 18/25
#define	YSCALE		
#define	XSCALE	* 5 / 6
#define	BYTESIZE	6
#define	XMAX	132
#define	STARTLINE	"\05"	/* start of plot info */
#define	ENDLINE	"\n"		/* end of plot info */
#define	SENDBYTE(x)	putchar(x|0100)
#define	SENDCNT(x)		/* no-op for printronix */
#define	YLINES	1	/* number of y lines per LF */
#define	YDIM	YMAX	/* dimension of Y array */
char ones[] { 01, 02, 04, 010, 020, 040 , 0100, 0200 };

#endif

#define	MASK	((1<<BYTESIZE)-1)
#define	MIN(x,y)	(((x) < (y)) ? (x) : (y))
#define	MAX(x,y)	(((x) > (y)) ? (x) : (y))
char bits[YDIM][XMAX];
char *bitptrs[YDIM];
char plotfile[20] "/tmp/ppxxxx";
int xoff;
int xopt;		/* maximum x for this band */
FILE *outbuff, *inbuff;
int debug 0;
int flag;
int xmax, ymax;
int xmin, ymin;
int xbmin, xbmax, ybmin, ybmax;
int rmflg;		/* remove file after use */
int sflg 1;		/* scale input */
int iflg;		/* inches */
int bflg;		/* buffer output thru pipe */
int nflg;		/* don't output plot info */

main(argc,argv) char **argv;
{
register int c;
register int x,y;
char *argp;
int cnt = 0;

--argc;
++argv;
setout();
while (argc > 0)
	{
	argp = *argv++;
	--argc;
	if (*argp == '-')
		{
		switch(*++argp)
			{
		case 'n':
			++nflg;
			break;
		case 's':
			sflg = !sflg;
			break;
		case 'i':	/* inches */
			++iflg;
			break;
		case 'b':
			++bflg;
			break;
#ifndef EPSON
		case 'w':
			close(fileno(stdout));
			fileno(stdout) = pipeout(BINLPR,LPR,"-w",0);  /* */
			break;
#endif
		case 'o':
			if (freopen(*argv++,"w",stdout) == NULL)
				err("can't open %s for output",argv[-1]);
			setout();
			--argc;
			break;
		case 'r':
			++rmflg;
			break;
		case 'd':
			++debug;
			}
		}
	else
		{
		if (freopen(argp,"r",stdin) < 0)
			err("can't open %s",argp);
		++cnt;		/* count number of plots done */
		doplot();
		if (rmflg)
			unlink(argp);
		}
	}
if (cnt == 0)
	doplot();
done(0);
}

done(n)
{
fputs(ENDRUN,stdout);
exit(n);
}

doplot()
{
register int c;
register int x,y;
int cnt;

init();
while ((c = getchar()) >= 0)
	{
	switch(c)
		{
	case 030:	/* erase screen */
		FTRACEF((stderr,"erase\n"));
		scan();
		while ((c = getchar()) != 0377 && c >= 0)
			;
		break;
	case 033:		/* change color -- ignore it */
		c = getchar();
		break;
	default:
		err("out of sync");
		break;
	case 035:	/* draw x1 y1, move x2 y2 ... */
		flag = 0;
		cnt = 0;
#ifndef	REVERSED
		while ((x = coord()) >= 0 && (y = coord()) >= 0)
#endif
#ifdef	REVERSED
		while ((y = coord()) >= 0 && (x = coord()) >= 0)
#endif
			{
			if (iflg)
				{
				x = x  IXSCALE;
				y = y  IYSCALE;
				}
			else if (sflg)
				{
				x = x  XSCALE;
				y = y  YSCALE;
				}
			if (x > xmax)
				xmax = x;
			if (x < xmin)
				xmin = x;
			if (y > ymax)
				ymax = y;
			if (y < ymin)
				ymin = y;
			FTRACEF((stderr,"(%d,%d) ",x,y));
			if (flag++ == 0)
				x =| FLAG;
			putw(x,outbuff);
			putw(y,outbuff);
			}
		FTRACEF((stderr,"\n"));
		break;
	case 0377:
		break;
		}
	}
scan();
}

coord()
{
register int c;
register int c2;

c = getchar();
if (c < 0 || c == 0377)
	return(-1);
c2 = getchar();
if (c2 < 0 || c2 == 0377)
	return(-1);
return(((c & 077) << 6) + (c2 & 077));
}

int xpos, ypos;		/* where it is */

scan()
{
if (xmin != MAXINT)
	{
	genplot();
	init();
	}
}

int s1, s2;
int bdychk;		/* must check boundaries */
genplot()
{
register int x, y;
register int flg;

if (outbuff != (FILE *) NULL)
	{
	fclose(outbuff);
	outbuff = NULL;
	}
if (bflg)
	{
	bflg = 0;
	flush();
	close(fileno(stdout));
	fileno(stdout) = pipeout(BINLPR,LPR,0);
	}
else
	initlpr();
puts(STARTPAGE);
/*
 * space down from top of page to center it 
 */
if (!nflg)
	for (y=(720-ymax)/2; (y -= YLINES) >= 0; )
		{
		puts(STARTLINE);
		SENDCNT(1);
		SENDBYTE(0);
		puts(ENDLINE);
		}
xbmin = 0;
#ifdef EPSON
	xbmax = XMAX;
#else
	xbmax = XMAX*BYTESIZE;
#endif
xoff = 0;
if (xmax > xbmax)
	{
	if (xmax-xmin < xbmax)
		xoff = (xbmax+xmin-xmax)/2;
	else
		xoff = xmin;
	}
#ifndef	REVERSED
for (ybmax=ymax+1; ybmax >= 0; ybmax=ybmin)
	{
	ybmin = ybmax-YMAX;
#endif
#ifdef	REVERSED
for (ybmin=0; ybmin<=ymax; ybmin=ybmax)
	{
	ybmax = ybmin+YMAX;
#endif
	FTRACEF((stderr,"\n"));
	clear(bits,sizeof bits);
	fseek(inbuff,0l,0);
	xopt = 0;		/* place to start scanning */
	while ((x = getw(inbuff)) >= 0)
		{
		y = getw(inbuff);
		flg = x & FLAG;
		x =- flg;
		FTTRACEF((stderr,"%s(%d,%d) ",flg ? "\n" : "",x,y));
		x =- xoff;
		xopt = MAX(x,xopt);
		s2 = (y >= ybmax) ? HIGHER : ((y < ybmin) ? LOWER : INSIDE);
		if (!flg)
			{
			if (s1 == INSIDE || s2 == INSIDE || s1 != s2)
				{
				bdychk = s1 != INSIDE || s2 != INSIDE ||
					x >= xbmax || xpos >= xbmax;
				xymov(x-xpos,y-ypos);
				}
			}
		xpos = x; ypos = y;
		s1 = s2;
		}
	dump();
	}
puts(ENDLINE);
puts(EJECT);
flush();
}

initlpr()
{
#ifdef EPSON
#include <sgtty.h>

	struct sgttyb sgtty;

	if (gtty(fileno(stdout),&sgtty) >= 0)
		{
		sgtty.sg_flags = RAW;
		stty(fileno(stdout),&sgtty);
		FTRACEF((stderr,"setting terminal to raw mode\n"));
		}
	else
		FTRACEF((stderr,"output to not to terminal\n"));
#endif
}


xymov(x,y)
{
#define	minusx	0377
#define	plusx	1
#define	minusy	-1 << 8
#define	plusy	1 << 8
/*
 * draw by (x,y) increments.
 */
int absx, absy, i;
int maj, min;
register int nomaj, nomin, start;

if ((absx = x) < 0)
	absx = -absx;
if ((absy = y) < 0)
	absy = -absy;
if (absx > absy)
	{
	maj = (x < 0) ? minusx : plusx;
	min = (y < 0) ? minusy : plusy;
	nomaj = absx;
	nomin = absy;
	}
else
	{
	min = (x < 0) ? minusx : plusx;
	maj = (y < 0) ? minusy : plusy;
	nomaj = absy;
	nomin = absx;
	}
min =| maj;
start = nomaj>>1;
if (bdychk)
	xysteps(nomaj,nomin,start,maj,min);
else
	xyfast(nomaj,nomin,start,maj,min);
}

xysteps(nomaj,nomin,start,maj,min)
{
register int x, y;
int i;
struct { char x, y; };

x = xpos; y = ypos;
dobit(x,y);
for (i=0; i<nomaj; ++i)
	{
	start =+ nomin;
	if (start < nomaj)
		{
		x =+ maj.x;
		y =+ maj.y;
		}
	else
		{
		x =+ min.x;
		y =+ min.y;
		start =- nomaj;
		}
	dobit(x,y);
	}
xpos = x; ypos = y;
}

xyfast(nomaj,nomin,start,maj,min)
{
register int x, y;
int i;
struct { char x, y; };

x = xpos; y = ypos;
setbit(x,y);
for (i=0; i<nomaj; ++i)
	{
	start =+ nomin;
	if (start < nomaj)
		{
		x =+ maj.x;
		y =+ maj.y;
		}
	else
		{
		x =+ min.x;
		y =+ min.y;
		start =- nomaj;
		}
	setbit(x,y);
	}
xpos = x; ypos = y;
}


dump()
{
register int i;
if(nflg)
	return;
for (i=0; i<YDIM; ++i)
	putrow(bits[i]);
flush();
}

putrow(ptr) char *ptr;
{
register char *p;
register char *s;
register int x;
int cnt = 0;
int lastch = 0;

#ifdef EPSON
	x = xopt;
#else
	x = (xopt+BYTESIZE-1)/BYTESIZE;
#endif
puts(STARTLINE);
for (p=ptr+MIN(XMAX,x); --p >= ptr; )
	{
	if (*p & MASK)
		{
		SENDCNT(p-ptr+1);
		for (s=ptr; s <=p; )
			{
#ifdef OPT
			x = *s++ | 0100;
			if (x == lastch && cnt != -128)
				--cnt;
			else
				{
				if (cnt)
					{
					putchar(cnt);
					cnt = 0;
					}
				putchar(x);
				lastch = x;
				}
#else
			SENDBYTE(*s++);
#endif
			}
		break;
		}
	}
#ifdef EPSON
if (p < ptr)
	{		/* didn't send anything ... make it NULL */
	SENDCNT(1);
	SENDBYTE(0);
	}
#endif

#ifdef OPT
if (cnt)
	putchar(cnt);
#endif

puts(ENDLINE);
}

init()
{
register int i;

for (i=0; i<YDIM; ++i)
	bitptrs[i] = bits[i];
if (outbuff)
	fclose(outbuff);
if (inbuff)
	fclose(inbuff);
sprintf(plotfile,"/tmp/pp%d",getpid());
if ((outbuff = fopen(plotfile,"w")) == NULL)
	err("creating %s",plotfile);
if ((inbuff = fopen(plotfile,"r")) == NULL)
	err("opening %s",plotfile);
if (!debug)
	unlink(plotfile);
xmax = ymax = 0;
xmin = ymin = MAXINT;
}

side(x,y)
{
if (y >= ybmax)
	return(HIGHER);
if (y < ybmin)
	return(LOWER);
return(INSIDE);
}

#ifdef EPSON
sendcnt(x)
{
FTRACEF((stderr,"cnt = %d\n",x));
	
putchar(x&0377);	/* low order */
putchar(x>>8);		/* high order */
}
#endif
