#
#include "/usr/include/stty.h"

char buff[512];

struct stty oldv;
struct stty newv;
int pipe();
int attn();
int timer();
int hangup();
int quit();
int tty;
char *hangmsg "\nWarning ... AES Dropped the line ... Data probably incomplete\n";
int cnt;

main(argc,argv) char **argv;
{
register int l;

tty = open("/dev/tty",1);
if (tty < 0)
	tty = 2;
setsigs();
gtty(0,&oldv);
move(sizeof oldv,&oldv,&newv);
newv.s_mode =& ~ECHO;		/* no echo */
newv.s_mode =| HUPCL;		/* rare mode */
stty(0,&newv);
while ((l = read(0,buff,sizeof buff)) > 0)
	{
	alarm(30);
	write(tty,"*",1);
	if (++cnt >= 72)
		{
		cnt = 0;
		write(tty,"\n",1);
		}
	*(buff+l) = 0;
	if (equal(buff,"END\n"))
		break;
	write(1,buff,l);
	}
write(tty,"\n",1);
if (l <= 0)
	errmsg(l == 0 ? "EOF" : "ERROR");
stty(0,&oldv);
}

setsigs()
{
signal(1,&hangup);
signal(2,&attn);
signal(3,&quit);
signal(13,&pipe);
signal(14,&timer);
}

pipe()
{
errmsg("Pipe broke");
}

attn()
{
errmsg("attn");
}

hangup()
{
write(1,hangmsg,length(hangmsg));
errmsg("hangup");
}

quit()
{
errmsg("quit");
}

timer()
{
errmsg("30 second timer tripped ... input assumed complete");
}

errmsg(msg) char *msg;
{
write(tty,"\n",1);
write(tty,msg,length(msg));
write(tty,"\n",1);
stty(0,&oldv);
exit(0);
}
