#include "tp.h"
char	tc[]	"/dev/tapx";
char	mt[]	"/dev/mt0";
char	fl[]	"/dev/rx0";	/* floppy disk */
int	   flags	020;	/* default is flu */

main(argc,argv)
char **argv;
{
	register char c,*ptr;
	extern cmd(), cmr(),cmx(), cmt();

	command = &cmr;
	if ((narg = rnarg = argc) < 2)	narg = 2;
	else {
		ptr = argv[1];	/* get first argument */
		parg = &argv[2];	/* pointer to second argument */
		while (c = *ptr++) switch(c)  {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				tc[8] = c;
				mt[7] = c;
				fl[7] = c;
				continue;
			case 'a':
				flags =| fla; continue;
			case 'c':
				flags =| flc;  continue;
			case 'd':
				setcom(&cmd);  continue;
			case 'f':
				flags =| flf;  continue;
			case 'i':
				flags =| fli;  continue;
			case 'm':
				flags =| flm;  continue;
			case 'r':
				flags =& ~flu;  setcom(&cmr);  continue;
			case 't':
				setcom(&cmt);  continue;
			case 'u':
				if (argc <= 2)
					{
					printf("%s - no files specified\n",argv[0]);
					exit(1);
					}
				flags =| flu;  setcom(&cmr);  continue;
			case 'v':
				flags =| flv;  continue;
			case 'w':
				flags =| flw;  continue;
			case 'x':
				if (command != &cmx)
					setcom(&cmx);
				else
					++xxflg;
				continue;
			case 'y':	/* floppy disk */
				flags =| fly; continue;
			case 's':	/* strip leading slashes */
				++sflg; continue;
			default:
				useerr();
		}
	}
/**/
	optap();
	nameblk = nptr = sbrk(0);		/* establish top */
	top = nptr;
	(*command)();
}

optap()
{
	extern cmr();

	if (flags & fly)
		{			/* floppy disk */
		if (flags & flm)
			useerr();
		tapsiz = (fl[7] & 2) == 0 ? 500 : 1001;
		ndirent = 192;
		fio = open(fl,2);
		}
	else if ((flags & flm) == 0) {	/*  DECTAPE */
		tapsiz = 578;
		ndirent = 192;
		fio =open(tc,2);
	} else {			/* MAGTAPE */
		tapsiz = 32767;
		ndirent = MDIRENT;
		if (command == &cmr)
			fio = open(mt,1);
		else
			fio = open(mt,0);
	}
	if (fio < 0)  {
		printf("Tape open error\n");
		++errcnt;
		done();
	}
	ndentd8 = ndirent>>3;
	edir = &dir[ndirent];
}

setcom(newcom)
{
	extern cmr();

	if (command != &cmr)  	useerr();
	command = newcom;
}

useerr()
{
	printf("Bad usage\n");
	errcnt++;
	done();
}

/*/* COMMANDS */

cmd()
{
	extern delete();

	if (flags & (flm|flc|flf))	useerr();
	if (narg <= 2)			useerr();
	rddir();
	gettape(&delete);
	wrdir();
	check();
}

cmr()
{
	if (flags & (flc|flm))		clrdir();
	else				rddir();
	getfiles();
	update();
	check();
}

cmt()
{
	extern taboc();

	if (flags & (flc|flf|flw))	useerr();
	rddir();
	if (flags & flv)
		printf("   mode    uid gid tapa    size   date    time name\n");
	gettape(&taboc);
	check();
}

cmx()
{
	extern extract();

	if (flags & (flc|flf))		useerr();
	rddir();
	gettape(&extract);
	done();
}

check()
{
	usage();
	done();
}

done()
{
	if (errcnt && (flags & flv))
		printf("%4d error%s\n",errcnt,errcnt==1 ? "" : "s");
	printf("End\n");
	exit(errcnt);
}

encode(pname,dptr)	/* pname points to the pathname
			 * nptr points to next location in nameblk
			 * dptr points to the dir entry		   */
{
	register  char *np, *sp;

	sp = pname;
	dptr->d_namep = np = nptr;
	if (np > top - 32)  {
			top = top + NAMEINCR;	/* get more */
			if (top > MAXMEM || brk(top) == -1)
				{
				printf("Out of core\n");
				++errcnt;
				done();
				}
	}
	while (*np++ = *sp++);
	if (np <= nptr + 32)  nptr = np;
	else {
		printf("Pathname too long - %s\nFile ignored\n",nptr);
		++errcnt;
		clrent(dptr);
	}
}

decode(pname,dptr)	/* dptr points to the dir entry
			 * name is placed in pname[] */
{

	register char *p1, *p2;

	p1 = pname;
	p2 = dptr->d_namep;
	while (*p1++ = *p2++);
}
