#include "netcs.h"

screen()
{
register int c;
register char *outp = buff;	/* for match buffer */
register char *p;
char *inptr;
int l;

signal(SIGINT,SIG_IGN);		/* ignore attn's */
for (;;)
	{
	if (cflg)
		flush();	/* flush after every record */
	if ((l = read(fileno(in_line),inbuff,(sizeof inbuff)-1)) < 0)
		{
		if (intrflg)
			{
			intrflg = 0;
			continue;    /* we were interrupted, so ignore error */
			}
		return;
		}
	inbuff[l] = 0;
	for (inptr=inbuff; --l >= 0; )
		{
		c = *inptr++ & 0177;
		if (c == 0)
			continue;
		if (pflg && iscntrl(c) && !printable[c])
			c = '?';
		if (c == '\r' && *inptr == '\n')
			{ c = *inptr++; --l; }
		putc(c,out_file);
		if (log)
			putchar(c);
		flush();
		*outp = c;
		if (outp < buff+MAXLINE-1)
			++outp;
		if (c == '\n')
			{
			flush();
			*--outp = 0;
			testmatch(buff);
			outp = buff;
			}
		else if (iscntrl(c))
			--outp;	 /* ignore CR etc */
		}
	if (cflg && outp > buff && mcnt)
		{	/* in RARE mode test here for prompts as well */
		*outp = 0;
		c = outp[-1];
		if (isspace(c) || ispunct(c))
			testmatch(buff);
		}
	}
}
scr_cmd(cmd_buff) register char *cmd_buff;
{
while (isspace(*cmd_buff))
	++cmd_buff;
switch(*cmd_buff++)
	{
case 'p':		/* print out current prompt again */
	printf("%s",buff);
	flush();
	break;
case 'q':
	signal(SIGIOT,SIG_IGN);		/* ignore any other cmds */
	send_cmd(main_pid,scr_out,"%cq\n",cmd);
	done(0);		/* exit to higher level */
	break;
case '>':
	outdivert(cmd_buff);
	break;
default:
	send_cmd(main_pid,scr_out,"%c%s\n",cmd,cmd_buff-1);
	}
return(1);
}

outdivert(buff) register char *buff;
{
register FILE *f;
register char *how = "w";

log = NO;
if (out_file != stdout)
	{
	fclose(out_file);
	out_file = stdout;
	}
if (*buff == '>')
	{ ++buff; how = "a"; }

if (*buff == 0)
	return;

if (*buff == ':')
	++buff;
else
	log = YES;

if ((f = fopen(buff,how)) == NULL)
	warn(YES,"can't open '%s' for output",buff);
else
	out_file = f;
}
