#include "asm.h"
/*		Copyright 1976 by Bill Webb. 		*/

int hashnext;

ignsp()
{
register char c;

while ((c = *ptr) == ' ' || c == TAB)
	++ptr;
return(c);
}

getop()
{
register char *p;

ignsp();
p = ptr+3;
getsym(opname);
if(ptr > p)
	ptr = p;
opname[3] = 0;

if(op = oplook())
	{
	opcode = op->o_code;
	return(op);
	}
if(label[0])
	dolabel();
error("invalid op code (%s)",opname);
}

initops()
{
register struct opcode *o;
register int i, cnt;

cnt = 0;
for (ALLOPS)
	{
	i = hash(o->o_name) % MAXOPHASH;
	while (ophash[i])
		{
		if (++i >= MAXOPHASH)
			i = 0;
		++hashnext;
		}
	ophash[i] = o;
	if(++cnt > MAXOPHASH)
		{
		printf("hash table too small\n");
		exit(1);
		}
	}
}

oplook()
{
register struct opcode *o;
register int i;

i = hash(opname) % MAXOPHASH;
while (o = ophash[i])
	{
	if(symeq(opname,o->o_name))
		return(o);
	if (++i >= MAXOPHASH)
		i = 0;
	}
return(0);
}

hash(name) char *name;
{
register int i,j,c;

j = 0;
for (i=0; i<SYMLEN; ++i)
	{
	if(c = *name++)
		j = j*j + c;
	else
		break;
	}
if(j<0)
	j = -j;
return(j);
}

expr()
{
register int c;
register int n1;
register int n2;

exprtype = 0;		/* no undefined found yet */
ignsp();
c = *ptr;
n1 = value();
while ((c = *ptr++) == '+' || c == '-' || c=='*' || c=='/')
	{
	n2 = value();
	switch(c)
		{
	case '+':
		n1 =+ n2;
		break;
	case '-':
		n1 =- n2;
		break;
	case '*':
		n1 =* n2;
		break;
	case '/':
		n1 =/ n2;
		break;
		}
	}
--ptr;
if(!delim())
	error("expression syntax");
return(n1);
}

value()
{
register int c;
register struct symbol *s;

c = *ptr;
if(c == ',')
	return(0);
if(ALPHA)
	{
	getsym(sym);
	s = lookup(sym);
	if(s->s_type == UNDEF)
		if(passnum == 1)
			++exprtype;		/* undef var in expr */
		else
			warn("%s undefined",s->s_name);
	return(s->s_value);
	}
if(DIGIT)
	return(integer(base));
++ptr;
switch(c)
	{
case '$':
	return(integer(16));
case '*':
	return(dot);
case '@':
	return(integer(8));
case '%':
	return(integer(2));
case '\'':
	if(c = *ptr)
		{
		++ptr;
		if(uflg && c >= 'a' && c <= 'z')
			c =- 'a' - 'A';
		return(c);
		}
	else
		break;
	}
error("argument syntax");
}


integer(b)
{
register int c;
register int n;

n = 0;
while ((c = *ptr++) && ALPHANUM)
	{
	if(DIGIT)
		c =- '0';
	else
		c =- 'a' - 10;
	if(c > b)
		error("invalid number");
	n = n * b + c ;
	}
--ptr;
return(n);
}


readline()
{
register char *p;
register int c;

if(gotend)
	return(0);
++linecnt;
p = line;
while (c = getchar())
	{
	if(c == '\n')
		{
		*p++ = 0;
		return(1);
		}
	*p++ = c;
	if(p >= line+MAXLINE)
		{
		while ((c=getchar()) && c!='\n')
			;
		error("line too long");
		}
	}
return(0);
}

delim()
{
switch(*ptr)
	{
case ' ':
case TAB:
case 0:
case ',':
	return(1);
	}
return(0);
}

