#include <stdio.h>
/*			Copyright 1982 by Bill Webb.	 		*/
#include "data.h"

	/* use current line num to update index with record offset.
  	  note in passing:
		offset >= 0: record in parent data file.
		offset < 0: record in modification file.
	*/

u_index(recoffset)
POSITION recoffset;
{

	fseek(windex, line * sizeof(LINENUMBER), 0);	/* were to write */


		/* write new line offset */
	if(!fwrite((char *)&recoffset, sizeof(LINENUMBER), 1, windex))
		err("bad fwrite");

	if (!modnoted)
		Modified();
	/* do a flush to make sure index always has current info */
	fflush(windex);
}

i_index(recoffset)
POSITION recoffset;
{
/*
 * insert new record into file at position "line".
 * whose data record is at "recoffset"
 * method:
 * 1.	save current last buffer location,
 * 2.	move entries down, 
 * 3.	insert new top entry.
 */
#define SIZE	64

	register int l;
	POSITION tmp = recoffset;
	POSITION buff[SIZE+1];

	tracef(("insert line %D position %D\n",line,tmp));
		/* seek index write ptr */
	fseek(index, line * sizeof(LINENUMBER), 0);	/* were to start reading */
	fseek(windex, line * sizeof(LINENUMBER), 0);

	while ((l = read(fileno(index),(char *) (buff+1), SIZE * sizeof (POSITION))) > 0)
		{
		buff[0] = tmp;			/* insert new top entry */
		if (write(fileno(windex), (char *) buff, l) < 0)
			err("bad write");	/* write last entry */
		tmp = buff[l / (sizeof (POSITION))];
		}

	if(!fwrite((char *) &tmp, sizeof(LINENUMBER), 1, windex))
		err("bad fwrite");	/* write last entry */
	++nrecs;
	Modified();
	/* do a flush to make sure index always has current info */
	fflush(windex);
}

Modified()
{
	POSITION tmp;
/*
 * set modified flag at start of file, this is -1 * number of records
 */
	fseek(windex, 0L, 0);
	tmp = -nrecs;
	tracef(("update nrecs = %D in index file\n",tmp));
	fwrite((char *)&tmp, sizeof(LINENUMBER), 1, windex);
	++modnoted;
}
