#include <stdio.h>

#define true 1
#define false 0

#ifdef DEBUG
#define tracef(x) if(debug) {printf("+");printf x;}
#else
#define tracef(x)
#endif

#define	FATAL	1
#define	NOTFATAL	0

int debug;
#define NIL 0
#define	FILESIZE	64

FILE	*datafile,	/* parent data file */
	*modfile,	/* read for file in which modified recs are kept */
	*wmodfile,	/* write for file in which modified recs are kept */
			/* always opened write-append */
	*index,		/* read stream for line index */
	*windex,	/* write stream for line index */
	*wfile;		/* for writing in place */

	char	*datafname;	/* name of data file */
	char	modfname[FILESIZE];	/* name of modification file */
	char	indexfname[FILESIZE];	/* name of index file */


char *buf, *outbuf;	/* buffers */
int	bufsiz;		/* size of above buffers */

#define TSIZ 128
char tmpbuf[TSIZ];		/* a scratch buf for various purposes */


typedef long int LINENUMBER;
typedef long int POSITION;	/* the position in the file */

LINENUMBER line;

/* record separator */
char recsep;

/* field sep */
char fs;

#define	NOFS -1		/* don't stop on field separator */


char	*prompt,	/* prompt to print for command input */
	*progname,	/* name of the program */
	modflag;

POSITION offset;	/* bytes displacement in data/mod file */
/*	guaranteed to contain the byte displacement of the
	record after a call to getrec IF getrec
	returns a non-zero value.
	if < 0, then the line is in the modification
	datafile attached to fileptr.modfile otherwise
	it is in the parent data file attached to 
	fileptr.datafile 
 */

char *cmd;		/* default command char */
LINENUMBER	nrecs,	/* number of records in file */
		lineno;	/* current new line number */
long modtime();
int modnoted;		/* set if we've noted modification */
POSITION Deleted;
#define	MAXFIELD	100
char	*header[MAXFIELD],	/* field headings */
	*hfmt;		/* heading format */
int	hflg,		/* headers present */
	aflg,		/* fs must follow recsep */
	nflg,		/* numeric field headers */
	mflg,		/* headers must match */
	Iflg,		/* inplace update inhibited */
	vflg,		/* verbose */
	uflg,		/* unlink index file after use */
	hcnt,		/* current field limit */
	updated,	/* if updated in place */
	readonly,	/* if we can't write the file */
	cre_modfile;	/* new index - create modfile */
#define	HEADOUT	40	/* output heading length */

char	undo_cmd;	/* last command that's undoable */
POSITION undo_pos;	/* position to undo */
LINENUMBER undo_line;	/* place to undo it */

char	*ind_pfx,	/* prefix for index file */
	*mod_pfx,	/* prefix for mod file */
	*tmp_pfx,	/* prefix for temp file */
	*fgetrec(),
	*outchar(),
	*any(),
	*strsave(),
	*getrec(),
	*calloc(),
	*basename(),
	*outchar(),
	*fgets(),
	*ngetrec();
long int ftell(), filesize();
FILE *myopen();
