#include "lisp.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	QT	'\''			/* quote character */
#define	NL	'\n'			/* new line character */
#define	DIGIT(c)	(c >= '0' && c<='9')
#define	ungetc(c)	nextchar = c
#define	LPAR	0
#define	RPAR	1
#define	DOT	2


int level 0;		/* paren level */
int sp_level 0;		/* super paren level */
#define	MAXSP	20	/* maximum number of super parens */
char superp[MAXSP];	/* define super parens */
char nextchar 0;
char lastchar NL;
char pfx '*';


rd()
{
/*
 * read an s-expr from the input stream.
 */
register char *p, *q, *first;

switch(p = rditem())
	{
default:
	return(p);
case DOT:
case RPAR:
	error("syntax");
case LPAR:
	break;
	}
p = 0;
first = nil;
for (EVER)
	{
	switch(q = rditem())
		{
	case RPAR:
		return(first);
	case LPAR:
		ungetc('(');
		--level;
		q = rd();
		break;
	case DOT:
		if(first != p)		/* not 1 list elt */
			error("syntax");
		q = rd();
		if(rditem()!=RPAR)
			error("syntax");
		p->cdr = q;
		return(first);
	default:
		break;
		}
	if(p == 0)
		p = first = cons(q,nil);
	else
		p = p->cdr = cons(q,nil);		/* add to end of list */

	}
}

rditem()
{
register int c;
register char *buffp;
register int tp;
NUMERIC atof();

for (EVER)
	{
	buffp = buffer;
	switch(c = getch())
		{
	case QT:
		return(cons(qt,cons(rd(),nil)));

	case '"':
		for (EVER)
			{
			c = getch();
			if(c == NL)
				error("missing \"");
			if(c == '"')
				if((c=getch()) !='"')
					break;
			*buffp++ = c;
			}
	make:
		*buffp++ = 0;
		ungetc(c);
		return(makeatom(undef,nil,buffer));
	case ';':
		while ((c = getch()) !=NL)
			;
	case ' ':
	case TAB:
	case NL:
		break;
	case '<':
		if(sp_level >= MAXSP)
			error("more than %d <'s",MAXSP);
		superp[++sp_level] = level;
	case '(':
		++level;
		return(LPAR);
	case '>':
		if(level <= 0)
			break;
		if(level > superp[sp_level] + 1)
			ungetc('>');
	case ')':
		if(level<= 0)
			break;
		if(--level == superp[sp_level])
			if(sp_level)
				--sp_level;
		return(RPAR);
	case '.':
		return(DOT);
	case '-':
	case '+':
		*buffp++ = c;
		c = getch();
		if(delim(c))
			goto make;
	default:
		if(DIGIT(c))
			{
			tp = INT;
			do
				{
				*buffp++ = c;
				c = getch();
				}
			while (DIGIT(c));
			if(!delim(c))
				goto getname;	/* cannot be a number */
			if(c == '.')
				{
				do
					{
					*buffp++ = c;
					c = getch();
					}
				while (DIGIT(c) || c == 'e');
				if(!delim(c))
					goto getname;
				tp = REAL;
				}
			*buffp++ = 0;
			ungetc(c);
			return(makenum(atof(buffer),tp));
			}
	getname:
		do
			{
			*buffp++ = c;
			c = getch();
			}
		while (!delim(c));
		goto make;
		}
	}
}

getch()
{
register int c;
register char *p;

if(c = nextchar)
	{
	nextchar = 0;
	return(lastchar = c);
	}
loop:
if(fin == 0 && lastchar == NL)
	write(2,&pfx,1);
if((lastchar = getchar()) == 0)
	{
	lastchar = NL;
	close(fin);
	if(argc > 0)
		{
		--argc;
		p = *argv++;
		if((fin = open(p,0)) < 0)
			error("can't open %s",p);
		}
	else
		{
		if(fin)
			fin = 0;
		else
			exit();
		}
	goto loop;
	}
return(lastchar);
}

terread()
{
register int c;

while (lastchar != NL)
	getch();
return(nil);
}

delim(c)
{
switch(c)
	{
case 0:
case ';':
case QT:
case '(':
case ')':
case '.':
case '>':
case '<':
case ' ':
case ',':
case NL:
case TAB:
	return(1);
	}
return(0);
}

SUBR(_readch)						/* _readch */
{
register int ch;

while ((ch = getch()) == NL)
	;
buffer[0] = ch;
buffer[1] = 0;
return(makeatom(undef,nil,buffer));
}

SUBR(_readline)						/* _readline */
{
register int ch;
register char *p;

p = buffer;
while ((ch = getch()) != NL)
	*p++ = ch;
*p = 0;
return(makeatom(undef,nil,buffer));
}
