#include "lisp.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	RANGE(a,b)	( (b<<8) + a)
#define	MIN(a)	RANGE(a,0177)
#define	NONE	RANGE(0,0)
#define	ONE	RANGE(1,1)
#define	TWO	RANGE(2,2)
#define	ANY	RANGE(0,0177)

/*
 * note: in general any routine starting with "_" implements a
 * lisp subr, nsubr, or fsubr.
 */

char *subrs[]
{
/*
 name  address # of arguments
 */
"car",	&_car, ONE,
"cdr",	&_cdr, ONE,

"caar", &_caar, ONE,
"cadr", &_cadr, ONE,
"cdar", &_cdar, ONE,
"cddr", &_cddr, ONE,

"caaar", &_caaar, ONE,
"caadr", &_caadr, ONE,
"cadar", &_cadar, ONE,
"caddr", &_caddr, ONE,
"cdaar", &_cdaar, ONE,
"cdadr", &_cdadr, ONE,
"cddar", &_cddar, ONE,
"cdddr", &_cdddr, ONE,

"caaaar", &_caaaar, ONE,
"caaadr", &_caaadr, ONE,
"caadar", &_caadar, ONE,
"caaddr", &_caaddr, ONE,
"cadaar", &_cadaar, ONE,
"cadadr", &_cadadr, ONE,
"caddar", &_caddar, ONE,
"cadddr", &_cadddr, ONE,

"cdaaar", &_cdaaar, ONE,
"cdaadr", &_cdaadr, ONE,
"cdadar", &_cdadar, ONE,
"cdaddr", &_cdaddr, ONE,
"cddaar", &_cddaar, ONE,
"cddadr", &_cddadr, ONE,
"cdddar", &_cdddar, ONE,
"cddddr", &_cddddr, ONE,

"abs", &_abs, ONE,
"add", &_plus, ANY,
"add1", &_add1, ONE,
"addprop", &_addprop, RANGE(2,3),
"address", &_address, ONE,
"append", &_append, MIN(2),
"append1", &_app1, MIN(2),
"append*", &_appstar, MIN(2),
"apply", &_apply, TWO,
"apply1", &_apply1, ANY,
"arg", &_arg, RANGE(1,2),
"atom", &_atom, ONE,
"break", &brkloop, NONE,
"clear", &_clear, NONE,
"collect", &_collect, NONE,
"cons",	&_cons, TWO,
"copy", &_copy, ANY,
"delete", &_delete, RANGE(2,3),
"delq", &_delq, RANGE(2,3),
"difference", &_sub, TWO,
"divide", &_divide, TWO,
"dreverse", &_dreverse, ONE,
"dsubst", &_dsubst, RANGE(2,3),
"eq",	&_eq, TWO,
"eqname", &_eqname, TWO,
"equal", &_equal, TWO,
"eval",	&_eval, ONE,
"evlis", &_evlis, MIN(1),
"exclude", &_exclude, TWO,
"excludeq", &_exq, TWO,
"explode", &_explode, ONE,
"find", &_find, RANGE(2,3),
"fix", &_fix, ONE,
"float", &_float, ONE,
"gensym", &_gensym, NONE,
"getfn", &_getfn, ONE,
"greaterp", &_greaterp, MIN(1),
"info", &_info, NONE,
"intersect", &_intersect, TWO,
"intersectq", &_intq, TWO,
"last", &_last, ONE,
"length", &_length, ONE,
"lessp", &_lessp, ANY,
"list", &_list, ANY,
"listp", &_listp, ONE,
"map", &_map, MIN(2),
"mapc", &_mapc, MIN(2),
"mapcan", &_mapcan, MIN(2),
"mapcar", &_mapcar, MIN(2),
"mapcon", &_mapcon, MIN(2),
"maplist", &_maplist, MIN(2),
"mapob", &_mapob, ONE,
"max", &_max, MIN(1),
"member", &_member, RANGE(2,3),
"memq", &_memq, RANGE(2,3),
"min", &_min, MIN(1),
"minusp", &_minusp, ONE,
"mkatom", &_mkatom, ANY,
"nconc", &_nconc, TWO,
"neq", &_neq, TWO,
"not", &_not, ONE,
"nth", &_nth, TWO,
"null", &_not, ONE,
"numberp", &_nump, ONE,
"oblist", &_oblist, NONE,
"plen", &_plen, ONE,
"plus", &_plus, ANY,
"prin1", &_prin1, RANGE(1,4),
"print", &_print, RANGE(1,4),
"prog1", &_prog1, MIN(1),
"progn", &_progn, ANY,
"put", &_put, RANGE(2,3),
"putl", &_putl, RANGE(2,3),
"putob", &_putob, ANY,
"read", &_read, RANGE(0,2),
"readch", &_readch, RANGE(0,2),
"readline", &_readline, RANGE(0,2),
"rem", &_rem, RANGE(2,3),
"remain", &_remain, TWO,
"remob", &_remob, ANY,
"remove", &_remove, RANGE(2,3),
"return", &_return, ONE,
"reverse", &_reverse, ONE,
"rplaca", &_rplaca, TWO,
"rplacd", &_rplacd, TWO,
"set", &_set, MIN(2),
"skip", &_skip, RANGE(1,3),
"stop", &_exit, NONE,
"sub", &_sub, TWO,
"sub1", &_sub1, ONE,
"tab", &_tab, RANGE(1,3),
"tailp", &_tailp, TWO,
"terpri", &_terpri, RANGE(0,1),
"terread", &_terread, RANGE(0,1),
"times", &_times, ANY,
"undefp", &_undefp, ONE,
"uneval", &_uneval, RANGE(1,2),
"union", &_union, TWO,
"unionq", &_unionq, TWO,
"unix",	&_unix, ONE,
"zerop", &_zerop, ONE,
0, 0 };

char *atoms[]		/* atoms known to lisp */
{
"quote", &qt,
"expr",	&expr,
"nexpr", &nexpr,
"fexpr", &fexpr,
"lambda", &lambda,
"nlambda", &nlambda,
"flambda", &flambda,
"subr",	&subr,
"nsubr", &nsubr,
"fsubr", &fsubr,
"pmacro", &pmacro,
0,	0 };


char *fsubrs[]
{
"quote", &_quote, ANY,
"cond", &_cond, ANY,
"and", &_and, ANY,
"or", &_or, ANY,
"defun", &_defun, ANY,
"trace", &_trace, ANY,
"uncons", &_uncons, ANY,
"untrace", &_untrace, ANY,
"prog", &_prog, ANY,
"defprop", &_defprop, ANY,
"select", &_select, ANY,
"selectq", &_selq, ANY,
"get", &_get, RANGE(2,3),
"getl", &_getl, RANGE(2,3),
0, 0 };

char *nsubrs[]
{
"diskin", &_diskin, ONE,
"time", &_time, RANGE(1,3),
"go", &_go, ONE,
"assoc", &_assoc, RANGE(2,3),
"assocq", &_assocq, RANGE(2,3),
"status", &_status, MIN(1),
"setq", &_setq, MIN(2),
"repeat", &_repeat, RANGE(2,3),
"while", &_while, MIN(1),
"until", &_until, MIN(1),
0, 0 };
