#include "link.h"
/*		Copyright 1976 by Bill Webb. 		*/

int tsize;		/* temp for size calcuations */

char textname[] ".text.  ";
char dataname[] ".data.  ";
char bssname[]  ".bss.   ";

do_psect(name,f,val)
char *name;
int val;
{
register struct psect *p;
register char *value;
register int flags;
int info[2];		/* tmp file info */

flags = f | DEFINED;
value = val;
if(value&1)
	++value;	/* can't be odd */
p = findpsect(name);
if(p->p_flags)
	{		/* previously defined */
	if(flags != (p->p_flags & ~ BSS))
		if((flags&REL) || (p->p_flags&REL))
			/* if either relocatable print warning */
			warn("inconsistent psect attributes %o:%o in <%.8s>",
			flags,p->p_flags,p->p_name);
	}
else
	{	/* now being defined */
	if( (flags&RELOC)==REL && (flags&ACCESS)==PRV)
		/* if its a data segment */
		flags =| BSS;	/* assume bss til we know better */
	flags =| DEFINED;	/* remember what we've done */
	}

if(flags&ALLOC) 	/* overlaid */ 
	{
	p->p_reloc = p->p_addr;	/* overlaid = use start of psect */
	if(wflg && p->p_length && p->p_length != value)
		warn("psect <%.8s> lengths unequal %d:%d bytes",
			p->p_name, p->p_length, value);
	if(p->p_length < value)
		p->p_length = value;
	}
else
	{
	/* concatenated */
	p->p_reloc = p->p_addr + p->p_length;
	p->p_length =+ value;
	if(value > p->p_length)
		/* if overflow on length accumulation */
		{
		tsize = ldiv(1,p->p_length,1024);
		if(ldivr)
			++tsize;
		err("psect <%.8s> size (%dK bytes) exceeds 64K bytes" ,p->p_name,tsize);
		}
	info[0] = p;
	info[1] = value;
	tmpwrite(PSECT,info,sizeof info);
	}
cur_psect = p;
p->p_flags =| flags;
cur_rflag = p->p_flags & RELOC;
cur_reloc = p->p_reloc;
p->p_size = value;
p->p_def = module;		/* last defined in this module */
if(scan)
	prpsect(p);
return(p);
}

findpsect(name)
char *name;
{
/*
 * find psect of given "name" and if not found allocate an entry
 * in the psect table and return it.
 */
register struct psect *p;

for (allpsects)
	if (eqsym(p->p_name,name))
		return(p);
/* not yet allocated */
if (++npsects >= MAXPSECTS)
	err("more than %d psects",MAXPSECTS);
cpsym(name,p->p_name); /* copy name */ 
p->p_reloc = 0;
p->p_flags = 0;
p->p_addr = 0;
p->p_size = 0;
return(p);
}

prpsect(ps)
struct psect *ps;
{
/*
 * print out psect information for psect "ps".
 */
register struct psect *p;
register int flags;

p = ps;
if(p->p_size==0 && debflg==0)
	return;
flags = p->p_flags;
printf("<%-8.8s> %6l. %6o",p->p_name,p->p_size,p->p_reloc);
if(flags&ALLOC)
	printf(" ovr");
if(flags&ACCESS)
	printf(" shr");
if(flags&SCOPE)
	printf(" gbl");
if((flags&RELOC)==ABS)
	printf(" abs");
if(pass==2 && flags&BSS)
	printf(" bss");
putchar('\n');
}

map()
{
register struct psect *p;

printf(" psect       size    addr  attr\n");
prpsect(&text);
prpsect(&data);
prpsect(&bss);
putchar('\n');
for(allpsects)
	{
	prpsect(p);
	}

}

allocate()
{
register struct psect *p;
register struct psect *q;
register struct symbol *s;

/*
 * loop through all the psects and increment the size of either
 * the text, data, or bss master psects.
 */
cpsym(textname,text.p_name);
cpsym(dataname,data.p_name);
cpsym(bssname,bss.p_name);

if(tr_psect!=0)
	{
	text.p_size =+ 4;		/* allow for jmp @#addr */
	text.p_reloc =+ 4;
	}
for(allpsects)
	{

	q = ptype(p);
	q->p_size =+ p->p_length; /* get total length */
	if(q->p_size < p->p_length)
		/* overflow on length accumulation */
		err("length of %.8s section > 64Kb in psect %.8s",
			q->p_name,p->p_name);

	q->p_length = q->p_size;
	}

text.p_addr = 0;
if (sharing)
	{
	text.p_size = (text.p_size+077) & ~ 077;
	if(!idsep)
		data.p_addr = (text.p_size+017777) & (~017777);
	}
else
	data.p_addr = text.p_size;

if(idsep)
	data_off = text.p_size;
bss.p_addr = data.p_addr + data.p_size;
if(bss.p_addr < data.p_addr)
	err("end of data section > 64Kb");

data.p_reloc = data.p_addr;
bss.p_reloc = bss.p_addr;
high_limit = bss.p_addr + bss.p_length;
if(high_limit < bss.p_addr)
	{
	tsize = ldiv(1,high_limit,1024);
	if(ldivr)
		++tsize;
	err("total program size (%dK bytes) exceeds 64K bytes",tsize);
	}

if(high_limit >= 0160000)
	warn("program size (%l) exceeds 56K bytes",high_limit);
data.p_flags = REL;
text.p_flags = REL | SHR;
bss.p_flags = REL | BSS;

/*
 * assign actual psect start addresses now that the start of
 * each (text,data,bss) segment is known. abs psects are 
 * ignored. 
 */
for (allpsects)
	{
	q = ptype(p);
	p->p_addr =+ q->p_reloc;	/* relocate psect start */
	q->p_reloc =+ p->p_length;	/* point to next start addr */
	p->p_reloc = p->p_addr; 	/* relocation start address */
	p->p_size = p->p_length;
	p->p_length = 0;
	}

/*
 * reset the master psect relocation addresses so that
 * the map (if any) will be correct. 
 */

bss.p_reloc = bss.p_addr;
data.p_reloc = data.p_addr;
text.p_reloc = text.p_addr;

/*
 * now that psects have been allocated their final addresses
 * go through the symbol table and relocate all relocatable
 * symbols from the psect start address.
 */
for (allsymbols)
	{
	if(s->s_flags & RELOC) 		/* if relocatable */
		s->s_addr =+ (s->s_psect)->p_addr;	/* relocate */
	}

}



/*
 * get a pointer to the master psect of which p is an
 * instance.
 */
struct psect *ptype(pp)
struct psect *pp;
{
register struct psect *p;
p = pp;
if ((p->p_flags & RELOC) == ABS)
	return(&abs);
if (p->p_flags&SHR)
	return(&text);
else
	if (p->p_flags&BSS)
		return(&bss);
	else
		return(&data);
}


/*
 * for psects that are CON (i.e. their p_reloc changes during
 * psect processing) during pass2 psect2 accumulates the lengths 
 * to get the proper p_reloc.
 */
psect2(buff,linecnt)
int *buff;
{
register struct psect *p;
register int value;

p = *buff++;

p->p_reloc = p->p_addr + p->p_length;
p->p_length =+ *buff;
p->p_def = module;
if(debflg)
	printf("psect %.8s %d. %o\n",p->p_name,p->p_length,p->p_reloc);
}


defpsects()
{
/*
 * define all psects as symbols unless there is already a symbol
 * with that name.
 * this allows locating the psects in the namelist and also implements
 * referencing psects by .globls.
 */
register struct psect *p;
register struct symbol *s;

defining = 1;			/* the whole point of it */
for (allpsects)
	{
	if(p->p_name[0]==0 || (p->p_flags&REL)==0)
		continue;
	s = findsym(p->p_name);
	if(s->s_flags==UNDEFINED)
		{
		s->s_flags =| DEFINED|REL;
		s->s_psect = p;
		}
	}

}
