#include "link.h"
/*		Copyright 1976 by Bill Webb. 		*/

/*
 * seek to current position + amount (which is signed).
 *
 * only real problem is trying to find out if the address to 
 * seek to is in the current input buffer.
 */
gseek(amount)
{
register int k;

if(debflg>1)
	printf("gseek %d count=%d\n",amount,inp.count);
inp.count = 0;		/* always reset by seek */
if(amount == 0)
	return;		/* almost too easy */
if(amount < 0)
	{		/* backing up */
	k = inp.nextp - inp.buffer;	/* how far back we can go */
	if( k >= -amount)
		{
		seekok:		/* seek still inside buffer */
		inp.nextp =+ amount;
		inp.nleft =- amount;
		if(debflg>1)
			printf("nleft=%d ptr=%d",inp.nleft,
				inp.nextp-inp.buffer);
		return;
		}
	}
else
	{		/* going forwards */
	if(inp.nleft > amount)
		goto seekok;
	}
if(seek(inp.fildes,amount-inp.nleft,1)<0)	/* seek outside buffer */
	err("while seeking");
inp.nleft = 0;
}

filopen(fname)
char *fname;
{
inp.count = 0;
inp.nleft = 0;
inp.fildes = open(fname,0);
return(inp.fildes);
}


getch()
{
if(--inp.nleft < 0)
	{
	if(!getmore())
		return(-1);
	}
++inp.count;
return(*inp.nextp++ & 0377);
}

getwd()
{
int w;
if(--inp.nleft < 0)
	{
	if(!getmore())
		return(-1);
	}
w.lo = *inp.nextp++;
if(--inp.nleft < 0)
	{
	getmore();
	}
w.hi = *inp.nextp++;
inp.count =+ 2;
return(w);
}

getmore()
{
inp.nextp = inp.buffer;
if((inp.nleft = read(inp.fildes,inp.buffer,512))<0)
	err("while reading");
return(--inp.nleft >= 0);
}

fclose()
{
if(close(inp.fildes)<0)
	err("while closing");
inp.nleft = 0;
inp.fildes = -1;
}

/*
 * seek to given address in the program.
 * address is mapped to actual file offset here. 
 */

pseek(addr)
char *addr;
{
register char *a;
register int disp;

a = addr;
if(idsep)
	a =+ rel_off;
else
	{
	if(a >= data.p_addr)
		/* if sharing actual address is right after text */
		a =- data.p_addr - text.p_size;
	}
a =+ 020;
if(debflg > 1)
	printf(" pseek to %o\n",a);
if(out.p_max==0)
	{		/* nothing in buffer */
	out.p_offset = a;
	return;
	}
disp = a - out.p_offset;	/* displacement into buffer */
if(disp < 0 || disp > out.p_max)
	{
	/* can't put in current buffer */
	pflush();
	out.p_offset = a;
	}
else
	{
	/* will fit into the buffer */
	out.p_disp = disp;
	}
}

/*
 * output a byte to requested address
 */

putch(c)
char c;
{

if(out.p_disp >= 512)
	pflush();
out.buffer[out.p_disp++] = c;
if(out.p_disp > out.p_max)
	out.p_max = out.p_disp;
}


/*
 * output the current buffer and reset pointers 
 */

pflush()
{
if(out.p_max > 0)
	{
	if(seek(out.fildes,out.p_offset,0)<0)
		err("while seeking");
	if(write(out.fildes,out.buffer,out.p_max)<0)
		err("while writing");
	}
out.p_offset =+ out.p_max;
out.p_max = 0;
out.p_disp = 0;
}


putwd(w)
int w;
{

/*
 * following code is two copies of code in putch 
 * for efficiency. it replaces putch(w.lo) and 
 * putch(w.hi). 
 */
if(out.p_disp >= 512)
	pflush();
out.buffer[out.p_disp++] = w.lo;
if(out.p_disp > out.p_max)
	out.p_max = out.p_disp;

if(out.p_disp >= 512)
	pflush();
out.buffer[out.p_disp++] = w.hi;
if(out.p_disp > out.p_max)
	out.p_max = out.p_disp;
}

/*
 * routine to quickly get a line of text (for fbread) unless it crosses
 * a record boundary, where good old getc is used.
 */

gettxt(line,linecnt)
char *line;
{
register char *linep;
register int l;
register char *p;

l = linecnt;
linep = line;

if(inp.nleft >= l)
	{		/* its all in the buffer - goody */
	inp.nleft =- l;
	inp.count =+ l;
	p = inp.nextp;
	do
		*linep++ = *p++;
	while (--l);
	inp.nextp = p;
	}
else
	{
	do
		*linep++ = getch();
	while (--l);
	}
}

puttxt(line,linecnt)
char *line;
{
/*
 * routine to output a number of characters. if there exists 
 * room in the buffer then the characters are directly moved. 
 * if not then a number of calls to putch are made. 
 */
register int l;
register char *p;
register char *q;

l = linecnt;
if(out.p_disp >= 512)
	pflush();
p = line;
if(out.p_disp + l > 512)
	{
	do
		putch(*p++);
	while (--l);
	}
else
	{
	q = out.buffer + out.p_disp;
	out.p_disp =+ l;
	do
		*q++ = *p++;
	while (--l);
	if(out.p_disp > out.p_max)
		out.p_max = out.p_disp;
	}
}
