/*
use: days=juldate(year1, month1, day1, year2, month2, day2) 
purpose given two dates in numeric form, calc the number of days between
date1 and date2.
limitations:date1 must be greater than date2. the diffence must be smaller
than maxint i.e. about 89 years on pdp11.
*/

static int day_tab[2][13] = {
	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};
int dcount=0;

long jday(y1, m1, d1, y2, m2, d2)
int y1, m1, d1, y2, m2, d2;
{
	register int i;
	int sign;

	long days;
	float t1, t2;

	dcount++;
	t1 = 10000.0 * y1 + 100.0 * m1 + d1;
	t2 = 10000.0 * y2 + 100.0 * m2 + d2;
	sign = (t1 >= t2) ? 1 : -1;
	if (sign == -1) {
		exchange (&y1, &y2);
		exchange (&m1, &m2);
		exchange (&d1, &d2);
	}

/* if the 2 dates are in same year, subtr and return */
	if (y1 == y2)
		return(sign * (d_of_yr(y1,m1,d1) - d_of_yr(y2,m2,d2)));

/* days from date2 to end of y2 */
	days = d_of_yr(y2, 12, 31) - d_of_yr(y2, m2, d2);

/* now add all the whole years up to y1 */
	for( i = ++y2; i < y1; i++)
		days += d_of_yr (i, 12, 31);

/* calc the days in the last year up to the date y1, m1, d1 */
	return ( sign * (days + d_of_yr(y1, m1, d1)) );

}


int d_of_yr(year, month, day)
int year, month, day;
{
	register int i, leap;

	if ( month < 0 || month > 12 )
		err("jday:bad month at date %d", dcount);

	leap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
	for ( i = 1; i < month; i++)
		day += day_tab[leap][i];
	return(day);
}

int exchange ( x, y )
int *x, *y;
{
	int tmp;

	tmp = *x;
	*x = *y;
	*y = tmp;
}
