#include <stdio.h>
#include <ctype.h>

	/* getnstr(buf, bufsiz, fp) 	(note resemblance to fgets() )
	 *	char *buf;
	 *	int bufsiz;
	 *	FILE *fp;
	 *
	 * synopsis: gets a string from the stream attached to fp
	 *	just like a fscanf("%s", buf); would do, but does
	 *	it with a lot less overhead and is smarter in that
	 *	it dies with a fatal error message if the buffer is exceeded.
	 *	bufsiz must be large enough to include null byte.
	 * diagnostics:
	 *	returns the length the string obtained.
	 *	returns a 0 on a newline.
	 *	returns a EOF at end of file.
	 *	dies with a error message on stderr if buf overflow.
	 */ 

#ifdef TEST
main() {
	int getnstr();
	char buf[32];
	int len;
	while((len=getnstr(buf, 32, stdin)) != EOF)
		printf("len=%d \t buf='%s'\n", len, buf);
}
#endif

#ifdef TIMETEST
main() {	/* use to compare against scanf("%s",buf);	*/
	int getnstr();
	char buf[32];
	while(getnstr(buf,32,stdin) != EOF)
		;
}
#endif

int getnstr(s, BSIZ, fp)
register char *s;
register FILE *fp;
{
	register int c;
	char *base = s, *endbuf = s + BSIZ;

		/* eat up leading white space */
	while( (c = getc(fp)) != EOF && isspace(c) )
		if(c == '\n') {
			*s = '\0';
			return(0);
		}

	if(c == EOF)
		return(EOF);

	/* fill buffer with string as long as !EOF and char !spac
	 * and buffer limit ! exceeded
	 */
	for( *s++ = c; (c = getc(fp)) != EOF && !isspace(c) && s < endbuf;)
		*s++ = c;

	if (s >= endbuf)	/* check for buffer overflow */
		err("getnstr: >%d chars", BSIZ);

	if(c != EOF )
		ungetc(c, fp);

	*s = '\0';	/* put a null byte at end of string */

	if(s == base)	/* if true, then nothing in buf i.e. EOF */
		return(EOF);

	return(s - base);
}
