#
/*
 FSED - fs edit program
*/
#define	WTM	0
#define BSF	2
#define FSR	3

#define DIRLEN	sizeof(*ldir)
#define MAGIC	0123456

#define PEX 0
#define PER 1
#define PFX 2
#define PFR 3

#define MAGICC	1
#define NO	2
#define NAME	3
#define	ID0	4
#define	ID1	5
#define	SDATE0	6
#define	SDATE1	7
#define	VERS	8
#define	MDATE0	9
#define	MDATE1	10
#define	FLAGS	11
#define	SIZE0	12
#define	SIZE1	13
#define	D	14
#define	Q	15
#define	N	16
#define P	17
#define S	18
#define L	19
#define M	20
#define R	21
#define O	22
#define LEN	23
#define W	24
#define FILECNT	25
#define F	26
#define DIRECTORY 27
#define B	28
#define GAPCNT	29
#define FULL	30
#define X	31
#define I	32
#define T	33
#define PARTIAL 34

char *cmds[]
	{
	"magic","no","name","id0","id1","sdate0","sdate1","vers","mdate0","mdate1",
	"flags","size0","size1","d","q","n","p","s","l","m","r","o","len","w",
	"filecnt","f","directory","b","gapcnt","full","x","i","t","partial",0
	};

struct ldirstr	{
	int	d_magic;
	int	d_no;
	char	d_name[58];
	char	d_ids[2];
	int	d_sdate[2];
	int	d_vers;
	int	d_mdate[2];
	int	d_flags;
	int	d_size[2];
	} ;

struct ldirstr *ldir;

int	wno;
int	wname;
int	wvers;

char	*intape;
char	*outape;
int	in;
int	out;
int	len,		wlen;
int	filecnt,	wfilecnt;
int	gapcnt,		wgapcnt;
int	editing	1;
int	delete,		wdelete;
int	directory 1,	wdirectory;
int	argcc;
char	cpbuf[4096];
int	*intbuf cpbuf;
char	*argp[32];
char	argl[160];
char	lastch;
int	next -1,	wnext;
int	tout;
int	file;
int	redit();
int	full,		wfull;
char	*labelname	" Label/directory: ";
char	ctime();
int	inform;
int	tell;
int	partial;
int	ttyin;
int	histout	1;

main(argc,argv)							/* main */
char **argv;
{

	register b;
	int tvec[2];
	if(argv[1][0] == '-') {
		--argc;
		argv++;
		if((ttyin = open("fsed.hist",2)) < 0) error(PEX,"fsed.hist");
	}	else	if((histout = creat("fsed.hist",0666)) < 0) error(PEX,"fsed.hist");
	intape = "/dev/rmt-";
	if(argc < 3) outape = "/dev/null";
	else outape = "/dev/rmt?";

	intape[8] = argv[1][0];
	if(argc > 2) outape[8] = argv[2][0];

	if((in = open(intape,0)) < 0) error(PEX,intape);
	if((out = open(outape,1)) < 0)error(PEX,outape);


	ldir = cpbuf;
	setexit();
	signal(2,redit);
	next = -1;
	delete = 0;
	editing++;

	for(;;) {
		if(inform) informm();
		write(1,"> ",2);
		lastch = 0;
		if(!(argcc=getline())) continue;
		switch(cmd()) {
				/* Commands from here down to default modify
					either directory variables or the working
					variables of this program.
				  Needless to say GREAT care should be taken
					in modifying things like the filecnt,
					vers, DIRECTORY, etc.
				Without exception these commands (down to default)
					with an argument change the named variable
					to the argument; without an argument
					they report the current value of the variable.
				*/
			case MAGICC:
				if(argcc > 1) ldir->d_magic = c2o(argp[1]);
				printf("0%o\n",ldir->d_magic);
				break;

			case NO:
				if(argcc > 1) ldir->d_no = c2d(argp[1]);
				printf("%d.\n",ldir->d_no);
				break;

			case NAME:
				if(argcc > 1) cp(argp[1],ldir->d_name);
				printf("%s\n",ldir->d_name);
				break;

			case ID0:
				if(argcc > 1) ldir->d_ids[0] = c2d(argp[1]);
				printf("0%o\n",ldir->d_ids[0]);
				break;

			case ID1:
				if(argcc > 1) ldir->d_ids[1] = c2d(argp[1]);
				printf("0%o\n",ldir->d_ids[1]);
				break;

			case SDATE0:
				if(argcc > 1)
					if(eq(argp[1],"time")) {
						time(tvec);
						ldir->d_sdate[0] = tvec[0];
						ldir->d_sdate[1] = tvec[1];
					} else ldir->d_sdate[0] = c2o(argp[1]);
				printf("0%o %s",ldir->d_sdate[0],ctime(ldir->d_sdate));
				break;

			case SDATE1:
				if(argcc > 1) ldir->d_sdate[1] = c2o(argp[1]);
				printf("0%o %s",ldir->d_sdate[1],ctime(ldir->d_sdate));
				break;

			case VERS:
				if(argcc > 1) ldir->d_vers = c2d(argp[1]);
				printf("%d.\n",ldir->d_vers);
				break;

			case MDATE0:
				if(argcc > 1)
					if(eq(argp[1],"time")) {
						time(tvec);
						ldir->d_mdate[0] = tvec[0];
						ldir->d_mdate[1] = tvec[1];
					} else ldir->d_mdate[0] = c2o(argp[1]);
				printf("0%o %s",ldir->d_mdate[0],ctime(ldir->d_mdate));
				break;

			case MDATE1:
				if(argcc > 1) ldir->d_mdate[1] = c2o(argp[1]);
				printf("0%o %s",ldir->d_mdate[1],ctime(ldir->d_mdate));
				break;

			case FLAGS:
				if(argcc > 1) ldir->d_flags = c2o(argp[1]);
				printf("0%o\n",ldir->d_flags);
				break;

			case SIZE0:
				if(argcc > 1) ldir->d_size[0] = c2o(argp[1]);
				printf("0%o %s.\n",ldir->d_size[0],locv(ldir->d_size[0],ldir->d_size[1]));
				break;

			case SIZE1:
				if(argcc > 1) ldir->d_size[1] = c2o(argp[1]);
				printf("0%o %s.\n",ldir->d_size[1],locv(ldir->d_size[0],ldir->d_size[1]));
				break;

			case LEN:
				if(argcc > 1) len = c2d(argp[1]);
				printf("%d.\n",len);
				break;

			case FILECNT:
				if(argcc > 1) filecnt = c2d(argp[1]);
				printf("%d.\n",filecnt);
				break;

			case DIRECTORY:
				if(argcc > 1) directory = c2d(argp[1]);
				printf("%d.\n",directory);
				break;

			case GAPCNT:
				if(argcc > 1) gapcnt = c2d(argp[1]);
				printf("%d.\n",gapcnt);
				break;

			case FULL:
				if(argcc > 1) full = c2d(argp[1]);
				printf("%d.\n",full);
				break;

			case PARTIAL:
				if(argcc > 1) partial = c2d(argp[1]);
				printf("%d.\n",partial);
				break;

			default:
				printf("Invalid command\n");
				break;

			/* delete file from current block to EOF. Arg: none */
			case D:
				delete = 1;
				copy(0);
				delete = 0;
				break;

			/* Quit - copy from current block to EOT. Arg: none */
			case Q:
				checkdir();
				editing = 0;
				copy(0);
				while(directory = 1) copy(0);

			/* Next - copy from current block to next EOF. Arg: none */
			case N:
				checkdir();
				copy(0);
				directory = 1;
				if((len=read(in,cpbuf,4096))<0) error(PER,intape);
				full = 1;
				break;

			/* Print current block in directory format. Arg: none */
			case P:
				if(!full) {
					printf("Not FULL\n");
					break;
				}
				if(ldir->d_magic != MAGIC) {
					printf("Doesn't look like a directory to me,\n");
				 printf("but type 'y' if you really want to see it ");
					if(!getline() || argp[0][0] != 'y') break;
				}
				printdir();
				break;

			/* Locate - copy from current block to file with number. Arg: number(10) */
			case L:
				if(argcc == 1) break;
				next = c2d(argp[1]);
				checkdir();
				copy(0);
				next = -1;
				break;

			/* Mark - write EOF mark at current tape position. Arg: none */
			case M:
				dostty(WTM,1,out);
				directory++;
				break;

			/* Read next block. Arg: none */
			case R:
				if((len=read(in,cpbuf,4096))<0) error(PER,intape);
				if(len) full = 1;
				else full = 0;
				printf("%d. bytes read\n",len);
				break;

			/* Octal dump of current block. Arg: word, byte, char */
			case O:
				od();
				break;

			/* Write current block. Arg: none */
			case W:
				checkdir();
				if(directory) ldir->d_no = filecnt++;
				if(write(out,cpbuf,len) < len) error(PER,outape);
				partial = full = directory = 0;
				break;

			/* File - write from current block to EOF with output to 'filename'. Arg: filename */
			case F:
				if(argcc == 1) break;
				if((file=creat(argp[1],0666)) < 0) error(PER,argp[1]);
				tout = out;
				out = file;
				copy(1);
				close(file);
				out = tout;
				break;

			/* Start tape with FS label. Arg: labelname, optional */
			case X:
				if(filecnt) {
					printf("Filecnt = %d. Sure you want a label here? 'y' to proceed ");
					if(!getline() || argp[0][0] != 'y') break;
				}
				label();
				ldir->d_no = filecnt++;
				if(write(out,cpbuf,DIRLEN) != DIRLEN) error(PER,outape);
				dostty(WTM,1,out);
				full = 0;
				break;

			/* Inform of vital stats every pass, but with arg, only inform now. Arg: as indicated */
			case I:
				if(argcc > 1) {
					informm();
					break;
				}
				inform = !inform;
				printf("Inform status %s\n",inform ? "on" : "off");
				break;

			/* Tell - set flags to report selected variables during copy process. Arg: thngs to be told about */
			case T:
				if(argcc == 1) {
					tell = 0;
					break;
				}
				stell();
				break;

			/* Backspace to beginning of the current input tape file. Arg: none */
			case B:
				full = 0;
				dostty(BSF,1,in);
				dostty(FSR,1,in);
				break;

			/* Skip - same as locate, but does not write to output tape. Arg: numer(10) */
			case S:
				if(argcc == 1) break;
				next = c2d(argp[1]);
				delete = 1;
				directory = 0;
				copy(0);
				directory = 1;
				delete = 0;
				next = -1;
				break;

		}
	}
}

getline()							/* getline */
{
	register char *line, **ptr, i;

	line=argl;
	for(i=0;i<32;)argp[i++]=0;
	ptr=argp;

	while((*line++ = getch())!='\n');
	if(line > argl+1) if(!(*(line =- 2))) *line = '\n';
	if(*argl == '\n') return(0);
	line=argl;
	do {
		*ptr++ =line;
		while(*line!=0 && *line !='\n')line++;
	} while(*line++!='\n');
	*--line=0;
	return(ptr - argp);
}

getch()								/* getch */
{
	char c;
	register n;

	doo:
	do {
		if((n = read(ttyin,&c,1)) < 0) error(PER,ttyin ? "fsed.hist" : "input tty");
		if(n == 0)	if(ttyin == 0) exit();
				else {
					histout = ttyin;
					ttyin = 0;
				printf("Now awaiting tty input\n> ");
				goto doo;
			}
		write(histout,&c,1);
	} while(c == ' ' && lastch == 0);
	if(c==' ')c=0;
	return(lastch=c);
}

cmd()								/* cmd */
{
	char **c;

	c=cmds;
	while(*c) if(eq(argp[0],*c++))return(c-cmds);
	return(0);
}

cp(a,b)								/* cp */
{
	register char *aa, *bb;
	aa=a;
	bb=b;
	while(*bb++ = *aa++);
}

c2d(arg)
char *arg;
{
	register i;
	i = 0;

	while(*arg) i = i * 10 + (*arg++ - '0');

	return(i);
}

c2o(arg)
char *arg;
{
	register o;
	o = 0;

	while(*arg) o = o * 8 + (*arg++ - '0');

	return(o);
}

printdir()
{

	printf("0%o no: %d. name: %s id0: 0%o id1: 0%o\n",
		ldir->d_magic,ldir->d_no,(binary(ldir->d_name) ? "Contains non-printing chars, use 'o' command" : ldir->d_name)
				,ldir->d_ids[0],ldir->d_ids[1]);

	printf("sdate: %s",ctime(ldir->d_sdate));

	printf("vers: %d. mdate: %s",ldir->d_vers,ctime(ldir->d_mdate));

	printf("flags: 0%o size: %s.\n",ldir->d_flags,locv(ldir->d_size[0],ldir->d_size[1]));
}

eq(ar,cm)							/* eq */
{
	register char *a, *c;

	a = ar;
	c = cm;

	while(*a++ == *c && *c++);

	return((c != cm) && (!*--a && !*--c));
}

error(n,arg1,arg2,arg3,arg4)					/* error */
{
	if(n==PEX || n==PER) {
		perror(arg1);
		if(n==PEX) exit();
		reset();
	}
	printf(arg1,arg2,arg3,arg4);
	if(n==PFX) exit();
	reset();
}

copy(spc)
{
	register i, wasfull;

	if(full) {
		wasfull = 1;
		goto rite;
	} else wasfull = 0;

	looking:
	partial = 0;
	do {
		if((len = read(in,cpbuf,4096))<0) error(PER,intape);
		if(tell) ptell();
		if(len) {
			gapcnt = 0;
			full = 1;
			if(partial) {
				printf("Partial block in illogical position\n");
				redit();
			}
		} else full = 0;
		if(next >= 0 && directory && ldir->d_no == next) redit();
		if(len&01 && !delete) {
			printf("Odd byte count, possible read error. Len = %d.\n",len);
			redit();
		}
		if(directory && !delete) checkdir();
	rite:
		if(wasfull && tell) ptell();
		if(len && !delete) {
			if(len != 4096) {
				if(!directory) partial = 1;
				if(len < 32) {
					for(i = len; i < 32 ; i++) cpbuf[i] = 0;
					len = 32;
				}
			}
			if(directory) ldir->d_no = filecnt++;
			directory = 0;
			if(write(out,cpbuf,len) != len) error(PER,outape);
			wasfull = full = 0;
		}
	} while (len);
	if(gapcnt && !editing) {
		dostty(WTM,3,out);
		printf("%d files on output tape\n",filecnt);
		exit();
	}
	if(gapcnt) {
		printf("No data between this and last EOF\n");
		redit();
	}
	if(!delete && !spc) dostty(WTM,1,out);
	gapcnt++;
	partial = 0;
	if(next >= 0) {
		directory = 1;
		goto looking;
	}
}

checkdir()
{
	if(directory && full) {
		if(ldir->d_magic != MAGIC || len != DIRLEN || !ldir->d_vers
			|| binary(ldir->d_name)) {
				printf("Directory flag on, but");
				if(ldir->d_magic != MAGIC) printf(" MAGIC");
				if(len != DIRLEN) printf(" len");
				if(!ldir->d_vers) printf(" vers");
				if(binary(ldir->d_name)) printf(" name");
				printf(" is (are) not right\nType 'y' if dir, 'n' if not,");
				printf(" anything else to look again  ");
				if(!getline()) redit();
				if(argp[0][0] == 'y') return;
				if(argp[0][0] != 'n') redit();
				directory = 0;
		}
		return;
	}
	if(!directory && full && ldir->d_magic == MAGIC || len == DIRLEN) {
		printf("Write as a directory?\nType 'y' for yes, 'n' for no, anything else to look again  ");
		if(!getline()) redit();
		if(argp[0][0] == 'n') return;
		if(argp[0][0] != 'y') redit();
		directory = 1;
	}
}

dostty(act,n,drive)
{
	int arg[3];
	arg[0]=act;
	arg[1]=n;
	stty(drive,arg);
}

redit()
{
	reset();
}

od()
{
	struct { char hi; char lo; };
	register t;
	register i;
	register cn;
	char cc;
	int ci;
	cn = 0;
	if(argcc == 1 || argp[1][0] == 'w' || argp[1][0] == 'b') t = 2;
	else t = 1;
	while(cn * t < len) {
		printf("%5o ",cn*t);
		for(i=0; i<8 && (cn*t < len); i++)
			if(argp[1][0] == 'w' || argcc == 1) {
				printf("%6o ",intbuf[cn]);
				cn++;
			} else if(argp[1][0] == 'b') {
				printf("%3o %3o ",((&intbuf[cn])->hi)&0377,((&intbuf[cn])->lo)&0377);
				cn++;
			} else for(ci=3;--ci && (cn < len);) {
				cc = cpbuf[cn++]&0377;
				if(cc >= ' ' && cc <= '~')
						printf("  %c",cc);
				else switch(cc) {
					case '\t':
						printf(" \\t");
						break;
					case '\n':
						printf(" \\n");
						break;
					case '\r':
						printf(" \\r");
						break;
					case '\b':
						printf(" \\b");
						break;
					case '\0':
						printf(" \\0");
						break;
					default:
						printf(" \\?");
						break;
				}
			}
	printf("\n");
	}
}

label()								/* label */
{
	int tvec[2];

	if(argcc <= 1) {
		printf("Enter label/directory name. Suggested format: fs.NAME\n");
		while(!(argcc = getline()));
	}
	else argp[0] = argp[1];
	cp(labelname,ldir->d_name);
	cp(argp[0],ldir->d_name+18);
	ldir->d_no  = ldir->d_size[0] = ldir->d_size[1] = 0;
	ldir->d_vers = 1;
	ldir->d_magic = MAGIC;
	time(tvec);
	ldir->d_sdate[0]=tvec[0];
	ldir->d_sdate[1]=tvec[1];
}

binary(name)
char *name;
{
	register char *n;

	n = name;

	while(*n) if(*n < ' ' || *n++ >'~') return(1);

	return(0);
}

informm()
{
	printf("len: %d.  filecnt: %d.  gapcnt: %d.  directory: %d.  full: %d.\n",
		len,filecnt,gapcnt,directory,full);
}

/* Some of these features need to be added to the code */
stell()
{
	wno = wname = wvers = wlen = wfilecnt = wgapcnt = wdelete = wdirectory = wfull = wnext = 0;

	while(argcc > 1) {
		argp[0] = argp[--argcc];
		switch(cmd()) {
			case NO:
				wno = 1;
				break;

			case NAME:
				wname = 1;
				break;

			case VERS:
				wvers = 1;
				break;

			case LEN:
				wlen = 1;
				break;

			case FILECNT:
				wfilecnt = 1;
				break;

			case GAPCNT:
				wgapcnt = 1;
				break;

			case DIRECTORY:
				wdirectory = 1;
				break;

			case FULL:
				wfull = 1;
				break;

			default:
				printf("Not available: %s\n",argp[0]);
				break;

		}
	}
	tell = 1;
}

ptell()
{
	if(wlen) printf("len %d\n",len);
	if(wfilecnt && directory) printf("filecnt %d\n",filecnt);
	if(wgapcnt) printf("gapcnt: %d\n",gapcnt);
	if(wdirectory) printf("directory %d\n",directory);
	if(wdelete) printf("delete %d\n",delete);
	if(wfull) printf("full %d\n",full);
	if(wnext) printf("next %d\n",next);
	if(wno && directory) printf("no %d.\n",ldir->d_no);
}
