#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "fmtmac.h"
#include "fmtcc.h"
#include "macro.h"	/* pick up actual macro def's */


#define ralloc alloc
#define rfree free
struct macro *mac_fetch();
struct macro *find_macro();
char *palloc();
struct mac * last_mac = macros;

macros_etc()
{
/*
 * Determine if this is a macro reference, etc. 
 * possible types are:
 *  !name	macro/function invocation 
 *  !nn		request for character "nn"
 *  !t		time of day 
 *  !fn		counter n
 *  !d		date 
 *  !-		conditional hyphenation 
 *  !@nn	repeat last character nn times 
 *  !#nn	generate hex character "nn"
 *  !/co/	invoke command operands
 */
 
register char c;
register int n;
register char *p;
extern char etoa[];
 
c = *ptr_1++;
p = ptr_1;
switch(c)
	{
case '@':               /* repeat previous character a number of times */
	n = cvtnn();
	if(ptr_2 > buff_2)
		while (--n >= 0)
			putch(ptr_2[-1]);
	break;
 
case '-':
	*ptr_2++ = c;
	word_end(WORD_CHYPHEN);
	--p;		/* indicate we used up the - */
	break;
 
case '#':
	n = cvthex();
	n = etoa[n];
	if (n == 0)
		n = '*';
	putch(n);
	break;
case '/':
	co();
	break;
default:
	--ptr_1;
	if(DIGIT)
		{
		n = cvtnn();
		if(n >= MINNN && n <= MAXNN)
			putch(nntab[n]);
		else
			ptr_1 = p;
		break;
		}
	c = LC(c);
	if(ALPHA)
		{
		if(do_macro())
			break;
		switch(c)
			{
		case 'f':
			c = *++ptr_1;
			if(DIGIT)
				{
				++ptr_1;
				put_ctr(c-'0');
				}
			else
				err("macro %s undefined",mac_name);
			break;
		case 't':
			put_time();
			--p;
			++ptr_1;
			break;
		case 'd':
			put_date();
			--p;
			++ptr_1;
			break;
		default:
			err("macro %s undefined",mac_name);
			ptr_1 = p;
			}
		}
	break;
	}
if (p == ptr_1)		/* something went wrong */
	{
	putch(c);
	}
}


put_ctr(n)
{
if(n > 5)
	 return;
put_int(++counters[n]);
}
 
do_macro()
{
 
/*
 * collect macro name, look it up in macro table and process
 * it. 
 */
register char *p;
register struct macro *m;
register int l;
char *old, *start;
int n;		/* function return code */
 
old = ptr_1;
if(!getword(mac_name,MAXMAC,MACNAME))
	goto bad_macro;
if( m = mac_fetch() )
	{
	if(m->m_sw)
		{
		err("recursive use of %s",mac_name);
		goto bad_macro;
		}
	if(*ptr_1 == '(')
		{
		start = ++ptr_1;
		if(! scan_pars())
			goto bad_macro;
		l = ptr_1 - start;
		}
	else
		l = 0;
	p = palloc(l+1);
	p[l] = 0;
	move(l,start,p);
	m->m_par.t_length = l;
	m->m_par.t_ptr = p;
	if(m->m_type == T_MACRO)
		{
		m->m_rdr.l_ptr = &m->m_chain;
		m->m_rdr.l_length = m->m_len & 0377;
		clear(m->m_pars, LSIZE * 9);
		m->m_n = 0;
		if(l)
		    get_pars(start,m);
		}
	if(*ptr_1 == '!' || *ptr_1 == '|')
	    ++ptr_1;
	rem_append(m,ptr_1,len - (ptr_1 - buff_1));
	m->m_next = rd_next;
	rd_next = m; 
	m->m_sw = ON;            /* macro now in use */
	if(m->m_type == T_FN)
		{
		fn_ptr = p;
#ifdef FNLOAD
		if(m->m_fn == 0)
			if((m->m_fn = load_fn(m->m_fname)) == 0)
				{
				err("loading system function");
				goto bad_macro;
				}
#endif
		n = (*m->m_fn) (m->m_par.t_ptr,m->m_par.t_length,m) ;
		if (n != OK && n != FAIL && sw_error)
			err("function error - level %d",n);
		}
	++macs_use[m->m_type];
	ptr_1 = buff_1;
	buff_1[0] = 0;
	len = 0;
	return(OK);
	}
bad_macro:
ptr_1 = old;
return(FAIL);
}
 
struct macro *mac_fetch()
{
/*
 * routine to look up a macro or other macro type name. 
 */
register struct macro *m;
register struct cc *cc;
 
if(m = find_macro(mac_name))
	return(m);
if(v_lib && (*v_lib) (mac_name))
	return(find_macro(mac_name));
if (cc = is_cc(mac_name))
	{
	m = fn_cc;
	m->fn_work[0] = cc;
	cc_no = ON;			/* assume ON for now */
	return(m);
	}
return(0);
}
 
ccfn(param,plength,mac) char *param; struct macro *mac;
{
/*
 * take the parameter list and build a control card from 
 * the macro name and the argument list and then execute.
 */
if (plength > 0)
	--plength;		/* trim trailing ) */
sprintf(buff_1,"%s %.*s",mac_name,plength,param);
ptr_1 = buff_1 + strlen(mac_name);
DEBUGF(("ccfn: '%s'\n",buff_1));
sw_dlist = ON;
cc_process(mac->fn_work[0]);	/* process it */
}
 
par_expand()
{
/*
 * scan the input buffer for a macro parameter reference.
 * expand the parameters found. 
 */
 
register char *p;
register char *q;
register struct macro *m;
int l;
int n;
 
m = rd_next;
if( m == 0)
	return(FAIL);
while (m->m_type != T_MACRO)
	{
	m = m->m_next;
	if(m == 0)
		return(FAIL);
	}
 
p = buff_1;
if (*p == NOEXPAND)
	{
	*p = ' ';
	return(FAIL);
	}
q = temp;
while (*p)
	{
	if( ! (( *p == '!' || *p == '|') &&
		(eq(p+1,"par.") || eq(p+1,"PAR.") ) &&
		(p[5] >= '0' && p[5] <= '9') ))
		{
		if(q < &temp[MAXBUFF])
			*q++ = *p++;
		else
			return(FAIL);
		}
	else
		{
		n = p[5] - '0' - 1;
		p += 6;
		if(*p == '!' || *p == '|')
			++p;
		l = m->m_pars[n].l_length;
		if(p + l > &temp[MAXBUFF])
			return(FAIL);
		move(l,m->m_pars[n].l_ptr,q);
		q += l;
		}
	}
*q = 0;
DEBUGF(("expanded '%s' to '%s'\n",buff_1,temp));
move(len = q-temp,temp,buff_1);
return(OK);
}
 
 
mac_read()
{
/*
 * read the next line from a macro or function.
 */
register struct macro *m;
register struct line *p;
register l;
 
m = rd_next;
p = m->m_rdr.l_ptr;
if(p != 0)
	{              /* there is text on the text chain. */
	l = m->m_rdr.l_length;
	move(l,p->l_text,buff_1);
	m->m_rdr.l_length = p->l_length;
	m->m_rdr.l_ptr = p->l_ptr;
	++gen_cnt;
	}
else
	{
	p = m->m_rem.l_ptr;
	if(p != 0)
		{
		l = m->m_rem.l_length;
		move(l,p->l_text,buff_1);
		m->m_rem.l_length = p->l_length;
		m->m_rem.l_ptr = p->l_ptr;
		rfree(p);
		if(m->m_rem.l_ptr == 0)
			pop_input();
		else
			++gen_cnt;
		}
	else
		{
		l = 0;
		pop_input(); 
		}
	}
len = l;
buff_1[l] = 0;
if(l != 0)
	par_expand();
}
 
pop_input()
{
/*
 * pop the macro stack.
 */
register struct macro *m;
 
m = rd_next;
if(m == 0)
	error("macro stack underflow");
m->m_sw = OFF;               /* no longer in use */
if(m->m_par.t_ptr)
	pfree(m->m_par.t_ptr);
m->m_par.t_ptr = 0;
rd_next = m->m_next;
if (m->m_type == T_INCLUDE)
	clsinclude();
}
 
 
push_input()
{
/* stack current input line onto input stack. used by cc
 * routine to recover from input line error and to reprocess
 * a macro define lookahead. 
 */
 
rd_again.m_sw = sw_dlist;
rd_again.m_next = rd_next;
rd_next = &rd_again;
rd_again.m_type = T_AGAIN;
}
 
cvtnn()
{
/*
 * convert the following 2 digits into a decimal number. 
 * return 0 if any problem. 
 */
 
register int num;
register char c;
 
c = *ptr_1;
if(DIGIT)
	{
	num = c-'0';
	c = *++ptr_1;
	if(DIGIT)
		{
		num = num * 10 + c - '0';
		++ptr_1;
		}
	}
return(num);
}

cvthex()
{
/*
 * convert the following 2 digits into a hexadecimal number. 
 * return 0 if any problem. 
 */
 
register int num;
register char c;
 
c = *ptr_1;
if ((num = nibble(c)) < 0)
	return(0);
c = *++ptr_1;
c = nibble(c);
if (c <= 0)
	return(0);
num = (num << 4) + c;
	++ptr_1;
return(num);
}
 
nibble(ch)
{
/*
 * convert hexadecimal digit
 */
register char c;

c = ch;
if ('A' <= c && c <= 'F')
	c -= 'A'-10;
else if ('0' <= c && c <= '9')
	c -= '0';
else if ('a' <= c && c <= 'f')
	c -= 'a'-10;
else
	c = -1;
return(c);
}


 
rem_append(m,buff,l)
struct macro *m;
char *buff;
{
/*
 * append text pointed to by "buff" of length "l" onto the
 * macro "m". space is allocated for that entry via
 * ralloc for the first entry and alloc for the 
 * rest. 
 */
register struct line *q;
register struct line *t;
register struct line *p;
 
q = &m->m_rem;
if(q->l_ptr == 0)
	{
	t = (struct line *) ralloc(l + LSIZE);
	if (t == NULL)
		nospace("rem_append");
	move(l,buff,t->l_text);
	q->l_ptr = t;
	q->l_length = l;
	t->l_ptr = 0;
	t->l_length = 0;
	return;
	}
while (q->l_ptr)
	{
	p = q;
	q = q->l_ptr;
	}
/*
 * insert new text into the chain just before the last entry. 
 * at this point q points to the last entry and p points
 * to the previous one. 
 */
t = (struct line *) alloc(l + LSIZE);
if (t == NULL)
	nospace("rem2");
move(l,buff,t->l_text);
t->l_ptr = p->l_ptr;
t->l_length = p->l_length;

p->l_ptr = t;
p->l_length = l;
}
 
struct macro *mac_create(name,type,buff,l)
char *name, *buff;
{
/*
 * create a macro prototype with initial text defined
 * by "buff" of length "l". 
 */
register struct macro *m;
register struct mac *mac;

if(m = find_macro(name))
	mac_delete(name);
 
for (ALLMACS)
	{
	if(mac -> m_name == 0)
		{
		if ((mac->m_name = alloc(length(name)+1)) == NULL)
			nospace("macro");
		copy(mac->m_name,name);
		if ((mac->m_ptr = m = (struct macro *) alloc(MSIZE + l)) == NULL)
			nospace("mac_create");
		clear(m,MSIZE);
		move(l,buff,m->m_text);
		m->m_type = type;
		m->m_len = l; 
		++mac_cnt;
		if (mac > last_mac)
			last_mac = mac;		/* remember last one */
		return(m);
		}
	}
error("out of macro table space");
/*NOTREACHED*/
}
 
mac_purge(m) register struct macro *m;
{
 
free_chain(&m->m_chain);
free_chain(&m->m_rem);
free(m);
}
 
mac_delete(name)
char *name;
{
register struct mac *mac;
 
for(MACROS)
	{
	if(mac->m_name && equal(mac->m_name,name))
		{
		--mac_cnt;
		mac_purge(mac->m_ptr);
		free(mac->m_name);
		mac->m_name = 0;
		mac->m_ptr = 0;
		if (mac == last_mac)
			--last_mac;
		return;
		}
	}
}
 
 
 
struct macro *find_macro(name) register char *name;
{
/*
 * routine to look up macro name in the macro table. 
 */
register struct mac *mac;
 
for(MACROS)
	if(mac->m_name && mac->m_name[0] == name[0] && equal(mac->m_name,name))
		return(mac->m_ptr);
return((struct macro *) NULL);
}
 
 
free_chain(cp)
register struct line *cp;
{
register struct line *l;
register struct line *p;
 
if( (l = cp) == 0)
	return;
l = l->l_ptr;
while (p = l)
	{
	l = p->l_ptr;
	free(p);
	}
cp->l_ptr = 0;
cp->l_length = 0;
}
 
 
mac_clear()
{
/*
 * remove all macro definitions. 
 */
register struct mac *mac;
 
for (MACROS)
	if(mac->m_name)
		mac_delete(mac->m_name);
last_mac = macros;
pinit();			/* initialize palloc */
}
 
 
get_str(buff,length)
char *buff;
{
/*
 * scan off a quoted string from the input buffer. 
 * string is returned into "buff". if any error is
 * found -1 is returned. 
 * on input it is assumed ptr_1 points at the first quote.
 */
 
register char *p, *q;
register char c;
int l;
p = ptr_1; 
q = buff; 
l = 0;
if(*p++ != QT)
	 goto bad;
while (c = *p++) 
	 { 
	 if(c != QT) 
		{
		 if(++l < length)
			 *q++ = c; 
		}
	 else 
		 if((c = *p++) == QT) 
			{
			 if(++l < length)
				 *q++ = c; 
			}
		else
			{
			ptr_1 = p - 1;
			return(l);
			}
	}
bad:
ptr_1 = p-1;
return(-1);
}
 
 
 
scan_pars()
{
/*
 * called to scan the parameter list of a macro or function. 
 * it merely finds the end of the list and thus the caller 
 * may determine how much space must be allocated for the 
 * parameters. 
 */
 
for (EVER)
	{
	switch(*ptr_1++)
		{
	case QT:
		--ptr_1;
		if(get_str((char *) NULL,0) < 0)
			goto bad_scan;
		break;
 
	case ',':
		break;
 
	case ' ':
	case NULL:
		goto bad_scan;
 
	case ')':
		return(OK);
 
	default:
		--ptr_1;
		if(scan_word((char *) NULL,0) < 0)
			goto bad_scan;
		break;
		}
	}
 
bad_scan:
--ptr_1;           /* back to bad character */
return(FAIL);
}
 


scan_word(buff,length)
char *buff;
{
/*
 * a routine to scan off a word that is allowed as an unquoted 
 * macro parameter. 
 * result is -1 if error found and length of the word that 
 * has been placed into "buff" (unless buff==0). 
 */
 
register char *q;
register char c;
register int l;
int level;
 
l = 0;
level = 0;
q = buff;
 
for (EVER)
	{
	switch(c = *ptr_1++)
		{
	case '(':
		++level;
		break;
 
	case ',':
		if(level==0)
			{
		done:
			--ptr_1;
			return(l);
			}
		break;
 
	case ')':
		if(--level < 0)
			goto done;
		break;
 
	case ' ':
	case NULL:
		--ptr_1;
		return(-1);
 
		}
	if(l++ < length)
		*q++ = c;
	}
}
 
 
get_pars(buff,m)
char *buff;
struct macro *m;
{
/*
 * routine to decode the parameters of a macro, setting up the
 * appropriate pointers in the macro itself.
 */
 
register int i;
register char *q;
register int l;
char *old;
 
q = m->m_par.t_ptr;
old = ptr_1;            /* just in case */
ptr_1 = buff;           /* reset to start of parameter list */
for (i=0; i<9; ++i)
	{
	switch( *ptr_1++ )
		{
	case QT:
		--ptr_1;
		l = get_str(q,MAXBUFF); 
	got_par:
		m->m_pars[i].l_ptr = q;
		m->m_pars[i].l_length = l;
		q += l;
		if(*ptr_1 == ',')
			++ptr_1;                 /* normal separator */
		break;
 
	case ',':
		break;
 
	case ')':
	done:
		m->m_n = i;
		DEBUGF(("get_pars got %d parameters '%.*s'\n",i,ptr_1-old,old));
		ptr_1 = old;
		return;
 
	default:            /* must be safe as scan_par worked */
		--ptr_1;
		l = scan_word(q,MAXBUFF);
		goto got_par;
		}
	}
goto done;              /* already got 9 parameters */
}

mac_append(m,buff,length)
struct macro *m;
char *buff;
{
/*
 * add the given buffer (of length "length") onto the macro 
 * text chain starting at "m_chain".
 */
register struct line *p, *q;
register int l;

l = length;
p = &m->m_chain;
while (q = p->l_ptr)
	p = q;

q = (struct line *) alloc(l + LSIZE);
if (q == NULL)
	nospace("mac_append");
q->l_ptr = 0;
q->l_length = 0;
p->l_ptr = q;
p->l_length = l;
move(l,buff,q->l_text);
}

fn_init()
{
/*
 * initialize the functions in the macro table. 
 */
register struct fntab *f;
struct fn fn;

clear(&fn,sizeof fn);
for (f = fntab; f->fn_name; ++f)
	{
	move(8,f->fn_name,fn.fname);
	fn.faddr = f->fn_addr;
	fn_cc = mac_create(f->fn_name, T_FN, &fn, sizeof fn);
	}
}

/*ARGSUSED*/
def_fn(name,file,fname) char *name, *file, *fname;
{
/*
 * load and function and define it from the file "file".
 * the entry point name is "fname".
 */
register struct fntab *f;
struct fn fn;

clear(&fn,sizeof fn);
for (f = fntab; f->fn_name; ++f)
	{
	if (equal(f->fn_name,fname))
		{
		move(8,f->fn_name,fn.fname);
		fn.faddr = f->fn_addr;
		mac_create(name, T_FN, &fn, sizeof fn);
		return;
		}
	}
ccerr("unknown entry name");
}
