#include <stdio.h>

#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "fmtmac.h"
#include "fmthold.h"
 
int srcline;		/* source line number */

char types[MAXCHAR];

FILE *standin;		/* standard input pointer */
FILE *include;

#define T_blank 0
#define T_null 1
#define T_dash 2
#define T_at   3
#define T_uchar 4
#define T_ntb 5
#define T_tab 6
#define T_excl 7
#define T_slash 8
#define T_rpar 9
#define T_junk 10
 
char typecodes[] IS
{
'-',	T_dash,
'@',	T_at,
UCHAR,	T_uchar,
'~',	T_ntb,
HT,	T_tab,
'!',	T_excl,
'|',	T_excl,
'/',	T_slash,
')',	T_rpar,
' ',	T_blank,
NULL,	T_null,
};

scan()
{
/*
 * Scans the input buffer, copying text into buff_2 and 
 * switching out to routines to handle macro and command
 * operands. 
 */
 
register char c;
 
for(EVER)
	{
	if(sw_v)
		do_ccs();
	switch(types[c = *ptr_1++])
		{
	case T_blank:
		if(ptr_2 != buff_2)
			word_end(WORD_END);
		break;
 
	case T_null:			/* get next input line */
		read_line();
		break;
 
	case T_dash: 			/* if followed by text break the word */
		if(!sw_hyph || types[*ptr_1] != T_junk)	
			goto normal;
		putch(c);
		word_end(WORD_HYPHEN);
		break;

	case T_at:
		c = *ptr_1;
		if(c = SUPER(c))
			++ptr_1;
		else
			c = ptr_1[-1];           /* restore @ sign */
		goto normal;
 
	case T_uchar:
		if (sw_u)
			*ptr_2++ = UNDER(' ');
		else if(ptr_2 > buff_2)
			{
			c = ptr_2[-1];
			ptr_2[-1] = UNDER(c);
			}
		break;
 
 
	case T_ntb:
		if(sw_u && sw_under)
			*ptr_2++ = '_';
		else
			*ptr_2++ = NTB;
		sw_ncap = OFF;
		break;
 
 
	 case T_tab:
		co_tabs(0,NTB);
		break;
 
 
 
	case T_excl:			/* for ! or | pass to macro routine */
		if (c == *ptr_1)
			++ptr_1;	/* !! or || just return ! or | */
		else
			macros_etc();
		break;
 
	case T_slash:
		if(sw_super)
			{
			if (*ptr_1 == '/')
				++ptr_1;
			else
				{
				co();
				break;
				}
			}
		goto normal;
 
	case T_rpar:
		if(ptr_2 == buff_2 && *ptr_1 != ' ')
			{
			co();               /* at start of line etc */
			break;
			}
		else
			goto normal;
 
	default:
	normal:
		/*
		 * output character "c" into intermediate buffer 
		 * this should be an exact copy of the putch code 
		 * placed in line for efficiency. 
		 */
		 if(sw_at || sw_ncap || (sw_f && ptr_2 == buff_2))
			{
			UPPER(c);
			sw_ncap = OFF;
			}
		 if(sw_u) 
			c = UNDER(c);
		 *ptr_2++ = c; 
		 if(ptr_2 >= buff_2 + MAXBUFF)
			error("internal buffer overflow!");
		 break; 
		}
	}
}
 
 
putch(c)
char c;
{
/*
 * output character "c" into intermediate buffer 
 */
if(sw_at || sw_ncap || (sw_f && ptr_2 == buff_2))
	{
	UPPER(c);
	sw_ncap = OFF;
	}
if(sw_u) 
	c = UNDER(c);
*ptr_2++ = c; 
if(ptr_2 >= buff_2 + MAXBUFF)
	error("internal buffer overflow!");
}
 
 
word_end(flag)
{
 
/*
 * called at the end of a word to transfer that word into 
 * buff_3 from buff_2 where it has been assembled. 
 * the current contents of buff_3 are flushed if the word won't
 * fit.
 * flag
 * WORD_END	normal end of word
 * WORD_HYPHEN	hyphen present (no interword space)
 * WORD_CHYPHEN	conditional hyphen present
 */
 
register l; 
register char *o;
register int i;
char c;
 
l = ptr_2 - buff_2;          /* length of string in buff_2 */
if(l == 0)
	return;

++word_cnt;
 
o = ptr_3 + l;
if(o > end_3)
	{
	put_line();
	o = ptr_3 + l;
	if(o > end_3)
		{		/* if it still overflows the line - chop it */
		o = end_3;
		l = o - ptr_3;
		}
	}
 
move(l,buff_2,ptr_3);
 
c = o[-1];
c = NOUNDER(c);
sw_ncap = sw_cap && ( c == '.' || c == '?' || c == '!');
if (c == 'i' && l == 1 && sw_cap && flag==WORD_END)
	o[-1] = 'I';		/* convert to upper case I */
if(sw_ncap)
	for (i=1; i<sent_space; ++i)
		*o++ = NTB;
if(word_space && flag==WORD_END)
	{
	*o++ = ' ';
	for (i = 1; i < word_space; ++i)
		*o++ = NTB;
	}
if (flag == WORD_CHYPHEN)
	--o;		/* remove the conditional hyphen */
ptr_3 = o;
ptr_2 = buff_2;
sw_nl = sw_np = OFF;
}


put_line()
{
/*
 * routine to output a line that has overflowed.
 */

if (*ptr_3 == '-')
	++ptr_3;		/* insure hyphen is there */
if(sw_m)
	 center();
else
	 {
	 if(sw_just)
		 justify();
	 }
prntline();
}

 
read_in()
{
/*
 * routine to read another line into the input buffer.
 * actual input source depends upon what sort of entity
 * is actully on the input stack. 
 */
 
sw_dlist = OFF;
ptr_1 = buff_1;

do
	 {
	 if(rd_next == 0)
		{			/* input is from standard input */
		mac_ind = ' ';
		while(input(standin) < 0)
			eof();
		 ++read_cnt;
		if (srcline == 0)
			srcline = line;
		 if(len > card_max)
		    {
		    buff_1[card_max] = 0;
		    len = card_max;
		    }
		if (sw_gene)
			{
			copy(buff_1+len," )l ");
			len += 4;
			}
		if(!sw_keyp)
			 lctran(buff_1);
		ptr_1 = buff_1 + card_min -1;
		break;
		}
	 else
		{
		switch(rd_next->m_type)
			{
		case T_INCLUDE:
			mac_ind = '*';
			if(input(include) < 0)
			     pop_input();
			else
				++in_cnt;
			break;
 
		case T_MACRO:
		case T_FN:
			mac_ind = '+';
			mac_read();
			break;
		case T_AGAIN:
			pop_input();
			sw_dlist = rd_again.m_sw;
			break;
			}
		}
	}
while (len == 0);
buff_1[len] = 0;
ptr_1 = buff_1;
}
 
 
 
ptr_calc()
{
/*
 * recalculate the buffer pointers after possible change.
 */
min_3 = buff_3 + text_col;      /* minimum text column */
max_3 = min_3 + col_width;
start_3 = min_3 + i_left + h_left;
end_3 = max_3 - i_right - h_right ;
if(start_3 + 10 > end_3)
	{
	err("effective column width (%d) too small",end_3-start_3);
	i_left = i_right = h_left = h_right = 0;
	start_3 = min_3;
	end_3 = max_3;
	}
}
 
 
 
 
justify()
{
 
/*
 * justify the text in buff_3 starting at "start_3" up to 
 * ptr_3. 
 */
 
register char *p, *q;
register int i;
int left, spaces, cnt, lr_sw;
 
p = ptr_3-1;
while(*p == ' ')
	--p;
if(sw_ncap)
	while (*p == NTB)
	    --p;
ptr_3 = ++p;

if((left = end_3 - ptr_3) <= 0)
	return;
spaces = 0;
for (p = start_3; p < ptr_3;)
	if(*p++ == ' ')
		++spaces;
if(spaces == 0)
	return;
cnt = left/spaces + 1;           /* # of blanks needed between words */
lr_sw = left%spaces;            /* number of places needing 1 more */
if(cnt == 1 && lr_sw == 0)
	return;                  /* all done automatically */
if(!( sw_scan = !sw_scan ))
	++cnt;
else
	lr_sw = spaces - lr_sw;
 
q = end_3;
for (p = ptr_3; p > start_3; )
	{
	if(*--p == ' ')
		{
		if(lr_sw-- == 0)
			if(!sw_scan)
			     --cnt;
			else
			     ++cnt;
		for (i=0; i<cnt; ++i)
			*--q = ' ';
		}
	else
		*--q = *p;
	}
ptr_3 = end_3;
}
 
skip(flag)
{
/*
 * do a page skip, taking care of footers, footnotes, titles
 * subtitles, page number conversions etc. 
 * flag indicates the reason for the skip (NORMAL, END, or START).
 */
register int i;
 
if(cur_hold)
	{
	err("attempt to page skip inside %s",cur_hold->h_name);
	end_hold();
	return;
	}
col_dump();			/* catch up with columns */
if (flag != START)
	{
	dump_fn(flag);
	hold_out(sw_rt ? &r_footer : &l_footer);	/* output footer */
	}
if(flag == END)
	{
	while (i = figure.h_cnt)
		{
		err("unprinted %d line figure being flushed out",i);
		hold_out(&figure);	/* output all the held figures */
		}
	return;
	}
eject();
cvt_page();
cnt_line = physline = 1;
if(sw_cycle)
	sw_rt = ! sw_rt;
hold_out(sw_rt ? &r_title : &l_title);
hold_out(&sub_title);
to_line(text_line);
if(figure.h_cnt)
	fig_test();
col_eject();			/* start new page */
sw_np = ON;
}
 
 
to_line(n)
{
/*
 * output blank lines til line "n". Used to get to the proper
 * line for a text hold. 
 */
while (physline < n)
	{
	fmt_put(" ",1);
	++cnt_line;
	}
}
 
 
prntline()
{
/*
 * output the current contents of buff_1 to the current 
 * output sink (printer or text hold). 
 */
register int i;

 
for (i=0; i<spacing; ++i)
	{
	if(boxcnt)
		boxline();
	if(ptr_3 < maxb_3)
		ptr_3 = maxb_3;
	maxb_3 = 0;
	if(cur_hold && put_hold())
		;
	else
		{
		if(cnt_line > eff_max)
			cskip();                 /* to a new column */
		print();
		++cnt_line;
		if (cnt_line > eff_max)
			cskip();		/* to new column or page */
		if(figure.h_cnt)
			fig_test();
		}
	if (ptr_3 > buff_3)
		set(buff_3,ptr_3-buff_3,NTB);	/* only do it if needed */
	SETPTRS;
	sw_np = OFF;
	}
}
 
 
print()
{
/*
 * routine to output a line to main output. 
 */
register int l = ptr_3 - buff_3;
 
sw_nl = ON;
if(sw_v2)
	{
	if(text_col > 1)
		buff_3[text_col-1] = '|';
	 sw_v2 = sw_vers;
	}
if (sw_numb)
	putnumb();		/* output src line # */
if (l < 0 && l > -256)
	l = 0;		/* it should be ok */
if (l < 0 || l > MAXBUFF)
	error("invalid buffer length");
out_put(buff_3,l);
}
 
cvt_page()
{
/*
 * convert the page number and store proper pointers.
 */
register int n;
register char *p;
 
page.p_old = n = page.p_page;
page.p_oline = page.p_line;
for (p = page.p_out + PAGE_SIZE; p > page.p_out; )
	{
	if(n == 0)
		break;
	*--p = n%10 + '0';
	n /= 10;
	}
page.p_addr = p;
page.p_len = (page.p_out+PAGE_SIZE) - p;
while (p > page.p_out)
	*--p = ' ';
if(v_page)
	{
	page.p_addr = page.p_out;
	page.p_len = (*v_page) (page.p_addr, page.p_page);	/* convert it */
	}
page.p_page += page.p_incr;		/* increment page number */
page.p_y = text_col + 
		 ( sw_rt ? width - page.p_len - page.p_disp : page.p_disp);
page.p_osw = page.p_sw;
++page_cnt;                  /* total pages printed */
}
 
 
list()
{
do_list(NL);
}
 
 
init()
{
/*
 * do primary initializations required only once at start 
 * of an FMT run. 
 */
 
sw_save = OFF;
hold_init();		/* initialize text holds */
}
 
 
init_job()
{
/*
 * re-initialize for the first (or next) job. 
 */
 
register int i;
 
 
init_ccs();             /* init cc set variables */
init_co();		/* do command operand inits */

for (i=0; i<MAXHOLD; ++i)
	h_clear(holds[i]);	/* clear current holds */
 
if(! sw_save)
	{
	mac_clear();
	fn_init();	/* initialize function definitions */
	}
for (i=0; i<MAXCHAR; ++i)
	{
	intrans[i] = outtrans[i] = i;
	undtrans[i] = '_';
	}
}


init_co()
{
/*
 * perform initializations related to command operands. 
 * Done at beginning of each FMT "job". 
 */
register char c;
register char *p;


len = 0;
v_page = NULL;			/* reset page function */
page.p_incr = 1;		/* page number increment */
clear(buff_1,MAXBUFF);
clear(buff_2,MAXBUFF);
clear(counters,sizeof counters);
set(buff_3,MAXBUFF,NTB);
ptr_1 = buff_1;
ptr_2 = buff_2;
ptr_calc();
SETPTRS;
drop_char = '.';
sw_scan = OFF;
sw_nl = sw_np = ON;
set(types,sizeof types,T_junk);
p = typecodes;
do
	{
	c = *p++;
	types[c] = *p++;
	}
while (c);

boxcnt = 0;		/* no boxes in use */
clear(boxsws, sizeof boxsws);
clear(boxflags, sizeof boxflags);
}

line_calc()
{
/*
 * calculate the effective last line of the page. 
 */

eff_max = line_max - (sw_rt ? r_footer.h_cnt : l_footer.h_cnt)
	- footnote.h_cnt;
if(eff_max < 5)
	{
	err("effective lines/page < 5");
	eff_max = line_max;
	}
}


putnumb()
{
/*
 * output source line number corresponding to start of the line.
 */
register char *p;
register int k;

ptr_3 = p = max_3 + 5;		/* past end of line */
for (k=srcline; k; )
	{
	k = ldiv(0,k,10);
	*--p = ldivr+'0';
	}
srcline = 0;
}

dump_fn(flag)
{
/*
 * dump out the footnotes, if there is room.
 * dump unconditionally if flag == END.
 */
if (flag == END || cnt_line <= eff_max+1)
	{
	counters[0] = counters[1] = 0;
	hold_out(&footnote);
	}
}
