#

#ifndef RT11

#include <stdio.h>

#include "fmt.h"
#include "fmtmac.h"

#define	MAXENTRY	256	/* maximum entry in table */

char *con_cmds[] IS
{
"init", "gene", "pad", "on", "off", "long", "shor", "real", 
"virt", "roma", "alph", "name", "inte", 0};

int i_cvt();
int alpha();
int roman();
int name();

struct cnts
{
int maxlevel;
int nlines;
FILE *file;
char virtual;
char disable;
char _short;
char padch;
int padlen;
int (*cvt)();
char tempfile[20];
int maxlen;		/* maximum length of data entry found so far */
} ;
#define	SHORT_LIMIT	60	/* maximum length for short line */

/*ARGSUSED*/
contents(param,plength,mac) char *param; struct macro *mac;
{
register struct cnts *cnts;
int i;
register int l;
register int j;
char prefix[64], postfix[64];
char entry[MAXENTRY];
char word[5];
int level;
char pageno[20];
char padstr[64];
int n;
 
 
/*
 * contents function ... see the writeup for details.
 */
 
/* ### "contents.c", line 58: warning: illegal member use: fn_work @@@ */
if ((cnts = (struct cnts *) mac->fn_work[0]) == NULL)
	{			/* initialize the data areas */
/* ### "contents.c", line 60: warning: illegal member use: fn_work @@@ */
/* ### "contents.c", line 60: warning: illegal pointer combination @@@ */
	mac->fn_work[0] = cnts = (struct cnts *) malloc(sizeof (struct cnts));
	if (cnts == (struct cnts *) NULL)
		nospace("contents");
	clear(cnts,sizeof (struct cnts));
	cnts->virtual = 1;
	cnts->cvt = i_cvt;
	cnts->padch = '.';
	cnts->padlen = 1;
	cnts->maxlen = 0;
	cnts->_short = 1;
	mktemp(cnts->tempfile);	/* get temp file name */
	if ((cnts->file = fopen(cnts->tempfile,"w")) == NULL)
		err("can't open %s",cnts->tempfile);
	}
if (! (*fn_ptr == QT || ('1' <= *fn_ptr && *fn_ptr <= '9')))
	goto do_cmd;
l = fn_par(entry,sizeof entry);
if (l < 0)
	{
	err("contents: invalid parameter");
	return(FAIL);
	}
entry[l] = 0;
if (cnts->maxlen < l)
	cnts->maxlen = l;
fn_int(&level);
if(level == 0)
	level = 1;
if (level > cnts->maxlevel)
	cnts->maxlevel = level;
fn_str(prefix, sizeof prefix);
fn_str(postfix, sizeof postfix);
l = fn_str(pageno, sizeof pageno);

++cnts->nlines;
if (l <= 0)
	{
	if (cnts->virtual)
		l = (*cnts->cvt)(pageno,page.p_page-1);
	else
		move(l = page.p_len,page.p_addr,pageno);
	}
pageno[l] = 0;
i=cnts->padlen-l;
for (j=0; j < i; ++j)
	padstr[j] = cnts->padch;
padstr[j] = 0;
if (!cnts->disable)
	fprintf(cnts->file," !c%d(' %s %s %s','%s%s') \n",
		level,prefix,entry,postfix,padstr,pageno);
return(OK);

do_cmd:

fn_word(word,sizeof word-1);
word[4] = 0;
switch(lookup(word,con_cmds))
	{
case 0:        /* init */
	if (cnts->nlines == 0)
		{
		err("contents: no entries");
		return(FAIL);
		}
	fn_f(")rv");

	fn_f("call stack(push,tabs)");
	fn_f("call stack(push,indents)");
	sprintf(temp,"tabs");		/* set tab stops */
	for (i=1; i<= cnts->maxlevel; ++i)
		sprintf(endstr(temp)," %d",2*i-1);
	sprintf(endstr(temp)," %d",width-4);
	fn_put(temp,length(temp));

	sprintf(temp,"indents (3,0) ");		/* set indent columns */
	for (i=0; i < cnts->maxlevel; ++i)
		sprintf(endstr(temp)," (%d,5)",3*i);
	fn_put(temp,length(temp));

	if (cnts->maxlen > SHORT_LIMIT && cnts->_short)
		{
		cnts->_short = 0;
		fn_f("comment: using LONG form since max length=%d",cnts->maxlen);
		}
	for (i=1; i <= cnts->maxlevel; ++i)
		{
		if (cnts->_short)
			fn_f("%cset c%d = ' )rft%d !par.1 )d%d-f !par.2 ' ",
				NOEXPAND,i,i,cnts->maxlevel+1);
		else
			fn_f("%cset c%d = ' )lrfi%dh1 !par.1 )-i-hd%d-f !par.2 ' ",
				NOEXPAND,i,i+1,cnts->maxlevel+1);
		}
	fn_f("go");
	break;
 
case 1:             /* generate */
	 fprintf(cnts->file,"!stack(pop,tabs)\n");
	 fprintf(cnts->file,"!stack(pop,indents)\n");
	 fprintf(cnts->file,"!unlink(%s)\n",cnts->tempfile);	/* get rid of file */
	 fn_f("!include(%s)",cnts->tempfile);
	 fclose(cnts->file);
	 cnts->file = NULL;
	 free(cnts);			/* free the work area */
/* ### "contents.c", line 164: warning: illegal member use: fn_work @@@ */
	 mac->fn_work[0] = NULL;
	 break;
case 2:			/* pad */
	if (fn_int(&n))
		cnts->padlen = n;
	else
		cnts->padlen = 1;
	if (fn_char(&n))		/* the pad character */
		cnts->padch = n;
	break;
case 3:			/* on */
	cnts->disable = OFF;
	break;
case 4:
	cnts->disable = ON;
	break;
case 5:			/* long */
	cnts->_short = OFF;
	break;
case 6:			/* _short */
	cnts->_short = ON;
	break;
case 7:			/* real */
	cnts->virtual = OFF;
	break;
case 8:			/* virtual */
	cnts->virtual = ON;
	break;
case 9:			/* roman */
	cnts->cvt = roman;
	break;
case 10:		/* alpha */
	cnts->cvt = alpha;
	break;
case 11:		/* name */
	cnts->cvt = name;
	break;
case 12:		/* integer */
	cnts->cvt = i_cvt;
	break;
case -1:		/* invalid option */
	err("contents: bad option %.4s",word);
	break;
default:
	err("contents: option %.4s not implemented",word);
	break;
        }
return(OK);
}

lookup(word,cmds) char *word, **cmds;
{
register int i;
register char *s;

for (i=0; s = cmds[i]; ++i)
	if (equal(s,word))
		return(i);
return(-1);
}

struct stktab
{
char *s_name;
char *s_addr;
int s_size;
struct sdata *s_ptr;
} stktab[] IS
#define	S(name,value) name,(char *) &value,sizeof value,NULL ,
{
S("column",col_num)	/* current column number */
S("columns",columns)
/* ### "contents.c", line 236: warning: & before array or function: ignored @@@ */
S("indents",indents)
S("line",cnt_line)
S("page",page.p_page)
S("space",spacing)
S("sw.at",sw_at)
S("sw.cont",sw_cont)
S("sw.f",sw_f)
S("sw.m",sw_m)
S("sw.page",page.p_sw)
S("sw.right",sw_rt)
S("sw.u",sw_u)
/* ### "contents.c", line 247: warning: & before array or function: ignored @@@ */
S("tabs",tabs)
S("width",width)
/* ### "contents.c", line 249: warning: & before array or function: ignored @@@ */
S("widths",widths)
NULL, NULL, NULL, NULL
};
struct sdata
{
	struct sdata *ptr;
	char data[DUMMYVEC];
	};

/*ARGSUSED*/
stack(param,plength,mac) char *param; struct macro *mac;
{
#define	POP	0
#define	PUSH	1
char word[10];
register struct sdata *t;
register struct stktab *p;
register int i;
struct sdata *q;

fn_word(word,sizeof word);
lctran(word);
if (equal(word,"push"))
	i = PUSH;
else if (equal(word,"pop"))
	i = POP;
else if (equal(word,"clear"))
	{
	for (p = stktab; p->s_name; ++p)
		{
		for (t = p->s_ptr; t ; t = q)
			{
			q = t->ptr;
			free((char *) t);
			}
		p->s_ptr = NULL;
		}
	return(OK);
	}
else
	{
	err("stack: invalid option");
	return(FAIL);
	}
fn_word(word,sizeof word);
for (p = stktab; p->s_name; ++p)
	{
	if (equal(word,p->s_name))
		{
		if (i==POP)
			{		/* pop ... copy and remove from list */
			if ((t = p->s_ptr) != NULL)
				{
				move(p->s_size,t->data,p->s_addr);
				p->s_ptr = t->ptr;
				free(t);
				}
			else
				{
				err("stack: underflowed");
				return(FAIL);
				}
			}
		else
			{		/* push ... link into list */
			t = (struct sdata *) malloc(p->s_size + (sizeof (struct sdata)) - DUMMYVEC);
			if (t == (struct sdata *) NULL)
				nospace("stack");
			t->ptr = p->s_ptr;
			move(p->s_size,p->s_addr,t->data);
			p->s_ptr = t;
			}
		return(OK);
		}
	}
err("invalid table name");
return(FAIL);
}
#endif	/* RT11 */
