#

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} statb ;
int hdr[8];
char filename[16];
char libname[32];
#define OLDMAGIC 0177555
#define	ARMAGIC	0177545
int magic;
int fflg;
int cflg;
int dflg 1;		/* give definitions */
int rflg 1;		/* give references */
int sflg 1;		/* suppress .o in file names */
int sym[6];
int in;

main(argc,argv) char **argv;
{
register char *p;
register char *argp;
int i;
int n;
extern fout;

fout = dup(1);
for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (argp[0] == '-')
		switch(argp[1])
			{
		case 's':		/* suppress .o in file names */
			sflg = !sflg;
			continue;
		case 'r':		/* don't print definitions  */
			dflg = !dflg;
			continue;
		case 'd':		/* don't print references */
			rflg = !rflg;
			continue;
		case 'l':		/* library */
			copy(libname,"/mnt/lib/lib");
			append(libname,argp+2);
			append(libname,".a");
			argp = libname+4;
			if (stat(argp,&statb) < 0 && stat(argp-4,&statb) >= 0)
				argp =- 4;
			break;
		case 'f':		/* fortran symbols only */
			++fflg;
			continue;
		case 'c':		/* C symbols only */
			++cflg;
			continue;
		default:
			err("usage: %s [-f] [-c] [-d] [-l] file ...",argv[0]);
			}
	in = open(argp,0);
	if (in < 0)
		err("can't open %s",argp);
	if (read(in,&magic,2) == 2 && (magic == ARMAGIC || magic == OLDMAGIC))
		{
		while (gothdr())
			{
			argp = filename;
			refs(argp);
			}
		}
	else
		{
		seek(in,0,0);
		refs(argp);
		}
	close(in);
	}
flush();
}

refs(argp) char *argp;
{
register int n;
register char *p;

if (read(in,hdr,sizeof hdr) != sizeof hdr || hdr[0] != 0407)
	err("%s: not object",argp);
if (sflg == 0)
	for (p=argp; *p; ++p)
		if (*p == '.')
			*p = 0;
printf("%s:",argp);
seek(in,hdr[1]+hdr[2],1);
if(hdr[7] == 0)
	seek(in,hdr[1]+hdr[2],1);
n = hdr[4]/12;
while (--n >= 0 && read(in,sym,12) > 0)
	{
	p = sym;
	if (rflg && sym[4] == 040 && sym[5] == 0)
		if (cflg || fflg)
			{
			if (p[0] == '_' && (cflg || (p[1] >= 'a' && p[1] <= 'z')))
				printf(" %.7s",p+1);
			}
		else
			printf(" %.8s",p);
	if (dflg && (sym[4] == 042 || sym[4] == 043 || sym[4] == 044))
		if (cflg || fflg)
			{
			if (p[0] == '_' && (cflg || (p[1] >= 'a' && p[1] <= 'z')))
				printf(" =%.7s",p+1);
			}
		else
			printf(" =%.8s",p);
	}
printf("\n");
}

gothdr()
{
struct oar 
{
char a__name[8];
int a__time[2];
char a__uid;
#define	a__gid	a__uid	/* overlay onto uid */
char a__mode;
int a__size;
} oldar;
struct ar
{
char a_name[14];
int a_time[2];
char a_uid;
char a_gid;
int a_mode;
long a_size;
} ar;
if (magic == OLDMAGIC)
	{
	if (read(in,&oldar,sizeof oldar) <= 0)
		return(0);
	move(8,oldar.a__name,filename);
	filename[8] = 0;
	}
else
	{
	if (read(in,&ar,sizeof ar) <= 0)
		return(0);
	move(14,ar.a_name,filename);
	}
return(1);
}
