#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
#include "stmt.h"
#include "ops.h"
#include "tree.h"
#include "char.h"
/*			Copyright 1977 by Bill Webb.	 		*/

struct { char lo, hi; };
#define	READ_UNIT	5
#define	PRINT_UNIT	6
#define	PUNCH_UNIT	7

#define	YES	1
#define	NO	0

#define	O_NONE	0
#define	O_ENTRY	0
#define	O_FN	01000
#define	O_PARAM	02000
#define	O_IMP	02001
#define	O_SPEC	02002
#define	O_DATA	03000
#define	O_SF	03001
#define	O_EXEC	03002
#define	O_END	04000


char *sym_label;		/* symbol table pointer for current label */
char *symlabel;			/* removable label pointer */
int stmtorder[EXECUTEABLE+1]	/* non-executeable statements */
{
O_NONE,		/* no stmt */
O_FN,		/* function */
O_SPEC,		/* real */
O_SPEC,		/* integer */
O_SPEC,		/* complex */
O_SPEC,		/* logical */
O_SPEC,		/* common */
O_SPEC,		/* equivalence */
O_DATA,		/* data */
O_SPEC,		/* double */
O_SPEC,		/* external */
O_FN,		/* block */
O_ENTRY,	/* entry */
O_IMP,		/* implicit */
O_FN,		/* subroutine */
O_SPEC,		/* dimension */
O_FN,		/* program */
O_PARAM,	/* parameter */
O_SPEC,		/* character */
O_SPEC,		/* instrinsic */
O_END,		/* end stmt */
O_SF,		/* statement function */
O_EXEC,		/* executable */
0 };

process()
{
register char *t;
int i;

treep = 0;		/* start of statement */
savetext = textlast;		/* save if error */
tempcnt = 0;		/* number of temporaries used in stmt */
if (progtype == BLOCK && stmt >= EXECUTEABLE)
	ERR("executable statement in block data",E_BLOCK);
switch(stmt)
	{
case BLOCK_STMT:
	block();
	break;
case INTRINSIC_STMT:
	intstmt();
	break;
case ENTRY_STMT:
	entrystmt();
	break;
case FORMAT_STMT:
	format();
	break;
case DATA_STMT:
	datastmt();
	break;
case CHAR_STMT:
	typespec(CHARACTER);
	break;
case THEN_STMT:
	ERR("then not in block if",E_THEN);
case ELSE_STMT:
	elsestmt();
	break;
case ELSEIF_STMT:
	elseif();
	break;
case ENDIF_STMT:
	endif();
	break;
case EQUIV_STMT:
	equivstmt();
	break;
case PARAM_STMT:
	paramstmt();
	break;
case DO_STMT:
	dostmt();
	break;
case ASSIGN_STMT:
	assign();
	break;
case PROGRAM_STMT:
	prog();
	break;
case CLOSE_STMT:
	iofn(CLOSE_OP);
	break;
case REWIND_STMT:
	iofn(REW_OP);
	break;
case BACKSPACE_STMT:
	iofn(BCK_OP);
	break;
case ENDFILE_STMT:
	iofn(ENF_OP);
	break;
case READ_STMT:
	rwstmt(READ_OP,READ_UNIT,YES);
	break;
case WRITE_STMT:
/* case PRINT_STMT: */
	rwstmt(WRITE_OP,PRINT_UNIT,NO);
	break;
case PUNCH_STMT:
	rwstmt(WRITE_OP,PUNCH_UNIT,NO);
	break;
case END_STMT:
	endstmt();
	break;
case RETURN_STMT:
	retstmt();
	break;
case EXTERNAL_STMT:
	extstmt();
	break;
case SUB_STMT:
	subroutine();
	break;
case DIM_STMT:
	dimstmt();
	break;
case COMMON_STMT:
	common();
	break;
case CALL_STMT:
	call();
	break;
case IF_STMT:
	ifstmt();
	break;
case ASMT_STMT:
	asmt();
	if (treep->t_op == SF_OP)
		stmt = SF_STMT;
	break;
case REAL_STMT:
	typespec(REAL4);
	break;
case INT_STMT:
	typespec(intmode);
	break;
case DOUBLE_STMT:
	typespec(REAL8);
	break;
case LOGICAL_STMT:
	typespec(LOG2);
	break;
case COMPLEX_STMT:
	typespec(CMPLX8);
	break;
case CONTINUE_STMT:
	break;			/* null statement */
case IMPLICIT_STMT:
	implicit();
	break;
case GOTO_STMT:
	go();
	break;
case STOP_STMT:
	paustp(STOP_OP);
	break;
case PAUSE_STMT:
	paustp(PAUSE_OP);
	break;
case FN_STMT:
	function(NOTYPE);
	break;
case OPEN_STMT:
	openstmt();
	break;
case INQUIRE_STMT:
	inqstmt();
	break;
default:
	NOTE("unimplemented statement",E_NOTIMP);
	while (*inptr)
		++inptr;
	}
/*
 * check out statement ordering
 */
i = stmt;
if (i == FORMAT_STMT || i == CONTINUE_STMT || i == ENTRY_STMT)
	i = 0;
if (i > EXECUTEABLE)
	i = EXECUTEABLE;
i = stmtorder[i];
if (i)
	{
	if (i >= maxorder)
		maxorder = i;
	else if (i.lo != 0 || i.hi != maxorder.hi)
		WARNING("incorrect statement ordering",E_ORDER);
	}
}

expect(s) char *s;
{
if (!teststr(s))
	ERR1("%s expected",E_EXPECT,s);
}

list(fn,arg) int (*fn)();
{
/*
 * invoke "fn(arg)" for every element in the list.
 * return the number of them found.
 */
register int n;

n = 0;
while (*inptr)
	{
	if (optc(COMMA))
		{
		WARNING("extra comma ignored",E_COMMA);
		++inptr;
		continue;
		}
	(*fn)(arg);
	++n;
	if (!testc(COMMA))
		break;
	}
listcnt = n;
return(n);
}

plist(fn,arg) int (*fn)();
{
register int n;
expect("(");
n = list(fn,arg);
expect(")");
return(n);
}


puterr()
{
/*
 * put error code into statement list.
 */
textlast = savetext;
treep = node(ERR_OP,NULL,NULL);
stmtend();
}

stmtend()
{
/*
 * check that all of statement has been processed.
 * process do loop terminations etc.
 */
if (!goterr && *inptr)
	ERR("bad syntax",E_SYNTAX);
/*
 * put tree onto stmt list.
 */
putstmt();		/* put statement onto stmt chain */
/*
 * check for label in do label table.
 */
if (label[0])
	docheck();		/* check for end of do loop */
}

putstmt()
{
/*
 * output current statement tree pointed to by "treep"
 * to the statement chain.
 */
register char *t;

if (condcomp)
	{
	treep = 0;
	return;			/* no code generation */
	}
if (symlabel)
	{
	treep = node(LABEL_OP,symlabel,treep);
	symlabel = 0;
	}
if (treep)
	{		/* got some code generated */
	if(pflg)
		treeprint(treep);
	writetree();
	}
treep = 0;
if (textmax < textlast)
	textmax = textlast;
textlast = savetext = textbeg;
}

expectc(c) char c;
{
if (!testc(c))
	ERR1("%c expected",E_CEXPECT,c);
}
