#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "char.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"

double fltcvt();		/* conversion routine */
#define	BACKSLASH	'\\'
#define	INTLEN	2
#define	QINTLEN	4
#define	FLOATLEN	8

#define	START	0		/* initial state */
#define	SIGN	1		/* have gotten a sign */
#define	ILP	2		/* accepting digits for integer */
#define	DEC	3		/* got a decimal point, no digits yet */
#define	DLP	4		/* accepting fraction digits */
#define	EXP	5		/* got an exponent */
#define	ESN	6		/* got sign for exponent */
#define	ELP	7		/* accepting digits of exponent */
#define	BAD	8		/* error */
#define	ENDF	9		/* end of floating point number */
#define	ENDI	10		/* end of integer */

/*
 * input/state  START	SIGN	ILP	DEC	DLP	EXP	ESN	ELP
 */
char signsv[] { SIGN,	BAD,	ENDI,	BAD,	ENDF,	ESN,	BAD,	ENDF};
char digsv[] { ILP,	ILP,	ILP,	DLP,	DLP,	ELP,	ELP,	ELP};
char decsv[] { DEC,	DEC,	DLP,	ENDF,	ENDF,	BAD,	BAD,	ENDF};
char desv[] { BAD,	BAD,	EXP,	BAD,	EXP,	BAD,	BAD,	BAD};
char miscsv[] { BAD,	BAD,	ENDI,	ENDF,	ENDF,	BAD,	BAD,	ENDF};

nconst()
{
/*
 * identify and check numeric constants.
 * check is done by a fsm defined by above state vectors.
 */
register int state;
register int c;
register char *p;
double f;
int dflag;

p = inptr;
state = START;
dflag = 0;
do
	{
	switch(c = *p++)
		{
	case '.':		/* decimal sign */
		if (chartype(p[0]) != ALPHA || (p[0] == 'e' && p[1] != 'q') || (p[0] == 'd'))
			{	/* not relational operator style "." */
			state = decsv[state];
			break;
			}
	default:
		if (c >= '0' && c <= '9')
			{
			state = digsv[state];
			break;
			}
		state = miscsv[state];
		break;
	case '+':
	case '-':
		state = signsv[state];
		break;
	case 'd':
		++dflag;
	case 'e':
		state = desv[state];
		break;
		}
	}
while (state < BAD);
--p;		/* point to last character */
switch(state)
	{
case ENDI:
	if (*p == 'h')
		return(sconst());
	else
		{
		c = intmode;	/* resulting mode */
		break;
		}
case ENDF:
	c = dflag ? REAL8 : REAL4;	/* get the mode */
	break;
default:
	ERR("bad numeric syntax",E_BADNUM);
	}
f = fltcvt(p-inptr);
if (c == INT2 && (f <= -32769.0 || f >= 32768.0))
	c = INT4;
return(fconst(f,c));
}

double fltcvt(len)
{
register char *p;
register int l;
register char *s;
double atof();
#define	MAXDIGITS	32
char numbuff[MAXDIGITS];

/*
 * prepare number for conversion by atof.
 * remove all + signs 
 */
p = numbuff;
l = len;
if (l >= MAXDIGITS)
	ERR("too many digits",E_DIGITS);
do
	{
	*p = *inptr;
	if (*p == 'd')
		*p = 'e';
	if (*p != '+')
		++p;
	++inptr;
	}
while (--l);
*p++ = 0;			/* terminate scan */
return(atof(numbuff));
}

fconst(f,ftype) double f;
{
register int i;
register char *s;
/*
 * lookup floating constant / enter it if not there.
 */
switch(ftype)
	{
case INT2:
case LOG1:
case LOG2:
	return(iconst(i=f,ftype));
case INT4:
	return(qconst(f,ftype));
case CMPLX8:
case CMPLX16:
	i = ftype-CMPLX8+REAL4;
	return(cconst(fconst(f,i),fconst(0.0,i),ftype));
default:
	ERROR("invalid type",E_BADTYPE);
case REAL4:
case REAL8:
	;
	}
for (s=fltchain; s; s=s->s_next)
	{
	if (s->s_type == ftype && s->s_float == f)
		return(s);
	}
clear(&symbol,SYMSIZE);
sym_float = f;
sym_len = HDRSIZE + FLOATLEN;
sym_type = ftype;
return(enterconst(&fltchain));
}

iconst(v,m)
{
/*
 * enter integer constant "v" in symbol table with mode "m".
 * return symbol table entry.
 */
register char *s;

if (m == INT4)
	return(qconst(v+0.0,m));		/* use long routine */
for (s=intchain; s; s=s->s_next)
	{
	if (s->s_type == m && s->s_int == v)
		return(s);	/* return existing entry */
	}
clear(&symbol,SYMSIZE);
sym_len = HDRSIZE + INTLEN;
sym_type = m;
symbol.s_int = v;
return(enterconst(&intchain));
}

qconst(v,m) double v;
{
/*
 * enter integer constant "v" in symbol table with mode "m".
 * return symbol table entry.
 */
register char *s;

for (s=intchain; s; s=s->s_next)
	{
	if (s->s_type == m && qload(s->s_qint) == v)
		return(s);	/* return existing entry */
	}
clear(&symbol,SYMSIZE);
sym_len = HDRSIZE + QINTLEN;
sym_type = m;
qstore(v,symbol.s_qint);	/* store it as integer*4 */
return(enterconst(&intchain));
}

sconst()
{
/*
 * get and enter a string.
 */
register char *s;
register struct string *q;
register int n;		/* string length */
int c;

#define	STRINGSIZE	(sizeof *q)
clear(&symbol,STRINGSIZE);
s = sym_string;
if(testc(QUOTE))
	{
	for (n=0;;)
		{
		c = *inptr++;
		*s++ = c;
		if (c == QUOTE)
			{
			if (*inptr == QUOTE)
				++inptr;		/* already put in quote */
			else
				break;
			}
		else if (c == BACKSLASH)
			s[-1] = backchar();
		if (++n > MAXSTRING)
			goto badstr;
		}
	n = --s - sym_string;			/* get string length */
	}
else
	{
	n = cvtint();
	if (n > MAXSTRING)
		goto badstr;
	if (*inptr++ == 'h')
		{
		if (n > length(inptr))
			ERR("incorrect string length",E_STRLEN);
		move(n,inptr,s);
		inptr =+ n;
		}
	else
		ERR("string expected",E_STRING);
	}
if ((sym_slen = n) == 0)		/* set string length */
	ERR("null string",E_NULLSTR);
return(senter());
badstr:
	ERR("string too long",E_STRLEN);
}

senter()
{
/*
 * lookup the string stored in "sym" and if not found enter
 * it.
 */
register char *s;
register int n;
register struct string *q;

n = sym_slen;
if (n >= (256-STRINGSIZE))
	ERR("string too long",E_STRLEN);
for (s=strchain; s; s=s->s_next)
	{
	if ( s->s_type==STRING && s->s_slen == n &&
	  eqstr(n,sym_string,s->s_string))
		return(cur_sym = (s));
	}
if (n&1)
	{
	sym_string[n] = ' ';	/* blank it */
	++n;			/* round the length */
	}
sym_len = n + STRINGSIZE;	/* get entry size */
sym_type = STRING;		/* a string */
sym_class = CONST;	/* constant entry */
sym_loc = CONST;
sym_next = strchain;
enter(&symbol);
return(strchain = cur_sym);
}

eqstr(len,s1,s2) char *s1, *s2;
{
/*
 * compare strings "s1" and "s2" of length "len" for
 * equality. 
 */
register int l;
register char *p1, *p2;

if ((l = len) == 0)
	return(OK);
p1 = s1; p2 = s2;
do
	if (*p1++ != *p2++)
		return(FAIL);
while (--l);
return(OK);
}

backchar()
{
/*
 * interpret character following a backslash as a special
 * character. note system dependency.
 */
register int c;
register int n;

c = *inptr++;
switch(c)
	{
case 'n':
	return('\n');
case 'r':
	return('\r');
case 't':
	return('\t');
default:
	if (c >= '0' && c <= '7')
		{
		n = 0;
		do
			n = (n << 3) + c - '0';
		while ((c = *inptr++) >= '0' && c <= '7');
		--inptr;
		return(n);
		}
	--inptr;
	return(BACKSLASH);	/* just a back slash */
	}
}

cconst(f1,f2,type) char *f1, *f2;
{
register struct complex *s;
register char *p;

for (p=cmplxchain; p; p = p->s_next)
	{
	if (p->s_type == type && p->s_real == f1 && p->s_imaginary == f2)
		return(p);
	}
clear(&symbol,sizeof *s);
symbol.s_real = f1;
symbol.s_imaginary = f2;
sym_len = sizeof *s;
sym_type = type;
return(enterconst(&cmplxchain));
}

enterconst(chain) char **chain;
{
/*
 * enter a constant into symbol table and link it onto its chain.
 */
sym_size = typelens[sym_type];
sym_class = sym_loc = CONST;
sym_next = *chain;
enter(&symbol);
return(*chain = cur_sym);
}
